/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.jardiff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jnlp.sample.jardiff.JarDiffConstants;
import jnlp.sample.jardiff.JarDiffPatcher;

public class JarDiff
implements JarDiffConstants {
    private static final int DEFAULT_READ_SIZE = 2048;
    private static byte[] newBytes = new byte[2048];
    private static byte[] oldBytes = new byte[2048];
    private static ResourceBundle _resources = null;
    private static boolean _debug;

    public static ResourceBundle getResources() {
        if (_resources == null) {
            _resources = ResourceBundle.getBundle("jnlp/sample/jardiff/resources/strings");
        }
        return _resources;
    }

    public static void createPatch(String string, String string2, OutputStream outputStream, boolean bl) throws IOException {
        String string3;
        Object object;
        Cloneable cloneable;
        JarFile2 jarFile2 = new JarFile2(string);
        JarFile2 jarFile22 = new JarFile2(string2);
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        HashSet hashSet = new HashSet();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<Object> hashSet4 = new HashSet<Object>();
        Iterator<Object> iterator = jarFile22.getJarEntries();
        if (iterator != null) {
            while (iterator.hasNext()) {
                cloneable = (JarEntry)iterator.next();
                object = ((ZipEntry)cloneable).getName();
                string3 = jarFile2.getBestMatch(jarFile22, (JarEntry)cloneable);
                if (string3 == null) {
                    if (_debug) {
                        System.out.println("NEW: " + (String)object);
                    }
                    hashSet4.add(object);
                    continue;
                }
                if (string3.equals(object) && !hashSet3.contains(string3)) {
                    if (_debug) {
                        System.out.println((String)object + " added to implicit set!");
                    }
                    hashSet2.add(object);
                    continue;
                }
                if (!bl && (hashSet2.contains(string3) || hashSet3.contains(string3))) {
                    if (_debug) {
                        System.out.println("NEW: " + (String)object);
                    }
                    hashSet4.add(object);
                } else {
                    if (_debug) {
                        System.err.println("moved.put " + (String)object + " " + string3);
                    }
                    hashMap.put(object, string3);
                    hashSet3.add(string3);
                }
                if (!hashSet2.contains(string3) || !bl) continue;
                if (_debug) {
                    System.err.println("implicit.remove " + string3);
                    System.err.println("moved.put " + string3 + " " + string3);
                }
                hashSet2.remove(string3);
                hashMap.put(string3, string3);
                hashSet3.add(string3);
            }
        }
        cloneable = new ArrayList();
        iterator = jarFile2.getJarEntries();
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (JarEntry)iterator.next();
                string3 = ((ZipEntry)object).getName();
                if (hashSet2.contains(string3) || hashSet3.contains(string3) || hashSet4.contains(string3)) continue;
                if (_debug) {
                    System.err.println("deleted.add " + string3);
                }
                ((ArrayList)cloneable).add(string3);
            }
        }
        if (_debug) {
            iterator = hashMap.keySet().iterator();
            if (iterator != null) {
                System.out.println("MOVED MAP!!!");
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    string3 = (String)hashMap.get(object);
                    System.out.println("key is " + (String)object + " value is " + string3);
                }
            }
            if ((iterator = hashSet2.iterator()) != null) {
                System.out.println("IMOVE MAP!!!");
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    System.out.println("key is " + (String)object);
                }
            }
        }
        object = new JarOutputStream(outputStream);
        JarDiff.createIndex((JarOutputStream)object, (List)((Object)cloneable), hashMap);
        iterator = hashSet4.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (_debug) {
                    System.out.println("New File: " + string3);
                }
                JarDiff.writeEntry((JarOutputStream)object, jarFile22.getEntryByName(string3), jarFile22);
            }
        }
        ((ZipOutputStream)object).finish();
    }

    private static void createIndex(JarOutputStream jarOutputStream, List list, Map map) throws IOException {
        Object object;
        Object object2;
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("version 1.0");
        stringWriter.write("\r\n");
        for (int i = 0; i < list.size(); ++i) {
            object2 = (String)list.get(i);
            stringWriter.write("remove");
            stringWriter.write(" ");
            JarDiff.writeEscapedString(stringWriter, (String)object2);
            stringWriter.write("\r\n");
        }
        Iterator iterator = map.keySet().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (String)map.get(object2);
                stringWriter.write("move");
                stringWriter.write(" ");
                JarDiff.writeEscapedString(stringWriter, (String)object);
                stringWriter.write(" ");
                JarDiff.writeEscapedString(stringWriter, (String)object2);
                stringWriter.write("\r\n");
            }
        }
        object2 = new JarEntry("META-INF/INDEX.JD");
        object = stringWriter.toString().getBytes("UTF-8");
        stringWriter.close();
        jarOutputStream.putNextEntry((ZipEntry)object2);
        jarOutputStream.write((byte[])object, 0, ((byte[])object).length);
    }

    private static void writeEscapedString(Writer writer, String string) throws IOException {
        int n = 0;
        int n2 = 0;
        char[] cArray = null;
        while ((n = string.indexOf(32, n)) != -1) {
            if (n2 != n) {
                if (cArray == null) {
                    cArray = string.toCharArray();
                }
                writer.write(cArray, n2, n - n2);
            }
            n2 = n++;
            writer.write(92);
        }
        if (n2 != 0) {
            writer.write(cArray, n2, cArray.length - n2);
        } else {
            writer.write(string);
        }
    }

    private static void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, JarFile2 jarFile2) throws IOException {
        JarDiff.writeEntry(jarOutputStream, jarEntry, jarFile2.getJarFile().getInputStream(jarEntry));
    }

    private static void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, InputStream inputStream) throws IOException {
        jarOutputStream.putNextEntry(jarEntry);
        int n = inputStream.read(newBytes);
        while (n != -1) {
            jarOutputStream.write(newBytes, 0, n);
            n = inputStream.read(newBytes);
        }
        inputStream.close();
    }

    private static void showHelp() {
        System.out.println("JarDiff: [-nonminimal (for backward compatibility with 1.0.1/1.0] [-creatediff | -applydiff] [-output file] old.jar new.jar");
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = true;
        boolean bl2 = true;
        String string = "out.jardiff";
        for (int i = 0; i < stringArray.length; ++i) {
            FileOutputStream fileOutputStream;
            if (stringArray[i].equals("-nonminimal") || stringArray[i].equals("-n")) {
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-creatediff") || stringArray[i].equals("-c")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-applydiff") || stringArray[i].equals("-a")) {
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-debug") || stringArray[i].equals("-d")) {
                _debug = true;
                continue;
            }
            if (stringArray[i].equals("-output") || stringArray[i].equals("-o")) {
                if (++i >= stringArray.length) continue;
                string = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-applydiff") || stringArray[i].equals("-a")) {
                bl = false;
                continue;
            }
            if (i + 2 != stringArray.length) {
                JarDiff.showHelp();
                System.exit(0);
            }
            if (bl) {
                try {
                    fileOutputStream = new FileOutputStream(string);
                    JarDiff.createPatch(stringArray[i], stringArray[i + 1], fileOutputStream, bl2);
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    try {
                        System.out.println(JarDiff.getResources().getString("jardiff.error.create") + " " + iOException);
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
            } else {
                try {
                    fileOutputStream = new FileOutputStream(string);
                    new JarDiffPatcher().applyPatch(null, stringArray[i], stringArray[i + 1], fileOutputStream);
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    try {
                        System.out.println(JarDiff.getResources().getString("jardiff.error.apply") + " " + iOException);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
            }
            System.exit(0);
        }
        JarDiff.showHelp();
    }

    private static class JarFile2 {
        private JarFile _jar;
        private List _entries;
        private HashMap _nameToEntryMap;
        private HashMap _crcToEntryMap;

        public JarFile2(String string) throws IOException {
            this._jar = new JarFile(new File(string));
            this.index();
        }

        public JarFile getJarFile() {
            return this._jar;
        }

        public Iterator getJarEntries() {
            return this._entries.iterator();
        }

        public JarEntry getEntryByName(String string) {
            return (JarEntry)this._nameToEntryMap.get(string);
        }

        private static boolean differs(InputStream inputStream, InputStream inputStream2) throws IOException {
            int n = 0;
            int n2 = 0;
            while (n != -1) {
                int n3;
                n = inputStream2.read(newBytes);
                if (n != (n3 = inputStream.read(oldBytes))) {
                    if (_debug) {
                        System.out.println("\tread sizes differ: " + n + " " + n3 + " total " + n2);
                    }
                    return true;
                }
                if (n <= 0) continue;
                while (--n >= 0) {
                    ++n2;
                    if (newBytes[n] == oldBytes[n]) continue;
                    if (_debug) {
                        System.out.println("\tbytes differ at " + n2);
                    }
                    return true;
                }
                n = 0;
            }
            return false;
        }

        public String getBestMatch(JarFile2 jarFile2, JarEntry jarEntry) throws IOException {
            if (this.contains(jarFile2, jarEntry)) {
                return jarEntry.getName();
            }
            return this.hasSameContent(jarFile2, jarEntry);
        }

        public boolean contains(JarFile2 jarFile2, JarEntry jarEntry) throws IOException {
            InputStream inputStream;
            JarEntry jarEntry2 = this.getEntryByName(jarEntry.getName());
            if (jarEntry2 == null) {
                return false;
            }
            if (jarEntry2.getCrc() != jarEntry.getCrc()) {
                return false;
            }
            InputStream inputStream2 = this.getJarFile().getInputStream(jarEntry2);
            boolean bl = JarFile2.differs(inputStream2, inputStream = jarFile2.getJarFile().getInputStream(jarEntry));
            return !bl;
        }

        public String hasSameContent(JarFile2 jarFile2, JarEntry jarEntry) throws IOException {
            LinkedList linkedList;
            ListIterator listIterator;
            String string = null;
            Long l = new Long(jarEntry.getCrc());
            if (this._crcToEntryMap.containsKey(l) && (listIterator = (linkedList = (LinkedList)this._crcToEntryMap.get(l)).listIterator(0)) != null) {
                while (listIterator.hasNext()) {
                    InputStream inputStream;
                    JarEntry jarEntry2 = (JarEntry)listIterator.next();
                    InputStream inputStream2 = this.getJarFile().getInputStream(jarEntry2);
                    if (JarFile2.differs(inputStream2, inputStream = jarFile2.getJarFile().getInputStream(jarEntry))) continue;
                    string = jarEntry2.getName();
                    return string;
                }
            }
            return string;
        }

        private void index() throws IOException {
            Enumeration<JarEntry> enumeration = this._jar.entries();
            this._nameToEntryMap = new HashMap();
            this._crcToEntryMap = new HashMap();
            this._entries = new ArrayList();
            if (_debug) {
                System.out.println("indexing: " + this._jar.getName());
            }
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    LinkedList linkedList;
                    JarEntry jarEntry = enumeration.nextElement();
                    long l = jarEntry.getCrc();
                    Long l2 = new Long(l);
                    if (_debug) {
                        System.out.println("\t" + jarEntry.getName() + " CRC " + l);
                    }
                    this._nameToEntryMap.put(jarEntry.getName(), jarEntry);
                    this._entries.add(jarEntry);
                    if (this._crcToEntryMap.containsKey(l2)) {
                        linkedList = (LinkedList)this._crcToEntryMap.get(l2);
                        linkedList.add(jarEntry);
                        this._crcToEntryMap.put(l2, linkedList);
                        continue;
                    }
                    linkedList = new LinkedList();
                    linkedList.add(jarEntry);
                    this._crcToEntryMap.put(l2, linkedList);
                }
            }
        }
    }
}

