/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import sun.rmi.registry.RegistryImpl;

public class ActivationGroupImpl
extends ActivationGroup {
    private static final long serialVersionUID = 5758693559430427303L;
    private Hashtable active = new Hashtable(101);
    private boolean groupInactive = false;
    private ActivationGroupID groupID;
    private ArrayList lockedIDs = new ArrayList();
    private static Class[] objConstrParams = new Class[]{ActivationID.class, MarshalledObject.class};

    public ActivationGroupImpl(ActivationGroupID activationGroupID, MarshalledObject marshalledObject) throws RemoteException {
        super(activationGroupID);
        this.groupID = activationGroupID;
        if (System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (Exception exception) {
                throw new RemoteException("unable to set security manager", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(ActivationID activationID) {
        while (true) {
            ActivationID activationID2;
            Serializable serializable = this.lockedIDs;
            synchronized (serializable) {
                int n = this.lockedIDs.indexOf(activationID);
                if (n < 0) {
                    this.lockedIDs.add(activationID);
                    return;
                }
                activationID2 = (ActivationID)this.lockedIDs.get(n);
            }
            serializable = activationID2;
            synchronized (serializable) {
                ArrayList arrayList = this.lockedIDs;
                synchronized (arrayList) {
                    int n = this.lockedIDs.indexOf(activationID2);
                    if (n < 0) {
                        continue;
                    }
                    ActivationID activationID3 = (ActivationID)this.lockedIDs.get(n);
                    if (activationID3 != activationID2) {
                        continue;
                    }
                }
                try {
                    activationID2.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(ActivationID activationID) {
        Serializable serializable = this.lockedIDs;
        synchronized (serializable) {
            activationID = (ActivationID)this.lockedIDs.remove(this.lockedIDs.indexOf(activationID));
        }
        serializable = activationID;
        synchronized (serializable) {
            activationID.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarshalledObject newInstance(final ActivationID activationID, final ActivationDesc activationDesc) throws ActivationException, RemoteException {
        MarshalledObject marshalledObject;
        RegistryImpl.checkAccess("ActivationInstantiator.newInstance");
        if (!this.groupID.equals(activationDesc.getGroupID())) {
            throw new ActivationException("newInstance in wrong group");
        }
        try {
            try {
                Remote remote;
                Object object;
                block20: {
                    this.acquireLock(activationID);
                    object = this;
                    synchronized (object) {
                        if (this.groupInactive) {
                            throw new ActivationException("group is inactive");
                        }
                    }
                    object = (ActiveEntry)this.active.get(activationID);
                    if (object != null) {
                        MarshalledObject marshalledObject2 = ((ActiveEntry)object).mobj;
                        Object var14_10 = null;
                        this.releaseLock(activationID);
                        this.checkInactiveGroup();
                        return marshalledObject2;
                    }
                    String string = activationDesc.getClassName();
                    final Class<?> clazz = RMIClassLoader.loadClass(activationDesc.getLocation(), string);
                    remote = null;
                    final Thread thread = Thread.currentThread();
                    final ClassLoader classLoader = thread.getContextClassLoader();
                    ClassLoader classLoader2 = clazz.getClassLoader();
                    final ClassLoader classLoader3 = ActivationGroupImpl.covers(classLoader2, classLoader) ? classLoader2 : classLoader;
                    try {
                        remote = (Remote)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Object run() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                                Constructor constructor = clazz.getDeclaredConstructor(objConstrParams);
                                constructor.setAccessible(true);
                                Object[] objectArray = new Object[]{activationID, activationDesc.getData()};
                                try {
                                    thread.setContextClassLoader(classLoader3);
                                    Remote remote = (Remote)constructor.newInstance(objectArray);
                                    Object var5_4 = null;
                                    thread.setContextClassLoader(classLoader);
                                    return remote;
                                }
                                catch (Throwable throwable) {
                                    Object var5_5 = null;
                                    thread.setContextClassLoader(classLoader);
                                    throw throwable;
                                }
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof InstantiationException) {
                            throw (InstantiationException)exception;
                        }
                        if (exception instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)exception;
                        }
                        if (exception instanceof IllegalAccessException) {
                            throw (IllegalAccessException)exception;
                        }
                        if (exception instanceof InvocationTargetException) {
                            throw (InvocationTargetException)exception;
                        }
                        if (exception instanceof RuntimeException) {
                            throw (RuntimeException)exception;
                        }
                        if (!(exception instanceof Error)) break block20;
                        throw (Error)((Object)exception);
                    }
                }
                object = new ActiveEntry(remote);
                this.active.put(activationID, object);
                marshalledObject = ((ActiveEntry)object).mobj;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodError);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ActivationException("exception in object constructor", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new ActivationException("unable to activate object", exception);
            }
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
        Object var14_11 = null;
        this.releaseLock(activationID);
        this.checkInactiveGroup();
        return marshalledObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            block10: {
                boolean bl;
                this.acquireLock(activationID);
                Object object = this;
                synchronized (object) {
                    if (this.groupInactive) {
                        throw new ActivationException("group is inactive");
                    }
                }
                object = (ActiveEntry)this.active.get(activationID);
                if (object == null) {
                    throw new UnknownObjectException("object not active");
                }
                try {
                    if (Activatable.unexportObject(((ActiveEntry)object).impl, false)) break block10;
                    bl = false;
                }
                catch (NoSuchObjectException bl2) {
                    // empty catch block
                    break block10;
                }
                Object var5_6 = null;
                this.releaseLock(activationID);
                this.checkInactiveGroup();
                return bl;
            }
            try {
                super.inactiveObject(activationID);
            }
            catch (UnknownObjectException noSuchObjectException) {
                // empty catch block
            }
            this.active.remove(activationID);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
        Object var5_7 = null;
        this.releaseLock(activationID);
        this.checkInactiveGroup();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInactiveGroup() {
        boolean bl = false;
        ActivationGroupImpl activationGroupImpl = this;
        synchronized (activationGroupImpl) {
            if (this.active.size() == 0 && this.lockedIDs.size() == 0 && !this.groupInactive) {
                this.groupInactive = true;
                bl = true;
            }
        }
        if (bl) {
            try {
                super.inactiveGroup();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeObject(ActivationID activationID, Remote remote) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(activationID);
            Object object = this;
            synchronized (object) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            if (!this.active.contains(activationID)) {
                object = new ActiveEntry(remote);
                this.active.put(activationID, object);
                super.activeObject(activationID, ((ActiveEntry)object).mobj);
            }
            Object var6_5 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseLock(activationID);
            this.checkInactiveGroup();
            throw throwable;
        }
    }

    private static boolean covers(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader == null) {
            return false;
        }
        do {
            if (classLoader != classLoader2) continue;
            return true;
        } while ((classLoader = classLoader.getParent()) != null);
        return false;
    }

    private static class ActiveEntry {
        Remote impl;
        MarshalledObject mobj;

        ActiveEntry(Remote remote) throws ActivationException {
            this.impl = remote;
            try {
                this.mobj = new MarshalledObject(remote);
            }
            catch (IOException iOException) {
                throw new ActivationException("failed to marshal remote object", iOException);
            }
        }
    }
}

