/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import com.sun.jmx.remote.internal.RMIExporter;
import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.security.KeyStore;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.security.auth.Subject;
import sun.management.Agent;
import sun.management.AgentConfigurationError;
import sun.management.ConnectorAddressLink;
import sun.management.FileSystem;
import sun.management.jmxremote.LocalRMIServerSocketFactory;
import sun.management.jmxremote.SSLContextRMIServerSocketFactory;
import sun.management.jmxremote.SingleEntryRegistry;
import sun.management.snmp.util.MibLogger;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.LiveRef;

public final class ConnectorBootstrap {
    private static final MibLogger log = new MibLogger(ConnectorBootstrap.class);

    public static synchronized JMXConnectorServer initialize() {
        Properties properties = Agent.loadManagementProperties();
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("com.sun.management.jmxremote.port");
        return ConnectorBootstrap.initialize(string, properties);
    }

    public static synchronized JMXConnectorServer initialize(String string, Properties properties) {
        Object object;
        int n;
        Object object2;
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.port", numberFormatException, string);
        }
        if (n2 < 0) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.port", string);
        }
        String string2 = properties.getProperty("com.sun.management.jmxremote.authenticate", "true");
        boolean bl = Boolean.valueOf(string2);
        String string3 = properties.getProperty("com.sun.management.jmxremote.ssl", "true");
        boolean bl2 = Boolean.valueOf(string3);
        String string4 = properties.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites");
        String[] stringArray = null;
        if (string4 != null) {
            object2 = new StringTokenizer(string4, ",");
            int n3 = ((StringTokenizer)object2).countTokens();
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = ((StringTokenizer)object2).nextToken();
            }
        }
        object2 = properties.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols");
        String[] stringArray2 = null;
        if (object2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ",");
            n = stringTokenizer.countTokens();
            stringArray2 = new String[n];
            for (int i = 0; i < n; i += 1) {
                stringArray2[i] = stringTokenizer.nextToken();
            }
        }
        String string5 = properties.getProperty("com.sun.management.jmxremote.ssl.need.client.auth", "false");
        n = Boolean.valueOf(string5).booleanValue() ? 1 : 0;
        String string6 = properties.getProperty("com.sun.management.jmxremote.ssl.config.file");
        String string7 = null;
        String string8 = null;
        String string9 = null;
        if (bl) {
            string7 = properties.getProperty("com.sun.management.jmxremote.login.config");
            if (string7 == null) {
                string8 = properties.getProperty("com.sun.management.jmxremote.password.file", ConnectorBootstrap.getDefaultFileName("jmxremote.password"));
                ConnectorBootstrap.checkPasswordFile(string8);
            }
            string9 = properties.getProperty("com.sun.management.jmxremote.access.file", ConnectorBootstrap.getDefaultFileName("jmxremote.access"));
            ConnectorBootstrap.checkAccessFile(string9);
        }
        if (log.isDebugOn()) {
            log.debug("initialize", Agent.getText("jmxremote.ConnectorBootstrap.initialize") + "\n\t" + "com.sun.management.jmxremote.port" + "=" + n2 + "\n\t" + "com.sun.management.jmxremote.ssl" + "=" + bl2 + "\n\t" + "com.sun.management.jmxremote.ssl.config.file" + "=" + string6 + "\n\t" + "com.sun.management.jmxremote.ssl.enabled.cipher.suites" + "=" + string4 + "\n\t" + "com.sun.management.jmxremote.ssl.enabled.protocols" + "=" + (String)object2 + "\n\t" + "com.sun.management.jmxremote.ssl.need.client.auth" + "=" + (n != 0) + "\n\t" + "com.sun.management.jmxremote.authenticate" + "=" + bl + (bl ? (string7 == null ? "\n\tcom.sun.management.jmxremote.password.file=" + string8 : "\n\tcom.sun.management.jmxremote.login.config=" + string7) : "\n\t" + Agent.getText("jmxremote.ConnectorBootstrap.initialize.noAuthentication")) + (bl ? "\n\tcom.sun.management.jmxremote.access.file=" + string9 : "") + "");
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        JMXConnectorServer jMXConnectorServer = null;
        JMXServiceURL jMXServiceURL = null;
        try {
            object = ConnectorBootstrap.exportMBeanServer(mBeanServer, n2, bl2, string6, stringArray, stringArray2, n != 0, bl, string7, string8, string9);
            jMXConnectorServer = ((JMXConnectorServerData)object).jmxConnectorServer;
            jMXServiceURL = ((JMXConnectorServerData)object).jmxRemoteURL;
            log.config("initialize", Agent.getText("jmxremote.ConnectorBootstrap.initialize.ready", jMXServiceURL.toString()));
        }
        catch (Exception exception) {
            throw new AgentConfigurationError("agent.err.exception", exception, exception.toString());
        }
        try {
            object = new HashMap();
            object.put("remoteAddress", jMXServiceURL.toString());
            object.put("authenticate", string2);
            object.put("ssl", string3);
            object.put("sslRegistry", "false");
            object.put("sslNeedClientAuth", string5);
            ConnectorAddressLink.exportRemote((Map<String, String>)object);
        }
        catch (Exception exception) {
            log.debug("initialize", exception);
        }
        return jMXConnectorServer;
    }

    public static JMXConnectorServer startLocalConnectorServer() {
        System.setProperty("java.rmi.server.randomIDs", "true");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("com.sun.jmx.remote.rmi.exporter", new PermanentExporter());
        String string = "localhost";
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (inetAddress == null || !inetAddress.isLoopbackAddress()) {
            string = "127.0.0.1";
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", string, 0);
            Properties properties = Agent.getManagementProperties();
            String string2 = properties.getProperty("com.sun.management.jmxremote.local.only", "true");
            boolean bl = Boolean.valueOf(string2);
            if (bl) {
                hashMap.put("jmx.remote.rmi.server.socket.factory", new LocalRMIServerSocketFactory());
            }
            JMXConnectorServer jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, mBeanServer);
            jMXConnectorServer.start();
            return jMXConnectorServer;
        }
        catch (Exception exception) {
            throw new AgentConfigurationError("agent.err.exception", exception, exception.toString());
        }
    }

    private static void checkPasswordFile(String string) {
        if (string == null || string.length() == 0) {
            throw new AgentConfigurationError("agent.err.password.file.notset");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.password.file.notfound", string);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.password.file.not.readable", string);
        }
        FileSystem fileSystem = FileSystem.open();
        try {
            if (fileSystem.supportsFileSecurity(file) && !fileSystem.isAccessUserOnly(file)) {
                String string2 = Agent.getText("jmxremote.ConnectorBootstrap.initialize.password.readonly", string);
                log.config("initialize", string2);
                throw new AgentConfigurationError("agent.err.password.file.access.notrestricted", string);
            }
        }
        catch (IOException iOException) {
            throw new AgentConfigurationError("agent.err.password.file.read.failed", iOException, string);
        }
    }

    private static void checkAccessFile(String string) {
        if (string == null || string.length() == 0) {
            throw new AgentConfigurationError("agent.err.access.file.notset");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.access.file.notfound", string);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.access.file.not.readable", string);
        }
    }

    private static void checkRestrictedFile(String string) {
        if (string == null || string.length() == 0) {
            throw new AgentConfigurationError("agent.err.file.not.set");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.file.not.found", string);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.file.not.readable", string);
        }
        FileSystem fileSystem = FileSystem.open();
        try {
            if (fileSystem.supportsFileSecurity(file) && !fileSystem.isAccessUserOnly(file)) {
                String string2 = Agent.getText("jmxremote.ConnectorBootstrap.initialize.file.readonly", string);
                log.config("initialize", string2);
                throw new AgentConfigurationError("agent.err.file.access.not.restricted", string);
            }
        }
        catch (IOException iOException) {
            throw new AgentConfigurationError("agent.err.file.read.failed", iOException, string);
        }
    }

    private static String getDefaultFileName(String string) {
        String string2 = File.separator;
        return System.getProperty("java.home") + string2 + "lib" + string2 + "management" + string2 + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SslRMIServerSocketFactory createSslRMIServerSocketFactory(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        if (string == null) {
            return new SslRMIServerSocketFactory(stringArray, stringArray2, bl);
        }
        ConnectorBootstrap.checkRestrictedFile(string);
        try {
            Object object;
            Object object2;
            Object object3;
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string);
            try {
                object3 = new BufferedInputStream(fileInputStream);
                properties.load((InputStream)object3);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
            object3 = properties.getProperty("javax.net.ssl.keyStore");
            String string2 = properties.getProperty("javax.net.ssl.keyStorePassword", "");
            String string3 = properties.getProperty("javax.net.ssl.trustStore");
            String string4 = properties.getProperty("javax.net.ssl.trustStorePassword", "");
            char[] cArray = null;
            if (string2.length() != 0) {
                cArray = string2.toCharArray();
            }
            char[] cArray2 = null;
            if (string4.length() != 0) {
                cArray2 = string4.toCharArray();
            }
            KeyStore keyStore = null;
            if (object3 != null) {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                object2 = new FileInputStream((String)object3);
                try {
                    keyStore.load((InputStream)object2, cArray);
                }
                finally {
                    ((FileInputStream)object2).close();
                }
            }
            object2 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ((KeyManagerFactory)object2).init(keyStore, cArray);
            KeyStore keyStore2 = null;
            if (string3 != null) {
                keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                object = new FileInputStream(string3);
                try {
                    keyStore2.load((InputStream)object, cArray2);
                }
                finally {
                    ((FileInputStream)object).close();
                }
            }
            object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init(keyStore2);
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(((KeyManagerFactory)object2).getKeyManagers(), ((TrustManagerFactory)object).getTrustManagers(), null);
            return new SSLContextRMIServerSocketFactory(sSLContext, stringArray, stringArray2, bl);
        }
        catch (Exception exception) {
            throw new AgentConfigurationError("agent.err.exception", exception, exception.toString());
        }
    }

    private static JMXConnectorServerData exportMBeanServer(MBeanServer mBeanServer, int n, boolean bl, String string, String[] stringArray, String[] stringArray2, boolean bl2, boolean bl3, String string2, String string3, String string4) throws IOException, MalformedURLException {
        int n2;
        Object object;
        Object object2;
        Object object3;
        System.setProperty("java.rmi.server.randomIDs", "true");
        JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", null, 0);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PermanentExporter permanentExporter = new PermanentExporter();
        hashMap.put("com.sun.jmx.remote.rmi.exporter", permanentExporter);
        if (bl3) {
            if (string2 != null) {
                hashMap.put("jmx.remote.x.login.config", string2);
            }
            if (string3 != null) {
                hashMap.put("jmx.remote.x.password.file", string3);
            }
            hashMap.put("jmx.remote.x.access.file", string4);
            if (hashMap.get("jmx.remote.x.password.file") != null || hashMap.get("jmx.remote.x.login.config") != null) {
                hashMap.put("jmx.remote.authenticator", new AccessFileCheckerAuthenticator(hashMap));
            }
        }
        if (bl) {
            object3 = new SslRMIClientSocketFactory();
            object2 = ConnectorBootstrap.createSslRMIServerSocketFactory(string, stringArray, stringArray2, bl2);
            hashMap.put("jmx.remote.rmi.client.socket.factory", object3);
            hashMap.put("jmx.remote.rmi.server.socket.factory", object2);
        }
        object3 = null;
        try {
            object3 = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, mBeanServer);
            object3.start();
        }
        catch (IOException iOException) {
            if (object3 == null) {
                throw new AgentConfigurationError("agent.err.connector.server.io.error", iOException, jMXServiceURL.toString());
            }
            throw new AgentConfigurationError("agent.err.connector.server.io.error", iOException, object3.getAddress().toString());
        }
        object2 = new SingleEntryRegistry(n, "jmxrmi", permanentExporter.firstExported);
        try {
            object = UnicastRef.class.getDeclaredField("ref");
            ((AccessibleObject)object).setAccessible(true);
            UnicastRef unicastRef = (UnicastRef)((RemoteObject)object2).getRef();
            n2 = ((LiveRef)((Field)object).get(unicastRef)).getPort();
        }
        catch (Exception exception) {
            n2 = n;
            log.debug("initialize", exception);
        }
        object = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + jMXServiceURL.getHost() + ":" + n2 + "/jmxrmi");
        return new JMXConnectorServerData((JMXConnectorServer)object3, (JMXServiceURL)object);
    }

    private ConnectorBootstrap() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessFileCheckerAuthenticator
    implements JMXAuthenticator {
        private final Map<String, Object> environment;
        private final Properties properties;
        private final String accessFile;

        public AccessFileCheckerAuthenticator(Map<String, Object> map) throws IOException {
            this.environment = map;
            this.accessFile = (String)map.get("jmx.remote.x.access.file");
            this.properties = AccessFileCheckerAuthenticator.propertiesFromFile(this.accessFile);
        }

        @Override
        public Subject authenticate(Object object) {
            JMXPluggableAuthenticator jMXPluggableAuthenticator = new JMXPluggableAuthenticator(this.environment);
            Subject subject = jMXPluggableAuthenticator.authenticate(object);
            this.checkAccessFileEntries(subject);
            return subject;
        }

        private void checkAccessFileEntries(Subject subject) {
            if (subject == null) {
                throw new SecurityException("Access denied! No matching entries found in the access file [" + this.accessFile + "] as the " + "authenticated Subject is null");
            }
            Set<Principal> set = subject.getPrincipals();
            for (Principal object : set) {
                if (!this.properties.containsKey(object.getName())) continue;
                return;
            }
            HashSet hashSet = new HashSet();
            for (Principal principal : set) {
                hashSet.add(principal.getName());
            }
            throw new SecurityException("Access denied! No entries found in the access file [" + this.accessFile + "] for any of the authenticated identities " + hashSet);
        }

        private static Properties propertiesFromFile(String string) throws IOException {
            Properties properties = new Properties();
            if (string == null) {
                return properties;
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            return properties;
        }
    }

    public static interface DefaultValues {
        public static final String PORT = "0";
        public static final String CONFIG_FILE_NAME = "management.properties";
        public static final String USE_LOCAL_ONLY = "true";
        public static final String USE_SSL = "true";
        public static final String USE_AUTHENTICATION = "true";
        public static final String PASSWORD_FILE_NAME = "jmxremote.password";
        public static final String ACCESS_FILE_NAME = "jmxremote.access";
        public static final String SSL_NEED_CLIENT_AUTH = "false";
    }

    private static class JMXConnectorServerData {
        JMXConnectorServer jmxConnectorServer;
        JMXServiceURL jmxRemoteURL;

        public JMXConnectorServerData(JMXConnectorServer jMXConnectorServer, JMXServiceURL jMXServiceURL) {
            this.jmxConnectorServer = jMXConnectorServer;
            this.jmxRemoteURL = jMXServiceURL;
        }
    }

    private static class PermanentExporter
    implements RMIExporter {
        Remote firstExported;

        private PermanentExporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Remote exportObject(Remote remote, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
            Object object = this;
            synchronized (object) {
                if (this.firstExported == null) {
                    this.firstExported = remote;
                }
            }
            object = rMIClientSocketFactory == null && rMIServerSocketFactory == null ? new UnicastServerRef(n) : new UnicastServerRef2(n, rMIClientSocketFactory, rMIServerSocketFactory);
            return ((UnicastServerRef)object).exportObject(remote, null, true);
        }

        public boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
            return UnicastRemoteObject.unexportObject(remote, bl);
        }
    }

    public static interface PropertyNames {
        public static final String PORT = "com.sun.management.jmxremote.port";
        public static final String CONFIG_FILE_NAME = "com.sun.management.config.file";
        public static final String USE_LOCAL_ONLY = "com.sun.management.jmxremote.local.only";
        public static final String USE_SSL = "com.sun.management.jmxremote.ssl";
        public static final String USE_AUTHENTICATION = "com.sun.management.jmxremote.authenticate";
        public static final String PASSWORD_FILE_NAME = "com.sun.management.jmxremote.password.file";
        public static final String ACCESS_FILE_NAME = "com.sun.management.jmxremote.access.file";
        public static final String LOGIN_CONFIG_NAME = "com.sun.management.jmxremote.login.config";
        public static final String SSL_ENABLED_CIPHER_SUITES = "com.sun.management.jmxremote.ssl.enabled.cipher.suites";
        public static final String SSL_ENABLED_PROTOCOLS = "com.sun.management.jmxremote.ssl.enabled.protocols";
        public static final String SSL_NEED_CLIENT_AUTH = "com.sun.management.jmxremote.ssl.need.client.auth";
        public static final String SSL_CONFIG_FILE_NAME = "com.sun.management.jmxremote.ssl.config.file";
    }
}

