/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcStatement;

public class JdbcOdbcInputStream
extends InputStream {
    protected JdbcOdbc OdbcApi;
    protected long hStmt;
    protected int column;
    protected short type;
    public static final short ASCII = 1;
    public static final short UNICODE = 2;
    public static final short BINARY = 3;
    public static final short LOCAL = 4;
    public static final short CHARACTER = 5;
    protected byte[] localByteArray;
    protected int localOffset;
    protected boolean invalid;
    protected boolean highRead;
    protected int sqlType;
    protected byte[] buf;
    public static final int MAX_BUF_LEN = 5120;
    protected int convertType;
    public static final int CONVERT_NONE = 0;
    public static final int CONVERT_UNICODE = 1;
    public static final int CONVERT_ASCII = 2;
    public static final int CONVERT_BOTH = 3;
    protected int convertMultiplier;
    protected int bytesInBuf;
    protected int bufOffset;
    protected Statement ownerStatement;

    public JdbcOdbcInputStream(JdbcOdbc jdbcOdbc, long l, int n, short s, int n2, Statement statement) {
        this.OdbcApi = jdbcOdbc;
        this.hStmt = l;
        this.column = n;
        this.type = s;
        this.invalid = false;
        this.ownerStatement = statement;
        this.sqlType = -2;
        switch (n2) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                this.sqlType = 1;
            }
        }
        this.convertMultiplier = 1;
        this.convertType = 0;
        switch (this.type) {
            case 1: {
                if (this.sqlType != -2) break;
                this.convertMultiplier = 2;
                this.convertType = 2;
                break;
            }
            case 2: {
                if (this.sqlType == -2) {
                    this.convertType = 3;
                    this.convertMultiplier = 4;
                    break;
                }
                this.convertType = 1;
                this.convertMultiplier = 2;
                break;
            }
            case 5: {
                this.convertType = 0;
                this.convertMultiplier = 1;
            }
        }
        this.buf = new byte[5120 * this.convertMultiplier];
        this.bytesInBuf = 0;
        this.bufOffset = 0;
    }

    public JdbcOdbcInputStream(JdbcOdbc jdbcOdbc, long l, int n, byte[] byArray) {
        this.OdbcApi = jdbcOdbc;
        this.hStmt = l;
        this.column = n;
        this.type = (short)4;
        this.localByteArray = byArray;
        this.localOffset = 0;
        this.invalid = false;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n != -1) {
            n = byArray[0] & 0xFF;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public byte[] readAllData() throws IOException {
        byte[] byArray;
        int n = 0;
        if (this.invalid) {
            throw new IOException("InputStream is no longer valid - the Statement has been closed, or the cursor has been moved");
        }
        switch (this.type) {
            case 4: {
                if (this.localOffset + n > this.localByteArray.length) {
                    n = this.localByteArray.length - this.localOffset;
                }
                byArray = new byte[this.localByteArray.length];
                if (n == 0) {
                    n = -1;
                    break;
                }
                System.arraycopy(this.localByteArray, this.localOffset, byArray, this.localOffset, n);
                this.localOffset += n;
                break;
            }
            default: {
                byArray = this.readData();
            }
        }
        return byArray;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        if (this.invalid) {
            throw new IOException("InputStream is no longer valid - the Statement has been closed, or the cursor has been moved");
        }
        switch (this.type) {
            case 4: {
                n3 = n2;
                if (this.localOffset + n3 > this.localByteArray.length) {
                    n3 = this.localByteArray.length - this.localOffset;
                }
                if (n3 == 0) {
                    n3 = -1;
                    break;
                }
                for (int i = n; i < n3; ++i) {
                    byArray[i] = this.localByteArray[this.localOffset + i];
                }
                this.localOffset += n3;
                break;
            }
            default: {
                n3 = this.readData(byArray, n, n2);
            }
        }
        return n3;
    }

    public int available() throws IOException {
        throw new IOException();
    }

    public void invalidate() {
        this.invalid = true;
    }

    public byte[] readData() throws IOException {
        byte[] byArray = null;
        int n = 0;
        while (true) {
            this.bytesInBuf = this.readBinaryData(this.buf, 5120);
            this.bytesInBuf = this.convertData(this.buf, this.bytesInBuf);
            if (this.bytesInBuf == -1) {
                return byArray;
            }
            try {
                if (byArray == null) {
                    byArray = new byte[this.bytesInBuf];
                } else {
                    byte[] byArray2 = new byte[n + this.bytesInBuf];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    byArray = byArray2;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ((JdbcOdbcStatement)this.ownerStatement).setWarning(new SQLWarning("Data has been truncated. " + outOfMemoryError.getMessage()));
                return byArray;
            }
            System.arraycopy(this.buf, 0, byArray, n, this.bytesInBuf);
            n += this.bytesInBuf;
        }
    }

    protected int readData(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        int n4 = n;
        while (this.bytesInBuf != -1 && n4 - n < n2) {
            if (this.bufOffset >= this.bytesInBuf) {
                this.bytesInBuf = this.readBinaryData(this.buf, 5120);
                this.bytesInBuf = this.convertData(this.buf, this.bytesInBuf);
                this.bufOffset = 0;
                continue;
            }
            byArray[n4] = this.buf[this.bufOffset];
            ++n4;
            ++this.bufOffset;
        }
        if (n4 > n) {
            n3 = n4;
        }
        return n3;
    }

    protected int readBinaryData(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        try {
            n2 = this.OdbcApi.SQLGetDataBinary(this.hStmt, this.column, -2, byArray, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            Integer n3 = (Integer)jdbcOdbcSQLWarning.value;
            n2 = n3;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        return n2;
    }

    protected int convertData(byte[] byArray, int n) {
        if (this.convertType == 0) {
            return n;
        }
        String string = "0123456789ABCDEF";
        if (n <= 0) {
            return n;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (this.convertType == 3) {
                byArray[i * 4 + 3] = (byte)string.charAt(byArray[i] & 0xF);
                byArray[i * 4 + 2] = 0;
                byArray[i * 4 + 1] = (byte)string.charAt(byArray[i] >> 4 & 0xF);
                byArray[i * 4] = 0;
                continue;
            }
            if (this.convertType == 2) {
                byArray[i * 2 + 1] = (byte)string.charAt(byArray[i] & 0xF);
                byArray[i * 2] = (byte)string.charAt(byArray[i] >> 4 & 0xF);
                continue;
            }
            byArray[i * 2 + 1] = byArray[i];
            byArray[i * 2] = 0;
        }
        return n * this.convertMultiplier;
    }
}

