/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Map;
import sun.text.CodePointIterator;

public final class FontResolver {
    private Font[] allFonts;
    private static final float DEFAULT_SIZE = 12.0f;
    private static final int SHIFT = 9;
    private static final int BLOCKSIZE = 128;
    private static final int MASK = 127;
    private int[][] blocks = new int[512][];
    private static FontResolver INSTANCE;

    private FontResolver() {
        this.allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < this.allFonts.length; ++i) {
            this.allFonts[i] = this.allFonts[i].deriveFont(12.0f);
        }
    }

    private int getIndexFor(char c) {
        for (int i = 0; i < this.allFonts.length; ++i) {
            if (!this.allFonts[i].canDisplay(c)) continue;
            return i + 1;
        }
        return 1;
    }

    private int getIndexFor(int n) {
        if (n < 65536) {
            return this.getIndexFor((char)n);
        }
        for (int i = 0; i < this.allFonts.length; ++i) {
            if (!this.allFonts[i].canDisplay(n)) continue;
            return i + 1;
        }
        return 1;
    }

    public int getFontIndex(char c) {
        int n;
        int n2 = c >> 9;
        int[] nArray = this.blocks[n2];
        if (nArray == null) {
            nArray = new int[128];
            this.blocks[n2] = nArray;
        }
        if (nArray[n = c & 0x7F] == 0) {
            nArray[n] = this.getIndexFor(c);
        }
        return nArray[n];
    }

    public int getFontIndex(int n) {
        if (n < 65536) {
            return this.getFontIndex((char)n);
        }
        return this.getIndexFor(n);
    }

    public int nextFontRunIndex(CodePointIterator codePointIterator) {
        int n = codePointIterator.next();
        int n2 = 1;
        if (n != -1) {
            n2 = this.getFontIndex(n);
            while ((n = codePointIterator.next()) != -1) {
                if (this.getFontIndex(n) == n2) continue;
                codePointIterator.prev();
                break;
            }
        }
        return n2;
    }

    public Font getFont(int n, Map map) {
        Font font = this.allFonts[n - 1];
        return font.deriveFont(map);
    }

    public static FontResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FontResolver();
        }
        return INSTANCE;
    }
}

