/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.ColorModel;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.awt.windows.Win32BackBufferSurfaceData;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.awt.windows.Win32SurfaceData;
import sun.awt.windows.WinVolatileSurfaceManager;
import sun.java2d.SurfaceData;

public class WinBackBuffer
extends SunVolatileImage {
    public WinBackBuffer(Component component, Win32SurfaceData win32SurfaceData) {
        super(component, component.getWidth(), component.getHeight(), win32SurfaceData);
    }

    protected VolatileSurfaceManager createSurfaceManager(Object object) {
        return new WinBackBufferSurfaceManager(this, object);
    }

    public Win32BackBufferSurfaceData getHWSurfaceData() {
        SurfaceData surfaceData = this.surfaceManager.getDestSurfaceData();
        if (surfaceData instanceof Win32BackBufferSurfaceData) {
            return (Win32BackBufferSurfaceData)surfaceData;
        }
        return null;
    }

    private class WinBackBufferSurfaceManager
    extends WinVolatileSurfaceManager {
        public WinBackBufferSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
            super(sunVolatileImage, object);
        }

        protected Win32OffScreenSurfaceData createAccelSurface() {
            GraphicsConfiguration graphicsConfiguration = this.vImg.getGraphicsConfig();
            ColorModel colorModel = this.getDeviceColorModel();
            Win32SurfaceData win32SurfaceData = (Win32SurfaceData)this.context;
            return Win32BackBufferSurfaceData.createData(this.vImg.getWidth(), this.vImg.getHeight(), colorModel, graphicsConfiguration, (Image)this.vImg, win32SurfaceData);
        }

        public void displayChanged() {
            SurfaceData surfaceData;
            this.lostSurface = true;
            if (this.sdAccel != null) {
                surfaceData = this.sdAccel;
                this.sdAccel = null;
                surfaceData.invalidate();
            }
            if (this.sdCurrent != null) {
                surfaceData = this.sdCurrent;
                this.sdCurrent = null;
                surfaceData.invalidate();
            }
            this.vImg.updateGraphicsConfig();
            this.sdAccel = this.sdCurrent = this.initAcceleratedSurface();
        }
    }
}

