/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    private final ReentrantLock qlock;
    private final WaitQueue waitingProducers;
    private final WaitQueue waitingConsumers;

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean bl) {
        if (bl) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        Node node;
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var6_5;
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingConsumers.deq();
                bl = node == null;
                if (bl) {
                    node = this.waitingProducers.enq(e);
                }
                var6_5 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                var6_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            if (!bl) continue;
            node.waitForTake();
            return;
        } while (!node.setItem(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        Node node;
        if (e == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var11_8;
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingConsumers.deq();
                bl = node == null;
                if (bl) {
                    node = this.waitingProducers.enq(e);
                }
                var11_8 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                var11_8 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            if (!bl) continue;
            return node.waitForTake(l2);
        } while (!node.setItem(e));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        Node node;
        Object object;
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var5_6;
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingProducers.deq();
                bl = node == null;
                if (bl) {
                    node = this.waitingConsumers.enq(null);
                }
                var5_6 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                var5_6 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            if (!bl) continue;
            object = node.waitForPut();
            return (E)object;
        } while ((object = node.getItem()) == null);
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Node node;
        Object object;
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var10_9;
            boolean bl;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            reentrantLock.lock();
            try {
                node = this.waitingProducers.deq();
                bl = node == null;
                if (bl) {
                    node = this.waitingConsumers.enq(null);
                }
                var10_9 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                var10_9 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            if (!bl) continue;
            object = node.waitForPut(l2);
            return (E)object;
        } while ((object = node.getItem()) == null);
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Node node;
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var5_4;
            reentrantLock.lock();
            try {
                node = this.waitingConsumers.deq();
                var5_4 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                var5_4 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            if (node != null) continue;
            return false;
        } while (!node.setItem(e));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Node node;
        Object object;
        ReentrantLock reentrantLock = this.qlock;
        do {
            Object var4_5;
            reentrantLock.lock();
            try {
                node = this.waitingProducers.deq();
                var4_5 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                var4_5 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            if (node != null) continue;
            return null;
        } while ((object = node.getItem()) == null);
        return (E)object;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return collection.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return new EmptyIterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length > 0) {
            TArray[0] = null;
        }
        return TArray;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        E e;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            collection.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        E e;
        int n2;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        for (n2 = 0; n2 < n && (e = this.poll()) != null; ++n2) {
            collection.add(e);
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyIterator<E>
    implements Iterator<E> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    static final class FifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3623113410248163686L;
        private transient Node head;
        private transient Node last;

        FifoWaitQueue() {
        }

        Node enq(Object object) {
            Node node = new Node(object);
            this.last = this.last == null ? (this.head = node) : (this.last.next = node);
            return node;
        }

        Node deq() {
            Node node = this.head;
            if (node != null) {
                this.head = node.next;
                if (this.head == null) {
                    this.last = null;
                }
                node.next = null;
            }
            return node;
        }
    }

    static final class LifoWaitQueue
    extends WaitQueue
    implements Serializable {
        private static final long serialVersionUID = -3633113410248163686L;
        private transient Node head;

        LifoWaitQueue() {
        }

        Node enq(Object object) {
            this.head = new Node(object, this.head);
            return this.head;
        }

        Node deq() {
            Node node = this.head;
            if (node != null) {
                this.head = node.next;
                node.next = null;
            }
            return node;
        }
    }

    static final class Node
    extends AbstractQueuedSynchronizer {
        private static final int ACK = 1;
        private static final int CANCEL = -1;
        Object item;
        Node next;

        Node(Object object) {
            this.item = object;
        }

        Node(Object object, Node node) {
            this.item = object;
            this.next = node;
        }

        protected boolean tryAcquire(int n) {
            return this.getState() != 0;
        }

        protected boolean tryRelease(int n) {
            return this.compareAndSetState(0, n);
        }

        private Object extract() {
            Object object = this.item;
            this.item = null;
            return object;
        }

        private void checkCancellationOnInterrupt(InterruptedException interruptedException) throws InterruptedException {
            if (this.release(-1)) {
                throw interruptedException;
            }
            Thread.currentThread().interrupt();
        }

        boolean setItem(Object object) {
            this.item = object;
            return this.release(1);
        }

        Object getItem() {
            return this.release(1) ? this.extract() : null;
        }

        void waitForTake() throws InterruptedException {
            try {
                this.acquireInterruptibly(0);
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
        }

        Object waitForPut() throws InterruptedException {
            try {
                this.acquireInterruptibly(0);
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return this.extract();
        }

        boolean waitForTake(long l) throws InterruptedException {
            try {
                if (!this.tryAcquireNanos(0, l) && this.release(-1)) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return true;
        }

        Object waitForPut(long l) throws InterruptedException {
            try {
                if (!this.tryAcquireNanos(0, l) && this.release(-1)) {
                    return null;
                }
            }
            catch (InterruptedException interruptedException) {
                this.checkCancellationOnInterrupt(interruptedException);
            }
            return this.extract();
        }
    }

    static abstract class WaitQueue
    implements Serializable {
        WaitQueue() {
        }

        abstract Node enq(Object var1);

        abstract Node deq();
    }
}

