/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollection<E>
implements Collection<E> {
    protected AbstractCollection() {
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        Iterator<E> iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator<E> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator<E> iterator = this.iterator();
        T[] TArray = objectArray;
        for (int i = 0; i < n; ++i) {
            TArray[i] = iterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        Iterator<E> iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator<E> iterator = this.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            E e = iterator.next();
            stringBuffer.append(e == this ? "(this Collection)" : String.valueOf(e));
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

