/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import sun.misc.ASCIICaseInsensitiveComparator;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;
import sun.misc.VM;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.ThreadLocalCoders;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Charset
implements Comparable<Charset> {
    private static volatile String bugLevel = null;
    private static CharsetProvider standardProvider = new StandardCharsets();
    private static volatile Object[] cache1 = null;
    private static volatile Object[] cache2 = null;
    private static ThreadLocal gate = new ThreadLocal();
    private static Object extendedProviderLock = new Object();
    private static boolean extendedProviderProbed = false;
    private static CharsetProvider extendedProvider = null;
    private static Charset defaultCharset;
    private final String name;
    private final String[] aliases;
    private Set aliasSet = null;

    static boolean atBugLevel(String string) {
        if (bugLevel == null) {
            if (!VM.isBooted()) {
                return false;
            }
            GetPropertyAction getPropertyAction = new GetPropertyAction("sun.nio.cs.bugLevel");
            String string2 = (String)AccessController.doPrivileged(getPropertyAction);
            bugLevel = string2 != null ? string2 : "";
        }
        return bugLevel.equals(string);
    }

    private static void checkName(String string) {
        int n = string.length();
        if (!Charset.atBugLevel("1.4") && n == 0) {
            throw new IllegalCharsetNameException(string);
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == ':' || c == '_' || c == '.') continue;
            throw new IllegalCharsetNameException(string);
        }
    }

    private static void cache(String string, Charset charset) {
        cache2 = cache1;
        cache1 = new Object[]{string, charset};
    }

    private static Iterator providers() {
        return new Iterator(){
            Class c = CharsetProvider.class;
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Iterator i = Service.providers(this.c, this.cl);
            Object next = null;

            private boolean getNext() {
                while (this.next == null) {
                    try {
                        if (!this.i.hasNext()) {
                            return false;
                        }
                        this.next = this.i.next();
                    }
                    catch (ServiceConfigurationError serviceConfigurationError) {
                        if (serviceConfigurationError.getCause() instanceof SecurityException) continue;
                        throw serviceConfigurationError;
                    }
                }
                return true;
            }

            public boolean hasNext() {
                return this.getNext();
            }

            public Object next() {
                if (!this.getNext()) {
                    throw new NoSuchElementException();
                }
                Object object = this.next;
                this.next = null;
                return object;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset lookupViaProviders(final String string) {
        if (!VM.isBooted()) {
            return null;
        }
        if (gate.get() != null) {
            return null;
        }
        try {
            gate.set(gate);
            Charset charset = (Charset)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iterator = Charset.providers();
                    while (iterator.hasNext()) {
                        CharsetProvider charsetProvider = (CharsetProvider)iterator.next();
                        Charset charset = charsetProvider.charsetForName(string);
                        if (charset == null) continue;
                        return charset;
                    }
                    return null;
                }
            });
            Object var3_2 = null;
            gate.set(null);
            return charset;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            gate.set(null);
            throw throwable;
        }
    }

    private static void probeExtendedProvider() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("sun.nio.cs.ext.ExtendedCharsets");
                    extendedProvider = (CharsetProvider)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                    throw new Error(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new Error(illegalAccessException);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset lookupExtendedCharset(String string) {
        CharsetProvider charsetProvider = null;
        Object object = extendedProviderLock;
        synchronized (object) {
            if (!extendedProviderProbed) {
                Charset.probeExtendedProvider();
                extendedProviderProbed = true;
            }
            charsetProvider = extendedProvider;
        }
        return charsetProvider != null ? charsetProvider.charsetForName(string) : null;
    }

    private static Charset lookup(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null charset name");
        }
        Object[] objectArray = cache1;
        if (cache1 != null && string.equals(objectArray[0])) {
            return (Charset)objectArray[1];
        }
        return Charset.lookup2(string);
    }

    private static Charset lookup2(String string) {
        Object[] objectArray = cache2;
        if (cache2 != null && string.equals(objectArray[0])) {
            cache2 = cache1;
            cache1 = objectArray;
            return (Charset)objectArray[1];
        }
        Charset charset = standardProvider.charsetForName(string);
        if (charset != null || (charset = Charset.lookupExtendedCharset(string)) != null || (charset = Charset.lookupViaProviders(string)) != null) {
            Charset.cache(string, charset);
            return charset;
        }
        Charset.checkName(string);
        return null;
    }

    public static boolean isSupported(String string) {
        return Charset.lookup(string) != null;
    }

    public static Charset forName(String string) {
        Charset charset = Charset.lookup(string);
        if (charset != null) {
            return charset;
        }
        throw new UnsupportedCharsetException(string);
    }

    private static void put(Iterator iterator, Map map) {
        while (iterator.hasNext()) {
            Charset charset = (Charset)iterator.next();
            if (map.containsKey(charset.name())) continue;
            map.put(charset.name(), charset);
        }
    }

    public static SortedMap<String, Charset> availableCharsets() {
        return (SortedMap)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                TreeMap treeMap = new TreeMap(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
                Charset.put(standardProvider.charsets(), treeMap);
                Iterator iterator = Charset.providers();
                while (iterator.hasNext()) {
                    CharsetProvider charsetProvider = (CharsetProvider)iterator.next();
                    Charset.put(charsetProvider.charsets(), treeMap);
                }
                return Collections.unmodifiableSortedMap(treeMap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset defaultCharset() {
        Class<Charset> clazz = Charset.class;
        synchronized (Charset.class) {
            if (defaultCharset == null) {
                GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding");
                String string = (String)AccessController.doPrivileged(getPropertyAction);
                Charset charset = Charset.lookup(string);
                if (charset != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return charset;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return Charset.forName("UTF-8");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultCharset;
        }
    }

    protected Charset(String string, String[] stringArray) {
        Charset.checkName(string);
        String[] stringArray2 = stringArray == null ? new String[]{} : stringArray;
        for (int i = 0; i < stringArray2.length; ++i) {
            Charset.checkName(stringArray2[i]);
        }
        this.name = string;
        this.aliases = stringArray2;
    }

    public final String name() {
        return this.name;
    }

    public final Set<String> aliases() {
        if (this.aliasSet != null) {
            return this.aliasSet;
        }
        int n = this.aliases.length;
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(this.aliases[i]);
        }
        this.aliasSet = Collections.unmodifiableSet(hashSet);
        return this.aliasSet;
    }

    public String displayName() {
        return this.name;
    }

    public final boolean isRegistered() {
        return !this.name.startsWith("X-") && !this.name.startsWith("x-");
    }

    public String displayName(Locale locale) {
        return this.name;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final CharBuffer decode(ByteBuffer byteBuffer) {
        try {
            return ThreadLocalCoders.decoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
    }

    public final ByteBuffer encode(CharBuffer charBuffer) {
        try {
            return ThreadLocalCoders.encoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(charBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
    }

    public final ByteBuffer encode(String string) {
        return this.encode(CharBuffer.wrap(string));
    }

    @Override
    public final int compareTo(Charset charset) {
        return this.name().compareToIgnoreCase(charset.name());
    }

    public final int hashCode() {
        return this.name().hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Charset)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.name.equals(((Charset)object).name());
    }

    public final String toString() {
        return this.name();
    }
}

