/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class WriterToUTF8Buffered
extends Writer {
    private static final int BYTES_MAX = 16384;
    private static final int CHARS_MAX = 5461;
    private final OutputStream m_os;
    private final byte[] m_outputBytes;
    private final char[] m_inputChars;
    private int count;

    public WriterToUTF8Buffered(OutputStream outputStream) throws UnsupportedEncodingException {
        this.m_os = outputStream;
        this.m_outputBytes = new byte[16387];
        this.m_inputChars = new char[5462];
        this.count = 0;
    }

    public void write(int n) throws IOException {
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (n < 128) {
            this.m_outputBytes[this.count++] = (byte)n;
        } else if (n < 2048) {
            this.m_outputBytes[this.count++] = (byte)(192 + (n >> 6));
            this.m_outputBytes[this.count++] = (byte)(128 + (n & 0x3F));
        } else {
            this.m_outputBytes[this.count++] = (byte)(224 + (n >> 12));
            this.m_outputBytes[this.count++] = (byte)(128 + (n >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n & 0x3F));
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        char c;
        int n3;
        int n4 = 3 * n2;
        if (n4 >= 16384 - this.count) {
            this.flushBuffer();
            if (n4 >= 16384) {
                int n5 = 1 + n2 / 5461;
                int n6 = n;
                for (int i = 1; i <= n5; ++i) {
                    int n7 = n6;
                    n6 = n + (int)((long)n2 * (long)i / (long)n5);
                    int n8 = n6 - n7;
                    this.write(cArray, n7, n8);
                }
                return;
            }
        }
        int n9 = n2 + n;
        byte[] byArray = this.m_outputBytes;
        int n10 = this.count;
        for (n3 = n; n3 < n9 && (c = cArray[n3]) < '\u0080'; ++n3) {
            byArray[n10++] = (byte)c;
        }
        while (n3 < n9) {
            c = cArray[n3];
            if (c < '\u0080') {
                byArray[n10++] = (byte)c;
            } else if (c < '\u0800') {
                byArray[n10++] = (byte)(192 + (c >> 6));
                byArray[n10++] = (byte)(128 + (c & 0x3F));
            } else {
                byArray[n10++] = (byte)(224 + (c >> 12));
                byArray[n10++] = (byte)(128 + (c >> 6 & 0x3F));
                byArray[n10++] = (byte)(128 + (c & 0x3F));
            }
            ++n3;
        }
        this.count = n10;
    }

    private void directWrite(char[] cArray, int n, int n2) throws IOException {
        if (n2 >= 16384 - this.count) {
            this.flushBuffer();
            if (n2 >= 16384) {
                int n3 = 1 + n2 / 5461;
                for (int i = 0; i < n3; ++i) {
                    int n4 = n + n2 * i / n3;
                    int n5 = n + n2 * (i + 1) / n3;
                    int n6 = n5 - n4;
                    this.directWrite(cArray, n4, n6);
                }
                return;
            }
        }
        int n7 = n2 + n;
        byte[] byArray = this.m_outputBytes;
        int n8 = this.count;
        for (int i = n; i < n7; ++i) {
            byArray[n8++] = byArray[i];
        }
        this.count = n8;
    }

    public void write(String string) throws IOException {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 >= 16384) {
                int n4 = 1 + n2 / 5461;
                for (int i = 0; i < n4; ++i) {
                    int n5 = 0 + n2 * i / n4;
                    int n6 = 0 + n2 * (i + 1) / n4;
                    int n7 = n6 - n5;
                    string.getChars(n5, n6, this.m_inputChars, 0);
                    this.write(this.m_inputChars, 0, n7);
                }
                return;
            }
        }
        string.getChars(0, n2, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        int n8 = n2;
        byte[] byArray = this.m_outputBytes;
        int n9 = this.count;
        for (n = 0; n < n8 && (c = cArray[n]) < '\u0080'; ++n) {
            byArray[n9++] = (byte)c;
        }
        while (n < n8) {
            c = cArray[n];
            if (c < '\u0080') {
                byArray[n9++] = (byte)c;
            } else if (c < '\u0800') {
                byArray[n9++] = (byte)(192 + (c >> 6));
                byArray[n9++] = (byte)(128 + (c & 0x3F));
            } else {
                byArray[n9++] = (byte)(224 + (c >> 12));
                byArray[n9++] = (byte)(128 + (c >> 6 & 0x3F));
                byArray[n9++] = (byte)(128 + (c & 0x3F));
            }
            ++n;
        }
        this.count = n9;
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.m_outputBytes, 0, this.count);
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public void directWrite(String string) throws IOException {
        int n = string.length();
        if (n >= 16384 - this.count) {
            this.flushBuffer();
            if (n >= 16384) {
                int n2 = 1 + n / 5461;
                for (int i = 0; i < n2; ++i) {
                    int n3 = 0 + n * i / n2;
                    int n4 = 0 + n * (i + 1) / n2;
                    int n5 = n4 - n3;
                    string.getChars(n3, n4, this.m_inputChars, 0);
                    this.directWrite(this.m_inputChars, 0, n5);
                }
                return;
            }
        }
        string.getChars(0, n, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        byte[] byArray = this.m_outputBytes;
        int n6 = this.count;
        int n7 = 0;
        while (n7 < n) {
            byArray[n6++] = (byte)cArray[n7++];
        }
        this.count = n6;
    }
}

