/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.dtm.ref;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMDOMException;
import com.sun.org.apache.xml.internal.dtm.ref.DTMChildIterNodeList;
import com.sun.org.apache.xml.internal.dtm.ref.DTMNamedNodeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class DTMNodeProxy
implements Node,
Document,
Text,
Element,
Attr,
ProcessingInstruction,
Comment,
DocumentFragment {
    public DTM dtm;
    int node;
    static final DOMImplementation implementation = new DTMNodeProxyImplementation();
    protected String fDocumentURI;
    protected String actualEncoding;
    private String xmlEncoding;
    private boolean xmlStandalone;
    private String xmlVersion;

    public DTMNodeProxy(DTM dTM, int n) {
        this.dtm = dTM;
        this.node = n;
    }

    public final DTM getDTM() {
        return this.dtm;
    }

    public final int getDTMNodeNumber() {
        return this.node;
    }

    public final boolean equals(Node node) {
        try {
            DTMNodeProxy dTMNodeProxy = (DTMNodeProxy)node;
            return dTMNodeProxy.node == this.node && dTMNodeProxy.dtm == this.dtm;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean equals(Object object) {
        try {
            return this.equals((Node)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean sameNodeAs(Node node) {
        if (!(node instanceof DTMNodeProxy)) {
            return false;
        }
        DTMNodeProxy dTMNodeProxy = (DTMNodeProxy)node;
        return this.dtm == dTMNodeProxy.dtm && this.node == dTMNodeProxy.node;
    }

    public final String getNodeName() {
        return this.dtm.getNodeName(this.node);
    }

    public final String getTarget() {
        return this.dtm.getNodeName(this.node);
    }

    public final String getLocalName() {
        return this.dtm.getLocalName(this.node);
    }

    public final String getPrefix() {
        return this.dtm.getPrefix(this.node);
    }

    public final void setPrefix(String string) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final String getNamespaceURI() {
        return this.dtm.getNamespaceURI(this.node);
    }

    public final boolean supports(String string, String string2) {
        return implementation.hasFeature(string, string2);
    }

    public final boolean isSupported(String string, String string2) {
        return implementation.hasFeature(string, string2);
    }

    public final String getNodeValue() throws DOMException {
        return this.dtm.getNodeValue(this.node);
    }

    public final String getStringValue() throws DOMException {
        return ((Object)this.dtm.getStringValue(this.node)).toString();
    }

    public final void setNodeValue(String string) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final short getNodeType() {
        return this.dtm.getNodeType(this.node);
    }

    public final Node getParentNode() {
        if (this.getNodeType() == 2) {
            return null;
        }
        int n = this.dtm.getParent(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    public final Node getOwnerNode() {
        int n = this.dtm.getParent(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    public final NodeList getChildNodes() {
        return new DTMChildIterNodeList(this.dtm, this.node);
    }

    public final Node getFirstChild() {
        int n = this.dtm.getFirstChild(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    public final Node getLastChild() {
        int n = this.dtm.getLastChild(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    public final Node getPreviousSibling() {
        int n = this.dtm.getPreviousSibling(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    public final Node getNextSibling() {
        if (this.dtm.getNodeType(this.node) == 2) {
            return null;
        }
        int n = this.dtm.getNextSibling(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    public final NamedNodeMap getAttributes() {
        return new DTMNamedNodeMap(this.dtm, this.node);
    }

    public boolean hasAttribute(String string) {
        return -1 != this.dtm.getAttributeNode(this.node, null, string);
    }

    public boolean hasAttributeNS(String string, String string2) {
        return -1 != this.dtm.getAttributeNode(this.node, string2, string);
    }

    public final Document getOwnerDocument() {
        return (Document)this.dtm.getNode(this.dtm.getOwnerDocument(this.node));
    }

    public final Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Node removeChild(Node node) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Node appendChild(Node node) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final boolean hasChildNodes() {
        return -1 != this.dtm.getFirstChild(this.node);
    }

    public final Node cloneNode(boolean bl) {
        throw new DTMDOMException(9);
    }

    public final DocumentType getDoctype() {
        return null;
    }

    public final DOMImplementation getImplementation() {
        return implementation;
    }

    public final Element getDocumentElement() {
        int n = this.dtm.getDocument();
        int n2 = -1;
        int n3 = this.dtm.getFirstChild(n);
        while (n3 != -1) {
            switch (this.dtm.getNodeType(n3)) {
                case 1: {
                    if (n2 != -1) {
                        n2 = -1;
                        n3 = this.dtm.getLastChild(n);
                        break;
                    }
                    n2 = n3;
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    n2 = -1;
                    n3 = this.dtm.getLastChild(n);
                }
            }
            n3 = this.dtm.getNextSibling(n3);
        }
        if (n2 == -1) {
            throw new DTMDOMException(9);
        }
        return (Element)this.dtm.getNode(n2);
    }

    public final Element createElement(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final DocumentFragment createDocumentFragment() {
        throw new DTMDOMException(9);
    }

    public final Text createTextNode(String string) {
        throw new DTMDOMException(9);
    }

    public final Comment createComment(String string) {
        throw new DTMDOMException(9);
    }

    public final CDATASection createCDATASection(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr createAttribute(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final EntityReference createEntityReference(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final NodeList getElementsByTagName(String string) {
        throw new DTMDOMException(9);
    }

    public final Node importNode(Node node, boolean bl) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Element createElementNS(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr createAttributeNS(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final NodeList getElementsByTagNameNS(String string, String string2) {
        throw new DTMDOMException(9);
    }

    public final Element getElementById(String string) {
        throw new DTMDOMException(9);
    }

    public final Text splitText(int n) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final String getData() throws DOMException {
        return this.dtm.getNodeValue(this.node);
    }

    public final void setData(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final int getLength() {
        return this.dtm.getNodeValue(this.node).length();
    }

    public final String substringData(int n, int n2) throws DOMException {
        return this.getData().substring(n, n + n2);
    }

    public final void appendData(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void insertData(int n, String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void deleteData(int n, int n2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void replaceData(int n, int n2, String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final String getTagName() {
        return this.dtm.getNodeName(this.node);
    }

    public final String getAttribute(String string) {
        DTMNamedNodeMap dTMNamedNodeMap = new DTMNamedNodeMap(this.dtm, this.node);
        Node node = dTMNamedNodeMap.getNamedItem(string);
        return null == node ? null : node.getNodeValue();
    }

    public final void setAttribute(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void removeAttribute(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr getAttributeNode(String string) {
        DTMNamedNodeMap dTMNamedNodeMap = new DTMNamedNodeMap(this.dtm, this.node);
        return (Attr)dTMNamedNodeMap.getNamedItem(string);
    }

    public final Attr setAttributeNode(Attr attr) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr removeAttributeNode(Attr attr) throws DOMException {
        throw new DTMDOMException(9);
    }

    public boolean hasAttributes() {
        return -1 != this.dtm.getFirstAttribute(this.node);
    }

    public final void normalize() {
        throw new DTMDOMException(9);
    }

    public final String getAttributeNS(String string, String string2) {
        DTMNamedNodeMap dTMNamedNodeMap = new DTMNamedNodeMap(this.dtm, this.node);
        Node node = dTMNamedNodeMap.getNamedItemNS(string, string2);
        return null == node ? null : node.getNodeValue();
    }

    public final void setAttributeNS(String string, String string2, String string3) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void removeAttributeNS(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr getAttributeNodeNS(String string, String string2) {
        throw new DTMDOMException(9);
    }

    public final Attr setAttributeNodeNS(Attr attr) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final String getName() {
        return this.dtm.getNodeName(this.node);
    }

    public final boolean getSpecified() {
        return true;
    }

    public final String getValue() {
        return this.dtm.getNodeValue(this.node);
    }

    public final void setValue(String string) {
        throw new DTMDOMException(9);
    }

    public final Element getOwnerElement() {
        if (this.getNodeType() != 2) {
            return null;
        }
        int n = this.dtm.getParent(this.node);
        return n == -1 ? null : (Element)this.dtm.getNode(n);
    }

    public Node adoptNode(Node node) throws DOMException {
        throw new DTMDOMException(9);
    }

    public String getInputEncoding() {
        throw new DTMDOMException(9);
    }

    public void setEncoding(String string) {
        throw new DTMDOMException(9);
    }

    public boolean getStandalone() {
        throw new DTMDOMException(9);
    }

    public void setStandalone(boolean bl) {
        throw new DTMDOMException(9);
    }

    public boolean getStrictErrorChecking() {
        throw new DTMDOMException(9);
    }

    public void setStrictErrorChecking(boolean bl) {
        throw new DTMDOMException(9);
    }

    public String getVersion() {
        throw new DTMDOMException(9);
    }

    public void setVersion(String string) {
        throw new DTMDOMException(9);
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return this.getOwnerDocument().setUserData(string, object, userDataHandler);
    }

    public Object getUserData(String string) {
        return this.getOwnerDocument().getUserData(string);
    }

    public Object getFeature(String string, String string2) {
        return this.isSupported(string, string2) ? this : null;
    }

    public boolean isEqualNode(Node node) {
        if (node == this) {
            return true;
        }
        if (node.getNodeType() != this.getNodeType()) {
            return false;
        }
        if (this.getNodeName() == null ? node.getNodeName() != null : !this.getNodeName().equals(node.getNodeName())) {
            return false;
        }
        if (this.getLocalName() == null ? node.getLocalName() != null : !this.getLocalName().equals(node.getLocalName())) {
            return false;
        }
        if (this.getNamespaceURI() == null ? node.getNamespaceURI() != null : !this.getNamespaceURI().equals(node.getNamespaceURI())) {
            return false;
        }
        if (this.getPrefix() == null ? node.getPrefix() != null : !this.getPrefix().equals(node.getPrefix())) {
            return false;
        }
        return !(this.getNodeValue() == null ? node.getNodeValue() != null : !this.getNodeValue().equals(node.getNodeValue()));
    }

    public String lookupNamespaceURI(String string) {
        short s = this.getNodeType();
        switch (s) {
            case 1: {
                String string2 = this.getNamespaceURI();
                String string3 = this.getPrefix();
                if (string2 != null) {
                    if (string == null && string3 == string) {
                        return string2;
                    }
                    if (string3 != null && string3.equals(string)) {
                        return string2;
                    }
                }
                if (this.hasAttributes()) {
                    NamedNodeMap namedNodeMap = this.getAttributes();
                    int n = namedNodeMap.getLength();
                    for (int i = 0; i < n; ++i) {
                        Node node = namedNodeMap.item(i);
                        String string4 = node.getPrefix();
                        String string5 = node.getNodeValue();
                        string2 = node.getNamespaceURI();
                        if (string2 == null || !string2.equals("http://www.w3.org/2000/xmlns/")) continue;
                        if (string == null && node.getNodeName().equals("xmlns")) {
                            return string5;
                        }
                        if (string4 == null || !string4.equals("xmlns") || !node.getLocalName().equals(string)) continue;
                        return string5;
                    }
                }
                return null;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.getOwnerElement().getNodeType() == 1) {
                    return this.getOwnerElement().lookupNamespaceURI(string);
                }
                return null;
            }
        }
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return false;
    }

    public String lookupPrefix(String string) {
        if (string == null) {
            return null;
        }
        short s = this.getNodeType();
        switch (s) {
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.getOwnerElement().getNodeType() == 1) {
                    return this.getOwnerElement().lookupPrefix(string);
                }
                return null;
            }
        }
        return null;
    }

    public boolean isSameNode(Node node) {
        return this == node;
    }

    public void setTextContent(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        return 0;
    }

    public String getBaseURI() {
        return null;
    }

    public Node renameNode(Node node, String string, String string2) throws DOMException {
        return node;
    }

    public void normalizeDocument() {
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public void setDocumentURI(String string) {
        this.fDocumentURI = string;
    }

    public String getDocumentURI() {
        return this.fDocumentURI;
    }

    public String getActualEncoding() {
        return this.actualEncoding;
    }

    public void setActualEncoding(String string) {
        this.actualEncoding = string;
    }

    public Text replaceWholeText(String string) throws DOMException {
        return null;
    }

    public String getWholeText() {
        return null;
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public void setIdAttribute(boolean bl) {
    }

    public void setIdAttribute(String string, boolean bl) {
    }

    public void setIdAttributeNode(Attr attr, boolean bl) {
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) {
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public boolean isId() {
        return false;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public void setXmlEncoding(String string) {
        this.xmlEncoding = string;
    }

    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    public void setXmlStandalone(boolean bl) throws DOMException {
        this.xmlStandalone = bl;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String string) throws DOMException {
        this.xmlVersion = string;
    }

    static class DTMNodeProxyImplementation
    implements DOMImplementation {
        DTMNodeProxyImplementation() {
        }

        public DocumentType createDocumentType(String string, String string2, String string3) {
            throw new DTMDOMException(9);
        }

        public Document createDocument(String string, String string2, DocumentType documentType) {
            throw new DTMDOMException(9);
        }

        public boolean hasFeature(String string, String string2) {
            return !(!"CORE".equals(string.toUpperCase()) && !"XML".equals(string.toUpperCase()) || !"1.0".equals(string2) && !"2.0".equals(string2));
        }

        public Object getFeature(String string, String string2) {
            return null;
        }
    }
}

