/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import java.util.ArrayList;

public class MetaKeywords {
    private static MetaKeywords instance = null;
    private final Configuration configuration;

    private MetaKeywords(Configuration configuration) {
        this.configuration = configuration;
    }

    public static MetaKeywords getInstance(Configuration configuration) {
        if (instance == null) {
            instance = new MetaKeywords(configuration);
        }
        return instance;
    }

    public String[] getMetaKeywords(ClassDoc classDoc) {
        ArrayList arrayList = this.getClassKeyword(classDoc);
        if (this.configuration.keywords) {
            arrayList.addAll(this.getMemberKeywords(classDoc.fields()));
            arrayList.addAll(this.getMemberKeywords(classDoc.methods()));
        }
        return arrayList.toArray(new String[0]);
    }

    protected ArrayList getClassKeyword(ClassDoc classDoc) {
        String string = classDoc.isInterface() ? "interface" : "class";
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(classDoc.qualifiedName() + " " + string);
        return arrayList;
    }

    protected ArrayList getMemberKeywords(MemberDoc[] memberDocArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < memberDocArray.length; ++i) {
            String string = memberDocArray[i].name() + (memberDocArray[i].isMethod() ? "()" : "");
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }
}

