/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SecuritySupport;

class SchemaFactoryFinder {
    private static boolean debug = false;
    private static SecuritySupport ss = new SecuritySupport();
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    public SchemaFactoryFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == ss.getContextClassLoader()) {
                SchemaFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        SchemaFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public SchemaFactory newFactory(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        SchemaFactory schemaFactory = this._newFactory(string);
        if (schemaFactory != null) {
            SchemaFactoryFinder.debugPrintln("factory '" + schemaFactory.getClass().getName() + "' was found for " + string);
        } else {
            SchemaFactoryFinder.debugPrintln("unable to find a factory for " + string);
        }
        return schemaFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaFactory _newFactory(String string) {
        Serializable serializable;
        Object object;
        SchemaFactory schemaFactory;
        block19: {
            String string2;
            String string3;
            block18: {
                string3 = SERVICE_CLASS.getName() + ":" + string;
                try {
                    SchemaFactoryFinder.debugPrintln("Looking up system property '" + string3 + "'");
                    string2 = ss.getSystemProperty(string3);
                    if (string2 != null) {
                        SchemaFactoryFinder.debugPrintln("The value is '" + string2 + "'");
                        schemaFactory = this.createInstance(string2);
                        if (schemaFactory != null) {
                            return schemaFactory;
                        }
                    } else {
                        SchemaFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable throwable) {
                    if (!debug) break block18;
                    SchemaFactoryFinder.debugPrintln("failed to look up system property '" + string3 + "'");
                    throwable.printStackTrace();
                }
            }
            string2 = ss.getSystemProperty("java.home");
            String string4 = string2 + File.separator + "lib" + File.separator + "jaxp.properties";
            String string5 = null;
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            serializable = new File(string4);
                            firstTime = false;
                            if (ss.doesFileExist((File)serializable)) {
                                SchemaFactoryFinder.debugPrintln("Read properties file " + serializable);
                                cacheProps.load(ss.getFileInputStream((File)serializable));
                            }
                        }
                    }
                }
                string5 = cacheProps.getProperty(string3);
                SchemaFactoryFinder.debugPrintln("found " + string5 + " in $java.home/jaxp.properties");
                if (string5 != null && (schemaFactory = this.createInstance(string5)) != null) {
                    return schemaFactory;
                }
            }
            catch (Exception exception) {
                if (!debug) break block19;
                exception.printStackTrace();
            }
        }
        object = this.createServiceFileIterator();
        while (object.hasNext()) {
            serializable = (URL)object.next();
            SchemaFactoryFinder.debugPrintln("looking into " + serializable);
            try {
                schemaFactory = this.loadFromProperty(string, ((URL)serializable).toExternalForm(), ss.getURLInputStream((URL)serializable));
                if (schemaFactory == null) continue;
                return schemaFactory;
            }
            catch (IOException iOException) {
                if (!debug) continue;
                SchemaFactoryFinder.debugPrintln("failed to read " + serializable);
                iOException.printStackTrace();
            }
        }
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema validator");
            return this.createInstance("com.sun.org.apache.xerces.internal.jaxp.validation.xs.SchemaFactoryImpl");
        }
        SchemaFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        return null;
    }

    private SchemaFactory createInstance(String string) {
        block4: {
            try {
                Object obj;
                SchemaFactoryFinder.debugPrintln("instanciating " + string);
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(string) : Class.forName(string);
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("loaded it from " + SchemaFactoryFinder.which(clazz));
                }
                if ((obj = clazz.newInstance()) instanceof SchemaFactory) {
                    return (SchemaFactory)obj;
                }
                SchemaFactoryFinder.debugPrintln(string + " is not assignable to " + SERVICE_CLASS.getName());
            }
            catch (Throwable throwable) {
                SchemaFactoryFinder.debugPrintln("failed to instanciate " + string);
                if (!debug) break block4;
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private SchemaFactory loadFromProperty(String string, String string2, InputStream inputStream) throws IOException {
        SchemaFactoryFinder.debugPrintln("Reading " + string2);
        Properties properties = new Properties();
        properties.load(inputStream);
        inputStream.close();
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            SchemaFactoryFinder.debugPrintln("found " + string + " = " + string3);
            return this.createInstance(string3);
        }
        SchemaFactoryFinder.debugPrintln(string + " is not in the property file");
        return null;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){

                protected Object value() {
                    ClassLoader classLoader = SchemaFactoryFinder.class.getClassLoader();
                    return ss.getResourceAsURL(classLoader, SERVICE_ID);
                }
            };
        }
        try {
            final Enumeration enumeration = ss.getResources(this.classLoader, SERVICE_ID);
            if (!enumeration.hasMoreElements()) {
                SchemaFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                public Object next() {
                    return enumeration.nextElement();
                }
            };
        }
        catch (IOException iOException) {
            SchemaFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
            if (debug) {
                iOException.printStackTrace();
            }
            return new ArrayList().iterator();
        }
    }

    private static String which(Class clazz) {
        return SchemaFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String string, ClassLoader classLoader) {
        URL uRL;
        String string2 = string.replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((uRL = ss.getResourceAsURL(classLoader, string2)) != null) {
            return uRL.toString();
        }
        return null;
    }

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception exception) {
            debug = false;
        }
        SERVICE_CLASS = SchemaFactory.class;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

