/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class BasicEditorPaneUI
extends BasicTextUI {
    private static final String FONT_ATTRIBUTE_KEY = "FONT_ATTRIBUTE_KEY";

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicEditorPaneUI();
    }

    protected String getPropertyPrefix() {
        return "EditorPane";
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateDisplayProperties(jComponent.getFont(), jComponent.getForeground());
    }

    public void uninstallUI(JComponent jComponent) {
        this.cleanDisplayProperties();
        super.uninstallUI(jComponent);
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        JEditorPane jEditorPane = (JEditorPane)this.getComponent();
        return jEditorPane.getEditorKit();
    }

    ActionMap getActionMap() {
        Action[] actionArray;
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new BasicTextUI.FocusAction(this));
        EditorKit editorKit = this.getEditorKit(this.getComponent());
        if (editorKit != null && (actionArray = editorKit.getActions()) != null) {
            this.addActions(actionMapUIResource, actionArray);
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("editorKit".equals(string)) {
            ActionMap actionMap = SwingUtilities.getUIActionMap(this.getComponent());
            if (actionMap != null) {
                Action[] actionArray;
                Action[] actionArray2;
                Object object = propertyChangeEvent.getOldValue();
                if (object instanceof EditorKit && (actionArray2 = ((EditorKit)object).getActions()) != null) {
                    this.removeActions(actionMap, actionArray2);
                }
                if ((actionArray2 = propertyChangeEvent.getNewValue()) instanceof EditorKit && (actionArray = ((EditorKit)actionArray2).getActions()) != null) {
                    this.addActions(actionMap, actionArray);
                }
            }
            this.updateFocusTraversalKeys();
        } else if ("editable".equals(string)) {
            this.updateFocusTraversalKeys();
        } else if ("foreground".equals(string) || "font".equals(string) || "document".equals(string) || "JEditorPane.w3cLengthUnits".equals(string) || "JEditorPane.honorDisplayProperties".equals(string)) {
            JTextComponent jTextComponent = this.getComponent();
            this.updateDisplayProperties(jTextComponent.getFont(), jTextComponent.getForeground());
            if ("JEditorPane.w3cLengthUnits".equals(string) || "JEditorPane.honorDisplayProperties".equals(string)) {
                this.modelChanged();
            }
            if ("foreground".equals(string)) {
                Object object = jTextComponent.getClientProperty("JEditorPane.honorDisplayProperties");
                boolean bl = false;
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                }
                if (bl) {
                    this.modelChanged();
                }
            }
        }
    }

    void removeActions(ActionMap actionMap, Action[] actionArray) {
        for (Action action : actionArray) {
            actionMap.remove(action.getValue("Name"));
        }
    }

    void addActions(ActionMap actionMap, Action[] actionArray) {
        for (Action action : actionArray) {
            actionMap.put(action.getValue("Name"), action);
        }
    }

    void updateDisplayProperties(Font font, Color color) {
        Document document;
        JTextComponent jTextComponent = this.getComponent();
        Object object = jTextComponent.getClientProperty("JEditorPane.honorDisplayProperties");
        boolean bl = false;
        Object object2 = jTextComponent.getClientProperty("JEditorPane.w3cLengthUnits");
        boolean bl2 = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (object2 instanceof Boolean) {
            bl2 = (Boolean)object2;
        }
        if (this instanceof BasicTextPaneUI || bl) {
            document = this.getComponent().getDocument();
            if (document instanceof StyledDocument) {
                if (document instanceof HTMLDocument && bl) {
                    this.updateCSS(font, color);
                } else {
                    this.updateStyle(font, color);
                }
            }
        } else {
            this.cleanDisplayProperties();
        }
        if (bl2) {
            document = this.getComponent().getDocument();
            if (document instanceof HTMLDocument) {
                StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
                styleSheet.addRule("W3C_LENGTH_UNITS_ENABLE");
            }
        } else {
            document = this.getComponent().getDocument();
            if (document instanceof HTMLDocument) {
                StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
                styleSheet.addRule("W3C_LENGTH_UNITS_DISABLE");
            }
        }
    }

    void cleanDisplayProperties() {
        Document document = this.getComponent().getDocument();
        if (document instanceof HTMLDocument) {
            StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
            StyleSheet[] styleSheetArray = styleSheet.getStyleSheets();
            if (styleSheetArray != null) {
                for (StyleSheet styleSheet2 : styleSheetArray) {
                    if (!(styleSheet2 instanceof StyleSheetUIResource)) continue;
                    styleSheet.removeStyleSheet(styleSheet2);
                    styleSheet.addRule("BASE_SIZE_DISABLE");
                    break;
                }
            }
            Style style = ((StyledDocument)document).getStyle("default");
            style.removeAttribute(FONT_ATTRIBUTE_KEY);
        }
    }

    private void updateCSS(Font font, Color color) {
        JTextComponent jTextComponent = this.getComponent();
        Document document = jTextComponent.getDocument();
        if (document instanceof HTMLDocument) {
            StyleSheetUIResource styleSheetUIResource = new StyleSheetUIResource();
            StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
            StyleSheet[] styleSheetArray = styleSheet.getStyleSheets();
            if (styleSheetArray != null) {
                for (StyleSheet styleSheet2 : styleSheetArray) {
                    if (!(styleSheet2 instanceof StyleSheetUIResource)) continue;
                    styleSheet.removeStyleSheet(styleSheet2);
                }
            }
            String string = SwingUtilities2.displayPropertiesToCSS(font, color);
            styleSheetUIResource.addRule(string);
            styleSheet.addStyleSheet(styleSheetUIResource);
            styleSheet.addRule("BASE_SIZE " + jTextComponent.getFont().getSize());
            Style style = ((StyledDocument)document).getStyle("default");
            style.addAttribute(FONT_ATTRIBUTE_KEY, font);
        }
    }

    private void updateStyle(Font font, Color color) {
        this.updateFont(font);
        this.updateForeground(color);
    }

    private void updateForeground(Color color) {
        StyledDocument styledDocument = (StyledDocument)this.getComponent().getDocument();
        Style style = styledDocument.getStyle("default");
        if (style == null) {
            return;
        }
        if (color == null) {
            style.removeAttribute(StyleConstants.Foreground);
        } else {
            StyleConstants.setForeground(style, color);
        }
    }

    private void updateFont(Font font) {
        StyledDocument styledDocument = (StyledDocument)this.getComponent().getDocument();
        Style style = styledDocument.getStyle("default");
        if (style == null) {
            return;
        }
        if (font == null) {
            style.removeAttribute(StyleConstants.FontFamily);
            style.removeAttribute(StyleConstants.FontSize);
            style.removeAttribute(StyleConstants.Bold);
            style.removeAttribute(StyleConstants.Italic);
            style.removeAttribute(FONT_ATTRIBUTE_KEY);
        } else {
            StyleConstants.setFontFamily(style, font.getName());
            StyleConstants.setFontSize(style, font.getSize());
            StyleConstants.setBold(style, font.isBold());
            StyleConstants.setItalic(style, font.isItalic());
            style.addAttribute(FONT_ATTRIBUTE_KEY, font);
        }
    }

    static class StyleSheetUIResource
    extends StyleSheet
    implements UIResource {
        StyleSheetUIResource() {
        }
    }
}

