/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.bmp;

import com.sun.imageio.plugins.bmp.BMPConstants;
import com.sun.imageio.plugins.bmp.BMPMetadata;
import com.sun.imageio.plugins.common.I18N;
import com.sun.imageio.plugins.common.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.bmp.BMPImageWriteParam;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class BMPImageWriter
extends ImageWriter
implements BMPConstants {
    private ImageOutputStream stream = null;
    private ByteArrayOutputStream embedded_stream = null;
    private int version;
    private int compressionType;
    private boolean isTopDown;
    private int w;
    private int h;
    private int compImageSize = 0;
    private int[] bitPos;
    private byte[] bpixels;
    private short[] spixels;
    private int[] ipixels;

    public BMPImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("BMPImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new BMPImageWriteParam();
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        BMPMetadata bMPMetadata = new BMPMetadata();
        bMPMetadata.bmpVersion = "BMP v. 3.x";
        bMPMetadata.compression = this.getPreferredCompressionType(imageTypeSpecifier);
        if (imageWriteParam != null && imageWriteParam.getCompressionMode() == 2) {
            bMPMetadata.compression = this.getCompressionType(imageWriteParam.getCompressionType());
        }
        bMPMetadata.bitsPerPixel = (short)imageTypeSpecifier.getColorModel().getPixelSize();
        return bMPMetadata;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("BMPImageWriter7"));
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException(I18N.getString("BMPImageWriter8"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        BMPImageWriteParam bMPImageWriteParam = (BMPImageWriteParam)imageWriteParam;
        int n5 = 24;
        boolean bl = false;
        int n6 = 0;
        IndexColorModel indexColorModel = null;
        RenderedImage renderedImage = null;
        Raster raster = null;
        boolean bl2 = iIOImage.hasRaster();
        Object object2 = imageWriteParam.getSourceRegion();
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        this.compImageSize = 0;
        if (bl2) {
            raster = iIOImage.getRaster();
            sampleModel = raster.getSampleModel();
            colorModel = ImageUtil.createColorModel(null, sampleModel);
            object2 = object2 == null ? raster.getBounds() : ((Rectangle)object2).intersection(raster.getBounds());
        } else {
            renderedImage = iIOImage.getRenderedImage();
            sampleModel = renderedImage.getSampleModel();
            colorModel = renderedImage.getColorModel();
            object = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            object2 = object2 == null ? object : ((Rectangle)object2).intersection((Rectangle)object);
        }
        object = iIOImage.getMetadata();
        BMPMetadata bMPMetadata = null;
        if (object != null && object instanceof BMPMetadata) {
            bMPMetadata = (BMPMetadata)object;
        } else {
            ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
            bMPMetadata = (BMPMetadata)this.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        }
        if (((Rectangle)object2).isEmpty()) {
            throw new RuntimeException(I18N.getString("BMPImageWrite0"));
        }
        int n7 = imageWriteParam.getSourceXSubsampling();
        int n8 = imageWriteParam.getSourceYSubsampling();
        int n9 = imageWriteParam.getSubsamplingXOffset();
        int n10 = imageWriteParam.getSubsamplingYOffset();
        int n11 = sampleModel.getDataType();
        ((Rectangle)object2).translate(n9, n10);
        ((Rectangle)object2).width -= n9;
        ((Rectangle)object2).height -= n10;
        int n12 = ((Rectangle)object2).x / n7;
        int n13 = ((Rectangle)object2).y / n8;
        this.w = (((Rectangle)object2).width + n7 - 1) / n7;
        this.h = (((Rectangle)object2).height + n8 - 1) / n8;
        n9 = ((Rectangle)object2).x % n7;
        n10 = ((Rectangle)object2).y % n8;
        Rectangle rectangle = new Rectangle(n12, n13, this.w, this.h);
        boolean bl3 = rectangle.equals(object2);
        int[] nArray = imageWriteParam.getSourceBands();
        boolean bl4 = true;
        int n14 = sampleModel.getNumBands();
        if (nArray != null) {
            sampleModel = sampleModel.createSubsetSampleModel(nArray);
            colorModel = null;
            bl4 = false;
            n14 = sampleModel.getNumBands();
        } else {
            nArray = new int[n14];
            for (int i = 0; i < n14; ++i) {
                nArray[i] = i;
            }
        }
        int[] nArray2 = null;
        boolean bl5 = true;
        if (sampleModel instanceof ComponentSampleModel) {
            nArray2 = ((ComponentSampleModel)sampleModel).getBandOffsets();
            if (sampleModel instanceof BandedSampleModel) {
                bl5 = false;
            } else {
                for (n4 = 0; n4 < nArray2.length; ++n4) {
                    bl5 &= nArray2[n4] == nArray2.length - n4 - 1;
                }
            }
        } else {
            nArray2 = new int[n14];
            for (n4 = 0; n4 < n14; ++n4) {
                nArray2[n4] = n4;
            }
        }
        if (bl5 && sampleModel instanceof SinglePixelPackedSampleModel) {
            int[] nArray3 = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
            for (n3 = 0; n3 < nArray3.length - 1; ++n3) {
                bl5 &= nArray3[n3] > nArray3[n3 + 1];
            }
        }
        bl3 &= bl5;
        int[] nArray4 = sampleModel.getSampleSize();
        n3 = this.w * n14;
        switch (bMPImageWriteParam.getCompressionMode()) {
            case 2: {
                this.compressionType = this.getCompressionType(bMPImageWriteParam.getCompressionType());
                break;
            }
            case 3: {
                this.compressionType = bMPMetadata.compression;
                break;
            }
            case 1: {
                this.compressionType = this.getPreferredCompressionType(colorModel, sampleModel);
                break;
            }
            default: {
                this.compressionType = 0;
            }
        }
        if (!this.canEncodeImage(this.compressionType, colorModel, sampleModel)) {
            throw new IOException("Image can not be encoded with compression type " + compressionTypeNames[this.compressionType]);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (colorModel instanceof IndexColorModel) {
            bl = true;
            indexColorModel = (IndexColorModel)colorModel;
            n6 = indexColorModel.getMapSize();
            if (n6 <= 2) {
                n5 = 1;
                n3 = this.w + 7 >> 3;
            } else if (n6 <= 16) {
                n5 = 4;
                n3 = this.w + 1 >> 1;
            } else if (n6 <= 256) {
                n5 = 8;
            } else {
                n5 = 24;
                bl = false;
                n6 = 0;
                n3 = this.w * 3;
            }
            if (bl) {
                byArray = new byte[n6];
                byArray2 = new byte[n6];
                byArray3 = new byte[n6];
                byArray4 = new byte[n6];
                indexColorModel.getAlphas(byArray4);
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
            }
        } else if (n14 == 1) {
            bl = true;
            n6 = 256;
            n5 = nArray4[0];
            n3 = this.w * n5 + 7 >> 3;
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            byArray4 = new byte[256];
            for (n2 = 0; n2 < 256; ++n2) {
                byArray[n2] = (byte)n2;
                byArray2[n2] = (byte)n2;
                byArray3[n2] = (byte)n2;
                byArray4[n2] = -1;
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel && bl4) {
            n5 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
            n3 = this.w * n5 + 7 >> 3;
            if (this.compressionType == 3) {
                bl = true;
                n6 = 3;
                byArray = new byte[n6];
                byArray2 = new byte[n6];
                byArray3 = new byte[n6];
                byArray4 = new byte[n6];
                if (n5 == 16) {
                    byArray3[0] = 0;
                    byArray2[0] = 0;
                    byArray[0] = -8;
                    byArray4[0] = 0;
                    byArray3[1] = 0;
                    byArray2[1] = 0;
                    byArray[1] = 7;
                    byArray4[1] = -32;
                    byArray3[2] = 0;
                    byArray2[2] = 0;
                    byArray[2] = 0;
                    byArray4[2] = 31;
                } else if (n5 == 32) {
                    byArray3[0] = 0;
                    byArray2[0] = -1;
                    byArray[0] = 0;
                    byArray4[0] = 0;
                    byArray3[1] = 0;
                    byArray2[1] = 0;
                    byArray[1] = -1;
                    byArray4[1] = 0;
                    byArray3[2] = 0;
                    byArray2[2] = 0;
                    byArray[2] = 0;
                    byArray4[2] = -1;
                } else {
                    throw new RuntimeException(I18N.getString("BMPImageWrite6"));
                }
            }
        }
        n2 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = n6;
        int n22 = n3 % 4;
        if (n22 != 0) {
            n22 = 4 - n22;
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel && bl4) {
            n3 = this.w;
            this.bitPos = ((SinglePixelPackedSampleModel)sampleModel).getBitMasks();
            for (int i = 0; i < this.bitPos.length; ++i) {
                this.bitPos[i] = this.firstLowBit(this.bitPos[i]);
            }
        }
        n15 = 54 + n6 * 4;
        n17 = (n3 + n22) * this.h;
        n2 = n17 + n15;
        n16 = 40;
        long l = this.stream.getStreamPosition();
        this.writeFileHeader(n2, n15);
        this.writeInfoHeader(n16, n5);
        this.stream.writeInt(this.compressionType);
        this.stream.writeInt(n17);
        this.stream.writeInt(n18);
        this.stream.writeInt(n19);
        this.stream.writeInt(n20);
        this.stream.writeInt(n21);
        if (bl) {
            if (this.compressionType == 3) {
                for (n = 0; n < 3; ++n) {
                    int n23 = (byArray4[n] & 0xFF) + (byArray[n] & 0xFF) * 256 + (byArray2[n] & 0xFF) * 65536 + (byArray3[n] & 0xFF) * 0x1000000;
                    this.stream.writeInt(n23);
                }
            } else {
                for (n = 0; n < n6; ++n) {
                    this.stream.writeByte(byArray3[n]);
                    this.stream.writeByte(byArray2[n]);
                    this.stream.writeByte(byArray[n]);
                    this.stream.writeByte(byArray4[n]);
                }
            }
        }
        n = this.w * n14;
        int[] nArray5 = new int[n * n7];
        this.bpixels = new byte[n3];
        if (this.compressionType == 4 || this.compressionType == 5) {
            this.embedded_stream = new ByteArrayOutputStream();
            this.writeEmbedded(iIOImage, bMPImageWriteParam);
            this.embedded_stream.flush();
            n17 = this.embedded_stream.size();
            long l2 = this.stream.getStreamPosition();
            n2 = n15 + n17;
            this.stream.seek(l);
            this.writeSize(n2, 2);
            this.stream.seek(l);
            this.writeSize(n17, 34);
            this.stream.seek(l2);
            this.stream.write(this.embedded_stream.toByteArray());
            this.embedded_stream = null;
            if (this.abortRequested()) {
                this.processWriteAborted();
            } else {
                this.processImageComplete();
                this.stream.flushBefore(this.stream.getStreamPosition());
            }
            return;
        }
        this.isTopDown = bMPImageWriteParam.isTopDown();
        int n24 = nArray2[0];
        for (int i = 1; i < nArray2.length; ++i) {
            if (nArray2[i] <= n24) continue;
            n24 = nArray2[i];
        }
        int[] nArray6 = new int[n24 + 1];
        for (int i = 0; i < this.h && !this.abortRequested(); ++i) {
            int n25;
            int n26;
            int n27;
            int n28 = n13 + i;
            if (!this.isTopDown) {
                n28 = n13 + this.h - i - 1;
            }
            Raster raster2 = raster;
            Rectangle rectangle2 = new Rectangle(n12 * n7 + n9, n28 * n8 + n10, (this.w - 1) * n7 + 1, 1);
            if (!bl2) {
                raster2 = renderedImage.getData(rectangle2);
            }
            if (bl3 && bl4) {
                Object object3;
                SampleModel sampleModel2 = raster2.getSampleModel();
                n27 = 0;
                n26 = rectangle2.x - raster2.getSampleModelTranslateX();
                n25 = rectangle2.y - raster2.getSampleModelTranslateY();
                if (sampleModel2 instanceof ComponentSampleModel) {
                    object3 = (ComponentSampleModel)sampleModel2;
                    n27 = ((ComponentSampleModel)object3).getOffset(n26, n25, 0);
                    for (int j = 1; j < ((SampleModel)object3).getNumBands(); ++j) {
                        if (n27 <= ((ComponentSampleModel)object3).getOffset(n26, n25, j)) continue;
                        n27 = ((ComponentSampleModel)object3).getOffset(n26, n25, j);
                    }
                } else if (sampleModel2 instanceof MultiPixelPackedSampleModel) {
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel2;
                    n27 = multiPixelPackedSampleModel.getOffset(n26, n25);
                } else if (sampleModel2 instanceof SinglePixelPackedSampleModel) {
                    SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel2;
                    n27 = singlePixelPackedSampleModel.getOffset(n26, n25);
                }
                if (this.compressionType == 0 || this.compressionType == 3) {
                    switch (n11) {
                        case 0: {
                            object3 = ((DataBufferByte)raster2.getDataBuffer()).getData();
                            this.stream.write((byte[])object3, n27, n3);
                            break;
                        }
                        case 2: {
                            short[] sArray = ((DataBufferShort)raster2.getDataBuffer()).getData();
                            this.stream.writeShorts(sArray, n27, n3);
                            break;
                        }
                        case 1: {
                            short[] sArray = ((DataBufferUShort)raster2.getDataBuffer()).getData();
                            this.stream.writeShorts(sArray, n27, n3);
                            break;
                        }
                        case 3: {
                            int[] nArray7 = ((DataBufferInt)raster2.getDataBuffer()).getData();
                            this.stream.writeInts(nArray7, n27, n3);
                        }
                    }
                    for (int j = 0; j < n22; ++j) {
                        this.stream.writeByte(0);
                    }
                } else if (this.compressionType == 2) {
                    if (this.bpixels == null || this.bpixels.length < n) {
                        this.bpixels = new byte[n];
                    }
                    raster2.getPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray5);
                    for (int j = 0; j < n; ++j) {
                        this.bpixels[j] = (byte)nArray5[j];
                    }
                    this.encodeRLE4(this.bpixels, n);
                } else if (this.compressionType == 1) {
                    if (this.bpixels == null || this.bpixels.length < n) {
                        this.bpixels = new byte[n];
                    }
                    raster2.getPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray5);
                    for (int j = 0; j < n; ++j) {
                        this.bpixels[j] = (byte)nArray5[j];
                    }
                    this.encodeRLE8(this.bpixels, n);
                }
            } else {
                raster2.getPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray5);
                if (n7 != 1 || n24 != n14 - 1 || bl5) {
                    int n29 = 0;
                    n27 = 0;
                    n26 = 0;
                    while (n29 < this.w) {
                        System.arraycopy(nArray5, n27, nArray6, 0, nArray6.length);
                        for (n25 = 0; n25 < n14; ++n25) {
                            nArray5[n26 + n14 - n25 - 1] = nArray6[nArray2[nArray[n25]]];
                        }
                        ++n29;
                        n27 += n7 * n14;
                        n26 += n14;
                    }
                }
                this.writePixels(0, n, n5, nArray5, n22, n14, indexColorModel);
            }
            this.processImageProgress(100.0f * ((float)i / (float)this.h));
        }
        if (this.compressionType == 2 || this.compressionType == 1) {
            this.stream.writeByte(0);
            this.stream.writeByte(1);
            this.incCompImageSize(2);
            n17 = this.compImageSize;
            n2 = this.compImageSize + n15;
            long l3 = this.stream.getStreamPosition();
            this.stream.seek(l);
            this.writeSize(n2, 2);
            this.stream.seek(l);
            this.writeSize(n17, 34);
            this.stream.seek(l3);
        }
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
            this.stream.flushBefore(this.stream.getStreamPosition());
        }
    }

    private void writePixels(int n, int n2, int n3, int[] nArray, int n4, int n5, IndexColorModel indexColorModel) throws IOException {
        int n6 = 0;
        int n7 = 0;
        switch (n3) {
            case 1: {
                int n8;
                for (n8 = 0; n8 < n2 / 8; ++n8) {
                    this.bpixels[n7++] = (byte)(nArray[n++] << 7 | nArray[n++] << 6 | nArray[n++] << 5 | nArray[n++] << 4 | nArray[n++] << 3 | nArray[n++] << 2 | nArray[n++] << 1 | nArray[n++]);
                }
                if (n2 % 8 > 0) {
                    n6 = 0;
                    for (n8 = 0; n8 < n2 % 8; ++n8) {
                        n6 |= nArray[n++] << 7 - n8;
                    }
                    this.bpixels[n7++] = (byte)n6;
                }
                this.stream.write(this.bpixels, 0, (n2 + 7) / 8);
                break;
            }
            case 4: {
                if (this.compressionType == 2) {
                    byte[] byArray = new byte[n2];
                    for (int i = 0; i < n2; ++i) {
                        byArray[i] = (byte)nArray[n++];
                    }
                    this.encodeRLE4(byArray, n2);
                    break;
                }
                for (int i = 0; i < n2 / 2; ++i) {
                    n6 = nArray[n++] << 4 | nArray[n++];
                    this.bpixels[n7++] = (byte)n6;
                }
                if (n2 % 2 == 1) {
                    n6 = nArray[n] << 4;
                    this.bpixels[n7++] = (byte)n6;
                }
                this.stream.write(this.bpixels, 0, (n2 + 1) / 2);
                break;
            }
            case 8: {
                if (this.compressionType == 1) {
                    for (int i = 0; i < n2; ++i) {
                        this.bpixels[i] = (byte)nArray[n++];
                    }
                    this.encodeRLE8(this.bpixels, n2);
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    this.bpixels[i] = (byte)nArray[n++];
                }
                this.stream.write(this.bpixels, 0, n2);
                break;
            }
            case 16: {
                if (this.spixels == null) {
                    this.spixels = new short[n2 / n5];
                }
                int n9 = 0;
                int n10 = 0;
                while (n9 < n2) {
                    this.spixels[n10] = 0;
                    int n11 = n5 - 1;
                    while (n11 >= 0) {
                        int n12 = n10;
                        this.spixels[n12] = (short)(this.spixels[n12] | nArray[n9] << this.bitPos[n11]);
                        --n11;
                        ++n9;
                    }
                    ++n10;
                }
                this.stream.writeShorts(this.spixels, 0, this.spixels.length);
                break;
            }
            case 24: {
                if (n5 == 3) {
                    for (int i = 0; i < n2; i += 3) {
                        this.bpixels[n7++] = (byte)nArray[n + 2];
                        this.bpixels[n7++] = (byte)nArray[n + 1];
                        this.bpixels[n7++] = (byte)nArray[n];
                        n += 3;
                    }
                    this.stream.write(this.bpixels, 0, n2);
                    break;
                }
                int n13 = indexColorModel.getMapSize();
                byte[] byArray = new byte[n13];
                byte[] byArray2 = new byte[n13];
                byte[] byArray3 = new byte[n13];
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
                for (int i = 0; i < n2; ++i) {
                    int n14 = nArray[n];
                    this.bpixels[n7++] = byArray3[n14];
                    this.bpixels[n7++] = byArray2[n14];
                    this.bpixels[n7++] = byArray3[n14];
                    ++n;
                }
                this.stream.write(this.bpixels, 0, n2 * 3);
                break;
            }
            case 32: {
                if (this.ipixels == null) {
                    this.ipixels = new int[n2 / n5];
                }
                int n15 = 0;
                int n16 = 0;
                while (n15 < n2) {
                    this.ipixels[n16] = 0;
                    int n17 = n5 - 1;
                    while (n17 >= 0) {
                        int n18 = n16;
                        this.ipixels[n18] = this.ipixels[n18] | nArray[n15] << this.bitPos[n17];
                        --n17;
                        ++n15;
                    }
                    ++n16;
                }
                this.stream.writeInts(this.ipixels, 0, this.ipixels.length);
            }
        }
        if (this.compressionType == 0) {
            for (n7 = 0; n7 < n4; ++n7) {
                this.stream.writeByte(0);
            }
        }
    }

    private void encodeRLE8(byte[] byArray, int n) throws IOException {
        int n2 = 1;
        int n3 = -1;
        int n4 = -1;
        byte by = 0;
        byte by2 = 0;
        by = byArray[++n4];
        byte[] byArray2 = new byte[256];
        while (n4 < n - 1) {
            int n5;
            if ((by2 = byArray[++n4]) == by) {
                if (n3 >= 3) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3);
                    this.incCompImageSize(2);
                    for (n5 = 0; n5 < n3; ++n5) {
                        this.stream.writeByte(byArray2[n5]);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n3)) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else if (n3 > -1) {
                    for (n5 = 0; n5 < n3; ++n5) {
                        this.stream.writeByte(1);
                        this.stream.writeByte(byArray2[n5]);
                        this.incCompImageSize(2);
                    }
                }
                n3 = -1;
                if (++n2 == 256) {
                    this.stream.writeByte(n2 - 1);
                    this.stream.writeByte(by);
                    this.incCompImageSize(2);
                    n2 = 1;
                }
            } else {
                if (n2 > 1) {
                    this.stream.writeByte(n2);
                    this.stream.writeByte(by);
                    this.incCompImageSize(2);
                } else if (n3 < 0) {
                    byArray2[++n3] = by;
                    byArray2[++n3] = by2;
                } else if (n3 < 254) {
                    byArray2[++n3] = by2;
                } else {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3 + 1);
                    this.incCompImageSize(2);
                    for (n5 = 0; n5 <= n3; ++n5) {
                        this.stream.writeByte(byArray2[n5]);
                        this.incCompImageSize(1);
                    }
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                    n3 = -1;
                }
                by = by2;
                n2 = 1;
            }
            if (n4 != n - 1) continue;
            if (n3 == -1) {
                this.stream.writeByte(n2);
                this.stream.writeByte(by);
                this.incCompImageSize(2);
                n2 = 1;
            } else if (n3 >= 2) {
                this.stream.writeByte(0);
                this.stream.writeByte(n3 + 1);
                this.incCompImageSize(2);
                for (n5 = 0; n5 <= n3; ++n5) {
                    this.stream.writeByte(byArray2[n5]);
                    this.incCompImageSize(1);
                }
                if (!this.isEven(n3 + 1)) {
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                }
            } else if (n3 > -1) {
                for (n5 = 0; n5 <= n3; ++n5) {
                    this.stream.writeByte(1);
                    this.stream.writeByte(byArray2[n5]);
                    this.incCompImageSize(2);
                }
            }
            this.stream.writeByte(0);
            this.stream.writeByte(0);
            this.incCompImageSize(2);
        }
    }

    private void encodeRLE4(byte[] byArray, int n) throws IOException {
        int n2 = 2;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray2 = new byte[256];
        by = byArray[++n4];
        by2 = byArray[++n4];
        while (n4 < n - 2) {
            int n7;
            by3 = byArray[++n4];
            by4 = byArray[++n4];
            if (by3 == by) {
                if (n3 >= 4) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3 - 1);
                    this.incCompImageSize(2);
                    for (n7 = 0; n7 < n3 - 2; n7 += 2) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.stream.writeByte((byte)n5);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n3 - 1)) {
                        n6 = byArray2[n3 - 2] << 4 | 0;
                        this.stream.writeByte(n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n3 - 1) / 2))) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else if (n3 > -1) {
                    this.stream.writeByte(2);
                    n5 = byArray2[0] << 4 | byArray2[1];
                    this.stream.writeByte(n5);
                    this.incCompImageSize(2);
                }
                n3 = -1;
                if (by4 == by2) {
                    if ((n2 += 2) == 256) {
                        this.stream.writeByte(n2 - 1);
                        n5 = by << 4 | by2;
                        this.stream.writeByte(n5);
                        this.incCompImageSize(2);
                        n2 = 2;
                        if (n4 < n - 1) {
                            by = by2;
                            by2 = byArray[++n4];
                        } else {
                            this.stream.writeByte(1);
                            n7 = by2 << 4 | 0;
                            this.stream.writeByte(n7);
                            this.incCompImageSize(2);
                            n2 = -1;
                        }
                    }
                } else {
                    n5 = by << 4 | by2;
                    this.stream.writeByte(++n2);
                    this.stream.writeByte(n5);
                    this.incCompImageSize(2);
                    n2 = 2;
                    by = by4;
                    if (n4 < n - 1) {
                        by2 = byArray[++n4];
                    } else {
                        this.stream.writeByte(1);
                        n7 = by4 << 4 | 0;
                        this.stream.writeByte(n7);
                        this.incCompImageSize(2);
                        n2 = -1;
                    }
                }
            } else {
                if (n2 > 2) {
                    n5 = by << 4 | by2;
                    this.stream.writeByte(n2);
                    this.stream.writeByte(n5);
                    this.incCompImageSize(2);
                } else if (n3 < 0) {
                    byArray2[++n3] = by;
                    byArray2[++n3] = by2;
                    byArray2[++n3] = by3;
                    byArray2[++n3] = by4;
                } else if (n3 < 253) {
                    byArray2[++n3] = by3;
                    byArray2[++n3] = by4;
                } else {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3 + 1);
                    this.incCompImageSize(2);
                    for (n7 = 0; n7 < n3; n7 += 2) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.stream.writeByte((byte)n5);
                        this.incCompImageSize(1);
                    }
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                    n3 = -1;
                }
                by = by3;
                by2 = by4;
                n2 = 2;
            }
            if (n4 < n - 2) continue;
            if (n3 == -1 && n2 >= 2) {
                if (n4 == n - 2) {
                    if (byArray[++n4] == by) {
                        n5 = by << 4 | by2;
                        this.stream.writeByte(++n2);
                        this.stream.writeByte(n5);
                        this.incCompImageSize(2);
                    } else {
                        n5 = by << 4 | by2;
                        this.stream.writeByte(n2);
                        this.stream.writeByte(n5);
                        this.stream.writeByte(1);
                        n5 = byArray[n4] << 4 | 0;
                        this.stream.writeByte(n5);
                        n7 = byArray[n4] << 4 | 0;
                        this.incCompImageSize(4);
                    }
                } else {
                    this.stream.writeByte(n2);
                    n5 = by << 4 | by2;
                    this.stream.writeByte(n5);
                    this.incCompImageSize(2);
                }
            } else if (n3 > -1) {
                if (n4 == n - 2) {
                    byArray2[++n3] = byArray[++n4];
                }
                if (n3 >= 2) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n3 + 1);
                    this.incCompImageSize(2);
                    for (n7 = 0; n7 < n3; n7 += 2) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.stream.writeByte((byte)n5);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n3 + 1)) {
                        n6 = byArray2[n3] << 4 | 0;
                        this.stream.writeByte(n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n3 + 1) / 2))) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else {
                    switch (n3) {
                        case 0: {
                            this.stream.writeByte(1);
                            n7 = byArray2[0] << 4 | 0;
                            this.stream.writeByte(n7);
                            this.incCompImageSize(2);
                            break;
                        }
                        case 1: {
                            this.stream.writeByte(2);
                            n5 = byArray2[0] << 4 | byArray2[1];
                            this.stream.writeByte(n5);
                            this.incCompImageSize(2);
                        }
                    }
                }
            }
            this.stream.writeByte(0);
            this.stream.writeByte(0);
            this.incCompImageSize(2);
        }
    }

    private synchronized void incCompImageSize(int n) {
        this.compImageSize += n;
    }

    private boolean isEven(int n) {
        return n % 2 == 0;
    }

    private void writeFileHeader(int n, int n2) throws IOException {
        this.stream.writeByte(66);
        this.stream.writeByte(77);
        this.stream.writeInt(n);
        this.stream.writeInt(0);
        this.stream.writeInt(n2);
    }

    private void writeInfoHeader(int n, int n2) throws IOException {
        this.stream.writeInt(n);
        this.stream.writeInt(this.w);
        this.stream.writeInt(this.h);
        this.stream.writeShort(1);
        this.stream.writeShort(n2);
    }

    private void writeSize(int n, int n2) throws IOException {
        this.stream.skipBytes(n2);
        this.stream.writeInt(n);
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    private int getCompressionType(String string) {
        for (int i = 0; i < BMPConstants.compressionTypeNames.length; ++i) {
            if (!BMPConstants.compressionTypeNames[i].equals(string)) continue;
            return i;
        }
        return 0;
    }

    private void writeEmbedded(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        String string = this.compressionType == 4 ? "jpeg" : "png";
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        ImageWriter imageWriter = null;
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (imageWriter != null) {
            if (this.embedded_stream == null) {
                throw new RuntimeException("No stream for writing embedded image!");
            }
        } else {
            throw new RuntimeException(I18N.getString("BMPImageWrite5") + " " + string);
        }
        imageWriter.addIIOWriteProgressListener(new IIOWriteProgressAdapter(){

            public void imageProgress(ImageWriter imageWriter, float f) {
                BMPImageWriter.this.processImageProgress(f);
            }
        });
        imageWriter.addIIOWriteWarningListener(new IIOWriteWarningListener(){

            public void warningOccurred(ImageWriter imageWriter, int n, String string) {
                BMPImageWriter.this.processWarningOccurred(n, string);
            }
        });
        imageWriter.setOutput(ImageIO.createImageOutputStream(this.embedded_stream));
        ImageWriteParam imageWriteParam2 = imageWriter.getDefaultWriteParam();
        imageWriteParam2.setDestinationOffset(imageWriteParam.getDestinationOffset());
        imageWriteParam2.setSourceBands(imageWriteParam.getSourceBands());
        imageWriteParam2.setSourceRegion(imageWriteParam.getSourceRegion());
        imageWriteParam2.setSourceSubsampling(imageWriteParam.getSourceXSubsampling(), imageWriteParam.getSourceYSubsampling(), imageWriteParam.getSubsamplingXOffset(), imageWriteParam.getSubsamplingYOffset());
        imageWriter.write(null, iIOImage, imageWriteParam2);
    }

    private int firstLowBit(int n) {
        int n2 = 0;
        while ((n & 1) == 0) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }

    protected int getPreferredCompressionType(ColorModel colorModel, SampleModel sampleModel) {
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        return this.getPreferredCompressionType(imageTypeSpecifier);
    }

    protected int getPreferredCompressionType(ImageTypeSpecifier imageTypeSpecifier) {
        if (imageTypeSpecifier.getBufferedImageType() == 8) {
            return 3;
        }
        return 0;
    }

    protected boolean canEncodeImage(int n, ColorModel colorModel, SampleModel sampleModel) {
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        return this.canEncodeImage(n, imageTypeSpecifier);
    }

    protected boolean canEncodeImage(int n, ImageTypeSpecifier imageTypeSpecifier) {
        ImageWriterSpi imageWriterSpi = this.getOriginatingProvider();
        if (!imageWriterSpi.canEncodeImage(imageTypeSpecifier)) {
            return false;
        }
        int n2 = imageTypeSpecifier.getBufferedImageType();
        if (n2 == 8 && n != 3) {
            return false;
        }
        int n3 = imageTypeSpecifier.getColorModel().getPixelSize();
        if (this.compressionType == 2 && n3 != 4) {
            return false;
        }
        return this.compressionType != 1 || n3 == 8;
    }

    private class IIOWriteProgressAdapter
    implements IIOWriteProgressListener {
        private IIOWriteProgressAdapter() {
        }

        public void imageComplete(ImageWriter imageWriter) {
        }

        public void imageProgress(ImageWriter imageWriter, float f) {
        }

        public void imageStarted(ImageWriter imageWriter, int n) {
        }

        public void thumbnailComplete(ImageWriter imageWriter) {
        }

        public void thumbnailProgress(ImageWriter imageWriter, float f) {
        }

        public void thumbnailStarted(ImageWriter imageWriter, int n, int n2) {
        }

        public void writeAborted(ImageWriter imageWriter) {
        }
    }
}

