/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanServerConnection;

public class ThreadMonitor {
    private ThreadMXBean tmbean;
    private static String INDENT = "    ";

    public ThreadMonitor(MBeanServerConnection mBeanServerConnection) throws IOException {
        this.tmbean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Threading", ThreadMXBean.class);
    }

    public ThreadMonitor() {
        this.tmbean = ManagementFactory.getThreadMXBean();
    }

    public void dumpThreadInfo() {
        ThreadInfo[] threadInfoArray;
        System.out.println("Full Java thread dump");
        long[] lArray = this.tmbean.getAllThreadIds();
        for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.getThreadInfo(lArray, Integer.MAX_VALUE)) {
            this.printThreadInfo(threadInfo);
        }
    }

    private void printThreadInfo(ThreadInfo threadInfo) {
        StringBuilder stringBuilder = new StringBuilder("\"" + threadInfo.getThreadName() + "\"" + " Id=" + threadInfo.getThreadId() + " in " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            stringBuilder.append(" on lock=" + threadInfo.getLockName());
        }
        if (threadInfo.isSuspended()) {
            stringBuilder.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            stringBuilder.append(" (running in native)");
        }
        System.out.println(stringBuilder.toString());
        if (threadInfo.getLockOwnerName() != null) {
            System.out.println(INDENT + " owned by " + threadInfo.getLockOwnerName() + " Id=" + threadInfo.getLockOwnerId());
        }
        for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
            System.out.println(INDENT + "at " + stackTraceElement.toString());
        }
        System.out.println();
    }

    public boolean findDeadlock() {
        ThreadInfo[] threadInfoArray;
        long[] lArray = this.tmbean.findMonitorDeadlockedThreads();
        if (lArray == null) {
            return false;
        }
        System.out.println("Deadlock found :-");
        for (ThreadInfo threadInfo : threadInfoArray = this.tmbean.getThreadInfo(lArray, Integer.MAX_VALUE)) {
            this.printThreadInfo(threadInfo);
        }
        return true;
    }
}

