/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.panel.PlatformSpecificUtils;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UpdatePanel
extends JPanel
implements ActionListener {
    private int update_notify = 0;
    private int update_frequency = 1;
    private int update_day = 1;
    private int update_schedule = 0;
    private String update_lastrun;
    private static final String update_image = "com/sun/deploy/resources/image/JavaUpdateIcon-48.png";
    private JButton updateNowBtn;
    private JButton advancedUpdateBtn;
    private JComboBox notifyComboBox;
    private JCheckBox autoUpdateChBox;
    private JSmartTextArea updateScheduleTextArea;
    private JSmartTextArea lastUpdatedTextArea;
    private String textDesc;
    private DateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US);
    private String sysTrayIconText = this.getMessage("update.desc_systrayicon.text");
    private String[] weekDays;
    private String[] atComboBoxText;
    private boolean javaUpdateEnabled = false;
    private boolean javaUpdateEditPrefs = false;
    private boolean autoUpdateCheck = false;
    private boolean schedulerPlatform = true;
    private boolean manualUpdateEnabled = true;
    private boolean corporateOverride = false;

    UpdatePanel() {
        PlatformSpecificUtils platformSpecificUtils = new PlatformSpecificUtils();
        platformSpecificUtils.onLoad(this);
        this.setLayout(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(new Insets(5, 5, 5, 5));
        TitledBorder titledBorder = new TitledBorder(new TitledBorder(new EtchedBorder()), this.getMessage("update.notify.border.text"), 0, 0);
        this.setBorder(BorderFactory.createCompoundBorder(emptyBorder, titledBorder));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource(update_image));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        jPanel2.add((Component)jLabel, "North");
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm");
        this.weekDays = dateFormatSymbols.getWeekdays();
        this.atComboBoxText = new String[24];
        for (int i = 0; i < 24; ++i) {
            try {
                Date date = simpleDateFormat.parse(i + ":00");
                this.atComboBoxText[i] = dateFormat.format(date);
                continue;
            }
            catch (Exception exception) {
                this.atComboBoxText[i] = i + ":00";
            }
        }
        JSmartTextArea jSmartTextArea = new JSmartTextArea(this.getMessage("update.desc.text"));
        jPanel4.add((Component)jSmartTextArea, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new MyBoxLayout(jPanel6, 0));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 8));
        JLabel jLabel2 = new JLabel(this.getMessage("update.notify.text"));
        this.notifyComboBox = new UComboBox();
        this.notifyComboBox.addItem(this.getMessage("update.notify_download.text"));
        this.notifyComboBox.addItem(this.getMessage("update.notify_install.text"));
        this.notifyComboBox.addActionListener(this);
        this.notifyComboBox.setToolTipText(this.getMessage("update.notify_combo.tooltip"));
        jPanel6.add(jLabel2);
        jPanel6.add(Box.createGlue());
        jPanel6.add(this.notifyComboBox);
        jPanel5.add((Component)jPanel6, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new MyBoxLayout(jPanel7, 0));
        jPanel7.setBorder(BorderFactory.createEmptyBorder(5, 7, 5, 8));
        this.autoUpdateChBox = new JCheckBox(this.getMessage("update.autoupdate.text"));
        this.autoUpdateChBox.addActionListener(this);
        this.autoUpdateChBox.setEnabled(!this.corporateOverride);
        this.advancedUpdateBtn = new JButton(this.getMessage("update.advanced.button.text"));
        this.advancedUpdateBtn.setMnemonic(ResourceManager.getVKCode("update.advanced.button.mnemonic"));
        this.advancedUpdateBtn.setToolTipText(this.getMessage("update.advanced_btn.tooltip"));
        this.advancedUpdateBtn.addActionListener(this);
        jPanel7.add(this.autoUpdateChBox);
        jPanel7.add(Box.createGlue());
        jPanel7.add(this.advancedUpdateBtn);
        jPanel5.add((Component)jPanel7, "South");
        jPanel3.add((Component)jPanel5, "North");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(1, 1));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.updateScheduleTextArea = new JSmartTextArea(" ");
        jPanel8.add(this.updateScheduleTextArea);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(1, 1));
        jPanel9.add(jPanel8);
        jPanel3.add((Component)jPanel9, "Center");
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(8);
        JPanel jPanel10 = new JPanel(borderLayout);
        jPanel10.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.lastUpdatedTextArea = new JSmartTextArea(" ");
        this.updateNowBtn = new JButton(this.getMessage("update.updatenow.button.text"));
        this.updateNowBtn.setMnemonic(ResourceManager.getVKCode("update.updatenow.button.mnemonic"));
        this.updateNowBtn.setToolTipText(this.getMessage("update.now_btn.tooltip"));
        this.updateNowBtn.addActionListener(this);
        this.updateNowBtn.setEnabled(this.manualUpdateEnabled);
        jPanel10.add((Component)this.lastUpdatedTextArea, "Center");
        jPanel10.add((Component)this.updateNowBtn, "East");
        jPanel3.add((Component)jPanel10, "South");
        jPanel.add((Component)jPanel3, "Center");
        this.add((Component)jPanel, "Center");
        this.reset();
    }

    public void reset() {
        if (this.isSchedulerPlatform()) {
            this.autoUpdateChBox.setSelected(this.isAutoUpdateChecked());
        } else {
            this.autoUpdateChBox.setEnabled(false);
        }
        this.notifyComboBox.setSelectedIndex(this.getUpdateNotify());
        this.setText();
        String string = this.getUpdateLastRun();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            gregorianCalendar.setTime(this.df.parse(string));
        }
        catch (Exception exception) {
            string = null;
            System.out.println("got exception:" + exception);
        }
        if (string == null) {
            string = new String("    ");
        } else {
            DateFormat dateFormat = DateFormat.getTimeInstance(3);
            DateFormat dateFormat2 = DateFormat.getDateInstance(3);
            MessageFormat messageFormat = new MessageFormat(this.getMessage("update.lastrun.text"));
            String string2 = dateFormat.format(gregorianCalendar.getTime());
            String string3 = dateFormat2.format(gregorianCalendar.getTime());
            string = messageFormat.format(new String[]{string2, string3});
        }
        this.lastUpdatedTextArea.setText(string);
    }

    private void setText() {
        if (!this.autoUpdateChBox.isSelected()) {
            this.notifyComboBox.setEnabled(false);
            this.advancedUpdateBtn.setEnabled(false);
            this.textDesc = this.getMessage("update.desc_autooff.text");
            this.updateScheduleTextArea.setText(this.textDesc);
        } else {
            MessageFormat messageFormat;
            this.notifyComboBox.setEnabled(true);
            this.advancedUpdateBtn.setEnabled(true);
            int n = this.getUpdateFrequency();
            String string = this.atComboBoxText[this.getUpdateSchedule()];
            String string2 = null;
            if (n == 0) {
                this.textDesc = this.getMessage("update.desc_check_daily.text");
                messageFormat = new MessageFormat(this.textDesc);
                this.textDesc = messageFormat.format(new String[]{string});
            } else if (n == 2) {
                this.textDesc = this.getMessage("update.desc_check_monthly.text");
                string2 = String.valueOf(this.getUpdateDay());
            } else {
                this.textDesc = this.getMessage("update.desc_check_weekly.text");
                string2 = String.valueOf(this.weekDays[this.getUpdateDay()]);
            }
            if (string2 != null) {
                messageFormat = new MessageFormat(this.textDesc);
                this.textDesc = messageFormat.format(new String[]{string2, string});
            }
            this.textDesc = this.textDesc + this.sysTrayIconText;
            n = this.notifyComboBox.getSelectedIndex();
            this.textDesc = n == 1 ? this.textDesc + this.getMessage("update.desc_notify_install.text") : this.textDesc + this.getMessage("update.desc_notify_download.text");
            this.updateScheduleTextArea.setText(this.textDesc);
        }
        if (!this.javaUpdateEditPrefs) {
            this.autoUpdateChBox.setEnabled(false);
            this.advancedUpdateBtn.setEnabled(false);
            this.notifyComboBox.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.updateNowBtn) {
                String string = System.getProperty("java.home") + File.separator + "bin" + File.separator + "jucheck.exe";
                try {
                    Runtime.getRuntime().exec(string);
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                    String[] stringArray = new String[]{"cmd", "/c", string};
                    Runtime.getRuntime().exec(stringArray);
                }
            } else if (actionEvent.getSource() == this.advancedUpdateBtn) {
                new AdvancedDialog(this);
            } else if (actionEvent.getSource() == this.notifyComboBox) {
                int n = this.notifyComboBox.getSelectedIndex();
                this.setUpdateNotify(n);
                this.setText();
                ControlPanel.propertyHasChanged();
            } else if (actionEvent.getSource() == this.autoUpdateChBox) {
                boolean bl = this.autoUpdateChBox.isSelected();
                this.setAutoUpdateCheck(bl);
                this.setText();
                ControlPanel.propertyHasChanged();
            }
        }
        catch (Exception exception) {
            DialogFactory.showExceptionDialog(this, exception);
        }
    }

    public String[] getAtComboBoxText() {
        return this.atComboBoxText;
    }

    public String[] getWeekDays() {
        return this.weekDays;
    }

    public void setManualUpdate(boolean bl) {
        this.manualUpdateEnabled = bl;
    }

    public void setCorporateOverride(boolean bl) {
        this.corporateOverride = bl;
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void saveUpdateSettingsInReg() {
        PlatformSpecificUtils platformSpecificUtils = new PlatformSpecificUtils();
        platformSpecificUtils.onSave(this);
    }

    public void setUpdateNotify(int n) {
        this.update_notify = n;
    }

    public int getUpdateNotify() {
        return this.update_notify;
    }

    public void setUpdateFrequency(int n) {
        this.update_frequency = n;
    }

    public void setUpdateDay(int n) {
        this.update_day = n;
    }

    public int getUpdateFrequency() {
        return this.update_frequency;
    }

    public int getUpdateDay() {
        return this.update_day;
    }

    public void setUpdateSchedule(int n) {
        this.update_schedule = n;
    }

    public int getUpdateSchedule() {
        return this.update_schedule;
    }

    public void setUpdateLastRun(String string) {
        this.update_lastrun = string;
    }

    public String getUpdateLastRun() {
        return this.update_lastrun;
    }

    public void enableJavaUpdate(boolean bl) {
        this.javaUpdateEnabled = bl;
    }

    public boolean isJavaUpdateEnabled() {
        return this.javaUpdateEnabled;
    }

    public void enableEditPrefs(boolean bl) {
        this.javaUpdateEditPrefs = bl;
    }

    public void setAutoUpdateCheck(boolean bl) {
        int n = 1;
        if (!bl && bl != this.autoUpdateCheck) {
            String string = ResourceManager.getMessage("update.autoupdate.disable.neverCheck");
            String string2 = ResourceManager.getMessage("update.warning");
            String string3 = ResourceManager.getMessage("update.autoupdate.disable.message");
            String string4 = ResourceManager.getMessage("update.autoupdate.disable.info");
            String string5 = ResourceManager.getMessage("update.autoupdate.disable.monthlyCheck");
            if (this.getUpdateFrequency() == 0) {
                string5 = ResourceManager.getMessage("update.autoupdate.disable.dailyCheck");
            } else if (this.getUpdateFrequency() == 1) {
                string5 = ResourceManager.getMessage("update.autoupdate.disable.weeklyCheck");
            }
            n = UIFactory.showWarningDialog(null, null, string3, string4, string2, string5, string);
        }
        if (n == 0) {
            this.autoUpdateChBox.setSelected(true);
        } else {
            this.autoUpdateCheck = bl;
        }
    }

    public boolean isAutoUpdateChecked() {
        return this.autoUpdateCheck;
    }

    public void setSchedulerPlatform(boolean bl) {
        this.schedulerPlatform = bl;
    }

    public boolean isSchedulerPlatform() {
        return this.schedulerPlatform;
    }

    private class AdvancedDialog
    implements ActionListener {
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    if (changeEvent.getSource() == AdvancedDialog.this.daymodel) {
                        AdvancedDialog.this.setPanelOptions();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        private UpdatePanel updPanel;
        private JRadioButton RButton1;
        private JRadioButton RButton2;
        private JRadioButton RButton3;
        private JRadioButton RButtonLast = null;
        private ButtonGroup FreqGroup;
        private String[] weekDays;
        private String[] atComboBoxText;
        private JComboBox at;
        private JComboBox every;
        JSpinner day;
        SpinnerNumberModel daymodel;
        private String atLabelText;
        private String everyLabelText;
        private String dayLabelText;
        private JLabel whenLabel1;
        private JLabel whenLabel2;
        private JLabel descLabel;
        private JLabel dummyLabel;
        JPanel whenPanel1;
        JPanel whenPanel2;
        JPanel whenPanel;
        GridBagConstraints c;

        public AdvancedDialog(UpdatePanel updatePanel2) {
            this.updPanel = updatePanel2;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.c = new GridBagConstraints();
            this.c.anchor = 17;
            this.c.fill = 0;
            this.c.insets = new Insets(5, 0, 0, 0);
            this.c.weighty = 1.0;
            this.c.weightx = 0.0;
            this.c.gridwidth = 0;
            jPanel.add((Component)new JLabel(updatePanel2.getMessage("update.advanced_title1.text")), this.c);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            Border border = BorderFactory.createEtchedBorder();
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, updatePanel2.getMessage("update.advanced_title2.text"))));
            this.RButton1 = new JRadioButton(updatePanel2.getMessage("update.check_daily.text"));
            this.RButton2 = new JRadioButton(updatePanel2.getMessage("update.check_weekly.text"));
            this.RButton3 = new JRadioButton(updatePanel2.getMessage("update.check_monthly.text"));
            this.FreqGroup = new ButtonGroup();
            this.FreqGroup.add(this.RButton1);
            this.FreqGroup.add(this.RButton2);
            this.FreqGroup.add(this.RButton3);
            this.RButton1.addActionListener(this);
            this.RButton2.addActionListener(this);
            this.RButton3.addActionListener(this);
            jPanel2.add(this.RButton1);
            jPanel2.add(this.RButton2);
            jPanel2.add(this.RButton3);
            this.c.weighty = 3.0;
            this.c.weightx = 0.0;
            this.c.gridwidth = 2;
            this.c.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)jPanel2, this.c);
            this.whenPanel = new JPanel();
            this.whenPanel.setLayout(new GridBagLayout());
            this.whenPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, updatePanel2.getMessage("update.advanced_title3.text"))));
            this.atComboBoxText = updatePanel2.getAtComboBoxText();
            this.weekDays = updatePanel2.getWeekDays();
            this.dummyLabel = new JLabel("    ");
            this.everyLabelText = updatePanel2.getMessage("update.check_day.text");
            this.atLabelText = updatePanel2.getMessage("update.check_time.text");
            this.dayLabelText = updatePanel2.getMessage("update.check_date.text");
            this.whenLabel1 = new JLabel();
            this.whenLabel2 = new JLabel();
            this.every = new UComboBox();
            this.every.setMaximumRowCount(7);
            this.every.addItem(this.weekDays[1]);
            this.every.addItem(this.weekDays[2]);
            this.every.addItem(this.weekDays[3]);
            this.every.addItem(this.weekDays[4]);
            this.every.addItem(this.weekDays[5]);
            this.every.addItem(this.weekDays[6]);
            this.every.addItem(this.weekDays[7]);
            this.every.addActionListener(this);
            this.at = new UComboBox();
            this.at.setMaximumRowCount(this.atComboBoxText.length);
            for (int i = 0; i < this.atComboBoxText.length; ++i) {
                this.at.addItem(this.atComboBoxText[i]);
            }
            this.at.addActionListener(this);
            this.daymodel = new SpinnerNumberModel(1, 1, 31, 1);
            this.day = new JSpinner(this.daymodel);
            this.daymodel.addChangeListener(this.changeListener);
            this.c.anchor = 17;
            this.whenPanel1 = new JPanel();
            this.whenPanel2 = new JPanel();
            this.c.insets = new Insets(0, 10, 0, 5);
            this.c.gridwidth = 2;
            this.c.gridheight = 2;
            this.c.weighty = 0.0;
            this.c.weightx = 0.0;
            this.whenPanel.add((Component)this.whenLabel1, this.c);
            this.c.gridwidth = 0;
            this.c.weightx = 2.0;
            this.c.fill = 2;
            this.whenPanel.add((Component)this.whenPanel1, this.c);
            this.c.gridwidth = 2;
            this.c.fill = 0;
            this.c.weightx = 0.0;
            this.c.gridheight = 0;
            this.whenPanel.add((Component)this.whenLabel2, this.c);
            this.c.weightx = 1.0;
            this.c.fill = 2;
            this.c.gridwidth = 0;
            this.whenPanel.add((Component)this.whenPanel2, this.c);
            this.c.weightx = 2.0;
            this.c.weighty = 3.0;
            this.c.fill = 1;
            this.c.gridheight = -1;
            this.c.insets = new Insets(0, 5, 0, 0);
            this.c.gridwidth = 0;
            jPanel.add((Component)this.whenPanel, this.c);
            if (updatePanel2.getUpdateFrequency() == 0) {
                this.RButton1.setSelected(true);
            } else if (updatePanel2.getUpdateFrequency() == 2) {
                this.RButton3.setSelected(true);
                this.day.setValue(new Integer(updatePanel2.getUpdateDay()));
            } else {
                this.RButton2.setSelected(true);
                this.every.setSelectedIndex(updatePanel2.getUpdateDay() - 1);
            }
            this.at.setSelectedIndex(updatePanel2.getUpdateSchedule());
            this.descLabel = new JLabel("  ");
            this.descLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, "")));
            this.c.fill = 2;
            this.c.weightx = 1.0;
            this.c.weighty = 1.0;
            this.c.insets = new Insets(0, 0, 0, 0);
            this.c.gridwidth = 0;
            jPanel.add((Component)this.descLabel, this.c);
            this.setPanelOptions();
            JOptionPane jOptionPane = new JOptionPane(jPanel, -1, 2);
            JDialog jDialog = jOptionPane.createDialog(updatePanel2, updatePanel2.getMessage("update.advanced_title.text"));
            jDialog.setModal(true);
            jDialog.setDefaultCloseOperation(2);
            jDialog.setVisible(true);
            Integer n = (Integer)jOptionPane.getValue();
            if (n != null && n == 0) {
                updatePanel2.setUpdateSchedule(this.at.getSelectedIndex());
                if (this.RButton1.isSelected()) {
                    updatePanel2.setUpdateFrequency(0);
                    updatePanel2.setUpdateDay(0);
                } else if (this.RButton3.isSelected()) {
                    updatePanel2.setUpdateFrequency(2);
                    updatePanel2.setUpdateDay((Integer)this.day.getValue());
                } else {
                    updatePanel2.setUpdateFrequency(1);
                    updatePanel2.setUpdateDay(this.every.getSelectedIndex() + 1);
                }
                ControlPanel.propertyHasChanged();
            }
            updatePanel2.setText();
        }

        void setPanelOptions() {
            MessageFormat messageFormat;
            String string = null;
            String string2 = null;
            if (this.RButton1.isSelected()) {
                if (!this.RButton1.equals(this.RButtonLast)) {
                    this.day.setVisible(false);
                    this.every.setVisible(false);
                    this.whenLabel1.setText("  ");
                    this.whenLabel2.setText(this.atLabelText);
                    this.whenPanel1.add(this.dummyLabel);
                    this.whenPanel2.add(this.at);
                    this.at.setVisible(true);
                    this.dummyLabel.setVisible(true);
                    this.RButtonLast = this.RButton1;
                }
                string = this.updPanel.getMessage("update.advanced_desc1.text");
                messageFormat = new MessageFormat(string);
                string = messageFormat.format(new String[]{(String)this.at.getItemAt(this.at.getSelectedIndex())});
            } else if (this.RButton2.isSelected()) {
                if (!this.RButton2.equals(this.RButtonLast)) {
                    this.day.setVisible(false);
                    this.dummyLabel.setVisible(false);
                    this.whenLabel1.setText(this.everyLabelText);
                    this.whenLabel2.setText(this.atLabelText);
                    this.whenPanel1.add(this.every);
                    this.whenPanel2.add(this.at);
                    this.every.setVisible(true);
                    this.at.setVisible(true);
                    this.RButtonLast = this.RButton2;
                }
                string2 = (String)this.every.getItemAt(this.every.getSelectedIndex());
                string = this.updPanel.getMessage("update.advanced_desc2.text");
            } else if (this.RButton3.isSelected()) {
                if (!this.RButton3.equals(this.RButtonLast)) {
                    this.dummyLabel.setVisible(false);
                    this.every.setVisible(false);
                    this.whenLabel1.setText(this.dayLabelText);
                    this.whenLabel2.setText(this.atLabelText);
                    this.whenPanel1.add(this.day);
                    this.whenPanel2.add(this.at);
                    this.day.setVisible(true);
                    this.at.setVisible(true);
                    this.RButtonLast = this.RButton3;
                }
                string2 = String.valueOf((Integer)this.day.getValue());
                string = this.updPanel.getMessage("update.advanced_desc3.text");
            }
            if (string2 != null) {
                messageFormat = new MessageFormat(string);
                string = messageFormat.format(new String[]{string2, (String)this.at.getItemAt(this.at.getSelectedIndex())});
            }
            this.descLabel.setText(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == this.RButton1 || actionEvent.getSource() == this.RButton2 || actionEvent.getSource() == this.RButton3 || actionEvent.getSource() == this.every || actionEvent.getSource() == this.at) {
                    this.setPanelOptions();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class MyBoxLayout
    extends BoxLayout {
        public MyBoxLayout(Container container, int n) {
            super(container, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = container.getWidth();
            Dimension dimension = super.preferredLayoutSize(container);
            if (n > 0 && dimension.width > n) {
                Component[] componentArray = container.getComponents();
                container.removeAll();
                container.setLayout(new BorderLayout());
                if (componentArray.length > 0) {
                    container.add(componentArray[0], "North");
                }
                if (componentArray.length > 2) {
                    container.add(componentArray[2], "East");
                }
                return container.getLayout().preferredLayoutSize(container);
            }
            return dimension;
        }
    }

    private class UComboBox
    extends JComboBox {
        private UComboBox() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width += 8;
            return dimension;
        }
    }
}

