/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DeleteFilesDialog {
    private JCheckBox appletsCheckBox;
    private JCheckBox applicationCheckBox;
    private JCheckBox tempFilesCheckBox;

    public DeleteFilesDialog(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(this.getMessage("delete.files.dlg.temp_files"));
        this.appletsCheckBox = new JCheckBox(this.getMessage("delete.files.dlg.applets"));
        this.appletsCheckBox.setSelected(true);
        this.applicationCheckBox = new JCheckBox(this.getMessage("delete.files.dlg.applications"));
        this.applicationCheckBox.setSelected(true);
        this.tempFilesCheckBox = new JCheckBox(this.getMessage("delete.files.dlg.other"));
        this.tempFilesCheckBox.setSelected(true);
        jPanel.add(jLabel);
        jPanel.add(new JLabel("   "));
        jPanel.add(this.appletsCheckBox);
        jPanel.add(this.applicationCheckBox);
        jPanel.add(this.tempFilesCheckBox);
        int n = JOptionPane.showConfirmDialog(component, jPanel, this.getMessage("delete.files.dlg.title"), 2);
        if (n == 0) {
            Object object;
            if (this.appletsCheckBox.isSelected()) {
                object = new File(Config.getPluginCacheDir());
                this.deleteFiles((File)object);
            }
            if (this.applicationCheckBox.isSelected()) {
                object = new String[]{Config.getJavawsCommand(), "-uninstall"};
                try {
                    Runtime.getRuntime().exec((String[])object);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.tempFilesCheckBox.isSelected()) {
                object = new File(Config.getLogDirectory());
                this.deleteFiles((File)object);
                object = new File(Config.getUserExtensionDirectory());
                this.deleteFiles((File)object);
                object = new File(Config.getTempCacheDir());
                this.deleteFiles((File)object);
            }
        }
    }

    private void deleteFilesWithExtension(File file, String string) {
        String string2 = "." + string;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.deleteFilesWithExtension(fileArray[i], string);
                fileArray[i].delete();
                continue;
            }
            if (!fileArray[i].getPath().endsWith(string2)) continue;
            fileArray[i].delete();
        }
    }

    private void deleteFiles(File file) {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deleteFiles(fileArray[i]);
                }
                fileArray[i].delete();
            }
        }
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }
}

