/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util.links;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.WildcardType;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkInfo;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkOutput;

public abstract class LinkFactory {
    protected abstract LinkOutput getOutputInstance();

    public LinkOutput getLinkOutput(LinkInfo linkInfo) {
        if (linkInfo.type != null) {
            Type type = linkInfo.type;
            LinkOutput linkOutput = this.getOutputInstance();
            if (type.isPrimitive()) {
                linkInfo.displayLength += type.typeName().length();
                linkOutput.append(type.typeName());
            } else if (type.asWildcardType() != null) {
                linkInfo.isTypeBound = true;
                ++linkInfo.displayLength;
                linkOutput.append("?");
                WildcardType wildcardType = type.asWildcardType();
                Type[] typeArray = wildcardType.extendsBounds();
                for (int i = 0; i < typeArray.length; ++i) {
                    linkInfo.displayLength = linkInfo.displayLength + (i > 0 ? 2 : 9);
                    linkOutput.append(i > 0 ? ", " : " extends ");
                    this.setBoundsLinkInfo(linkInfo, typeArray[i]);
                    linkOutput.append(this.getLinkOutput(linkInfo));
                }
                Type[] typeArray2 = wildcardType.superBounds();
                for (int i = 0; i < typeArray2.length; ++i) {
                    linkInfo.displayLength = linkInfo.displayLength + (i > 0 ? 2 : 7);
                    linkOutput.append(i > 0 ? ", " : " super ");
                    this.setBoundsLinkInfo(linkInfo, typeArray2[i]);
                    linkOutput.append(this.getLinkOutput(linkInfo));
                }
            } else if (type.asTypeVariable() != null) {
                linkInfo.isTypeBound = true;
                ProgramElementDoc programElementDoc = type.asTypeVariable().owner();
                if (!linkInfo.excludeTypeParameterLinks && programElementDoc instanceof ClassDoc) {
                    linkInfo.classDoc = (ClassDoc)programElementDoc;
                    linkInfo.label = type.typeName();
                    linkOutput.append(this.getClassLink(linkInfo));
                } else {
                    linkInfo.displayLength += type.typeName().length();
                    linkOutput.append(type.typeName());
                }
                Type[] typeArray = type.asTypeVariable().bounds();
                if (!linkInfo.excludeTypeBounds) {
                    linkInfo.excludeTypeBounds = true;
                    for (int i = 0; i < typeArray.length; ++i) {
                        linkInfo.displayLength = linkInfo.displayLength + (i > 0 ? 2 : 9);
                        linkOutput.append(i > 0 ? " & " : " extends ");
                        this.setBoundsLinkInfo(linkInfo, typeArray[i]);
                        linkOutput.append(this.getLinkOutput(linkInfo));
                    }
                }
            } else if (type.asClassDoc() != null) {
                if (linkInfo.isTypeBound && linkInfo.excludeTypeBoundsLinks) {
                    linkInfo.displayLength += type.typeName().length();
                    linkOutput.append(type.typeName());
                    linkOutput.append(this.getTypeParameterLinks(linkInfo));
                    return linkOutput;
                }
                linkInfo.classDoc = type.asClassDoc();
                linkOutput = this.getClassLink(linkInfo);
                if (linkInfo.includeTypeAsSepLink) {
                    linkOutput.append(this.getTypeParameterLinks(linkInfo, false));
                }
            }
            if (linkInfo.isVarArg) {
                if (type.dimension().length() > 2) {
                    linkInfo.displayLength += type.dimension().length() - 2;
                    linkOutput.append(type.dimension().substring(2));
                }
                linkInfo.displayLength += 3;
                linkOutput.append("...");
            } else {
                linkInfo.displayLength += type.dimension().length();
                linkOutput.append(type.dimension());
            }
            return linkOutput;
        }
        if (linkInfo.classDoc != null) {
            LinkOutput linkOutput = this.getClassLink(linkInfo);
            if (linkInfo.includeTypeAsSepLink) {
                linkOutput.append(this.getTypeParameterLinks(linkInfo, false));
            }
            return linkOutput;
        }
        return null;
    }

    private void setBoundsLinkInfo(LinkInfo linkInfo, Type type) {
        linkInfo.classDoc = null;
        linkInfo.label = null;
        linkInfo.type = type;
    }

    protected abstract LinkOutput getClassLink(LinkInfo var1);

    protected abstract LinkOutput getTypeParameterLink(LinkInfo var1, Type var2);

    public LinkOutput getTypeParameterLinks(LinkInfo linkInfo) {
        return this.getTypeParameterLinks(linkInfo, true);
    }

    public LinkOutput getTypeParameterLinks(LinkInfo linkInfo, boolean bl) {
        Type[] typeArray;
        LinkOutput linkOutput = this.getOutputInstance();
        if (linkInfo.executableMemberDoc != null) {
            typeArray = linkInfo.executableMemberDoc.typeParameters();
        } else if (linkInfo.type != null && linkInfo.type.asParameterizedType() != null) {
            typeArray = linkInfo.type.asParameterizedType().typeArguments();
        } else if (linkInfo.classDoc != null) {
            typeArray = linkInfo.classDoc.typeParameters();
        } else {
            return linkOutput;
        }
        if ((linkInfo.includeTypeInClassLinkLabel && bl || linkInfo.includeTypeAsSepLink && !bl) && typeArray.length > 0) {
            ++linkInfo.displayLength;
            linkOutput.append(this.getLessThanString());
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    ++linkInfo.displayLength;
                    linkOutput.append(",");
                }
                linkOutput.append(this.getTypeParameterLink(linkInfo, typeArray[i]));
            }
            ++linkInfo.displayLength;
            linkOutput.append(this.getGreaterThanString());
        }
        return linkOutput;
    }

    protected String getLessThanString() {
        return "&lt;";
    }

    protected String getGreaterThanString() {
        return "&gt;";
    }
}

