/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.File;

public class DirectoryManager {
    public static final String URL_FILE_SEPERATOR = "/";

    private DirectoryManager() {
    }

    public static String createPathString(PackageDoc packageDoc) {
        if (packageDoc == null) {
            return "";
        }
        return DirectoryManager.getPath(packageDoc.name());
    }

    public static String createPathString(ClassDoc classDoc) {
        if (classDoc == null) {
            return "";
        }
        PackageDoc packageDoc = classDoc.containingPackage();
        return packageDoc == null ? "" : DirectoryManager.getPath(packageDoc.name());
    }

    public static String getDirectoryPath(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "" : DirectoryManager.getDirectoryPath(packageDoc.name());
    }

    public static String getDirectoryPath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                stringBuffer.append(URL_FILE_SEPERATOR);
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0 && !stringBuffer.toString().endsWith(URL_FILE_SEPERATOR)) {
            stringBuffer.append(URL_FILE_SEPERATOR);
        }
        return stringBuffer.toString();
    }

    public static String getPath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                stringBuffer.append(URL_FILE_SEPERATOR);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getRelativePath(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DirectoryManager.getRelativePath(string));
        stringBuffer.append(DirectoryManager.getPath(string2));
        stringBuffer.append(URL_FILE_SEPERATOR);
        return stringBuffer.toString();
    }

    public static String getRelativePath(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "" : DirectoryManager.getRelativePath(packageDoc.name());
    }

    public static String getRelativePath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '.') continue;
            stringBuffer.append("../");
        }
        stringBuffer.append("../");
        return stringBuffer.toString();
    }

    public static String getPathNoTrailingSlash(String string) {
        if (string.equals("")) {
            return ".";
        }
        if (string.equals(URL_FILE_SEPERATOR)) {
            return "/.";
        }
        if (string.endsWith(URL_FILE_SEPERATOR)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void createDirectory(Configuration configuration, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            return;
        }
        if (file.mkdirs()) {
            return;
        }
        configuration.message.error("doclet.Unable_to_create_directory_0", string);
        throw new DocletAbortException();
    }

    public static String getPathToPackage(PackageDoc packageDoc, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = DirectoryManager.createPathString(packageDoc);
        if (string2.length() > 0) {
            stringBuffer.append(string2);
            stringBuffer.append(URL_FILE_SEPERATOR);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String getPathToClass(ClassDoc classDoc) {
        return DirectoryManager.getPathToPackage(classDoc.containingPackage(), classDoc.name() + ".html");
    }
}

