/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.AbstractExecutableMemberWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.formats.html.TagletOutputImpl;
import com.sun.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.MethodWriter;
import com.sun.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.sun.tools.doclets.internal.toolkit.util.ImplementedMethods;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;

public class MethodWriterImpl
extends AbstractExecutableMemberWriter
implements MethodWriter,
MemberSummaryWriter {
    private boolean printedSummaryHeader = false;

    public MethodWriterImpl(SubWriterHolderWriter subWriterHolderWriter, ClassDoc classDoc) {
        super(subWriterHolderWriter, classDoc);
    }

    public MethodWriterImpl(SubWriterHolderWriter subWriterHolderWriter) {
        super(subWriterHolderWriter);
    }

    public void writeMemberSummaryHeader(ClassDoc classDoc) {
        this.printedSummaryHeader = true;
        this.writer.println();
        this.writer.println("<!-- ========== METHOD SUMMARY =========== -->");
        this.writer.println();
        this.writer.printSummaryHeader(this, classDoc);
    }

    public void writeMemberSummaryFooter(ClassDoc classDoc) {
        this.writer.printSummaryFooter(this, classDoc);
    }

    public void writeInheritedMemberSummaryHeader(ClassDoc classDoc) {
        if (!this.printedSummaryHeader) {
            this.writeMemberSummaryHeader(classDoc);
            this.writeMemberSummaryFooter(classDoc);
            this.printedSummaryHeader = true;
        }
        this.writer.printInheritedSummaryHeader(this, classDoc);
    }

    public void writeInheritedMemberSummary(ClassDoc classDoc, ProgramElementDoc programElementDoc, boolean bl, boolean bl2) {
        this.writer.printInheritedSummaryMember(this, classDoc, programElementDoc, bl);
    }

    public void writeInheritedMemberSummaryFooter(ClassDoc classDoc) {
        this.writer.printInheritedSummaryFooter(this, classDoc);
    }

    public void writeHeader(ClassDoc classDoc, String string) {
        this.writer.println();
        this.writer.println("<!-- ============ METHOD DETAIL ========== -->");
        this.writer.println();
        this.writer.anchor("method_detail");
        this.writer.printTableHeadingBackground(string);
    }

    public void writeMethodHeader(MethodDoc methodDoc, boolean bl) {
        if (!bl) {
            this.writer.printMemberHeader();
        }
        this.writer.println();
        String string = this.getErasureAnchor(methodDoc);
        if (string != null) {
            this.writer.anchor(string);
        }
        this.writer.anchor(methodDoc);
        this.writer.h3();
        this.writer.print(methodDoc.name());
        this.writer.h3End();
    }

    public void writeSignature(MethodDoc methodDoc) {
        this.writer.displayLength = 0;
        this.writer.pre();
        this.writer.writeAnnotationInfo(methodDoc);
        this.printModifiers(methodDoc);
        this.writeTypeParameters(methodDoc);
        this.printReturnType(methodDoc);
        if (this.configuration().linksource) {
            this.writer.printSrcLink(methodDoc, methodDoc.name());
        } else {
            this.bold(methodDoc.name());
        }
        this.writeParameters(methodDoc);
        this.writeExceptions(methodDoc);
        this.writer.preEnd();
        this.writer.dl();
    }

    public void writeDeprecated(MethodDoc methodDoc) {
        String string = ((TagletOutputImpl)new DeprecatedTaglet().getTagletOutput(methodDoc, this.writer.getTagletWriterInstance(false))).toString();
        if (string != null && string.trim().length() > 0) {
            this.writer.print(string);
        }
    }

    public void writeComments(Type type, MethodDoc methodDoc) {
        ClassDoc classDoc = type.asClassDoc();
        if (methodDoc.inlineTags().length > 0) {
            if (type.asClassDoc().equals(this.classdoc) || !classDoc.isPublic() && !Util.isLinkable(classDoc, this.configuration())) {
                this.writer.dd();
                this.writer.printInlineComment(methodDoc);
            } else {
                String string = this.writer.codeText(this.writer.getDocLink(26, type.asClassDoc(), methodDoc, type.asClassDoc().isIncluded() ? type.typeName() : type.qualifiedTypeName(), false));
                this.writer.dd();
                this.writer.boldText(type.asClassDoc().isClass() ? "doclet.Description_From_Class" : "doclet.Description_From_Interface", string);
                this.writer.ddEnd();
                this.writer.dd();
                this.writer.printInlineComment(methodDoc);
            }
        }
    }

    public void writeTags(MethodDoc methodDoc) {
        this.writer.printTags(methodDoc);
    }

    public void writeMethodFooter() {
        this.writer.ddEnd();
        this.writer.dlEnd();
    }

    public void writeFooter(ClassDoc classDoc) {
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public int getMemberKind() {
        return 4;
    }

    public void printSummaryLabel(ClassDoc classDoc) {
        this.writer.boldText("doclet.Method_Summary");
    }

    public void printSummaryAnchor(ClassDoc classDoc) {
        this.writer.anchor("method_summary");
    }

    public void printInheritedSummaryAnchor(ClassDoc classDoc) {
        this.writer.anchor("methods_inherited_from_class_" + ConfigurationImpl.getInstance().getClassName(classDoc));
    }

    public void printInheritedSummaryLabel(ClassDoc classDoc) {
        String string = this.writer.getPreQualifiedClassLink(3, classDoc, false);
        this.writer.bold();
        String string2 = classDoc.isClass() ? "doclet.Methods_Inherited_From_Class" : "doclet.Methods_Inherited_From_Interface";
        this.writer.printText(string2, string);
        this.writer.boldEnd();
    }

    protected void printSummaryType(ProgramElementDoc programElementDoc) {
        MethodDoc methodDoc = (MethodDoc)programElementDoc;
        this.printModifierAndType(methodDoc, methodDoc.returnType());
    }

    protected static void printOverridden(HtmlDocletWriter htmlDocletWriter, Type type, MethodDoc methodDoc) {
        if (htmlDocletWriter.configuration.nocomment) {
            return;
        }
        ClassDoc classDoc = type.asClassDoc();
        if (!classDoc.isPublic() && !Util.isLinkable(classDoc, htmlDocletWriter.configuration())) {
            return;
        }
        if (type.asClassDoc().isIncluded() && !methodDoc.isIncluded()) {
            return;
        }
        String string = "doclet.Overrides";
        int n = 28;
        if (methodDoc != null) {
            if (type.asClassDoc().isAbstract() && methodDoc.isAbstract()) {
                string = "doclet.Specified_By";
                n = 27;
            }
            String string2 = htmlDocletWriter.codeText(htmlDocletWriter.getLink(new LinkInfoImpl(n, type)));
            String string3 = methodDoc.name();
            htmlDocletWriter.dt();
            htmlDocletWriter.boldText(string);
            htmlDocletWriter.dd();
            String string4 = htmlDocletWriter.codeText(htmlDocletWriter.getLink(new LinkInfoImpl(3, type.asClassDoc(), htmlDocletWriter.getAnchor(methodDoc), string3, false)));
            htmlDocletWriter.printText("doclet.in_class", string4, string2);
        }
    }

    protected String parseCodeTag(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.toLowerCase();
        int n = string2.indexOf("<code>");
        int n2 = string2.indexOf("</code>");
        if (n == -1 || n2 == -1 || n2 <= n) {
            return string;
        }
        return string.substring(n + 6, n2);
    }

    protected static void printImplementsInfo(HtmlDocletWriter htmlDocletWriter, MethodDoc methodDoc) {
        if (htmlDocletWriter.configuration.nocomment) {
            return;
        }
        ImplementedMethods implementedMethods = new ImplementedMethods(methodDoc, htmlDocletWriter.configuration);
        MethodDoc[] methodDocArray = implementedMethods.build();
        for (int i = 0; i < methodDocArray.length; ++i) {
            MethodDoc methodDoc2 = methodDocArray[i];
            Type type = implementedMethods.getMethodHolder(methodDoc2);
            String string = "";
            String string2 = htmlDocletWriter.codeText(htmlDocletWriter.getLink(new LinkInfoImpl(27, type)));
            htmlDocletWriter.dt();
            htmlDocletWriter.boldText("doclet.Specified_By");
            htmlDocletWriter.dd();
            string = htmlDocletWriter.codeText(htmlDocletWriter.getDocLink(3, methodDoc2, methodDoc2.name(), false));
            htmlDocletWriter.printText("doclet.in_interface", string, string2);
        }
    }

    protected void printReturnType(MethodDoc methodDoc) {
        Type type = methodDoc.returnType();
        if (type != null) {
            this.writer.printLink(new LinkInfoImpl(16, type));
            this.print(' ');
        }
    }

    protected void printNavSummaryLink(ClassDoc classDoc, boolean bl) {
        if (bl) {
            this.writer.printHyperLink("", classDoc == null ? "method_summary" : "methods_inherited_from_class_" + ConfigurationImpl.getInstance().getClassName(classDoc), ConfigurationImpl.getInstance().getText("doclet.navMethod"));
        } else {
            this.writer.printText("doclet.navMethod");
        }
    }

    protected void printNavDetailLink(boolean bl) {
        if (bl) {
            this.writer.printHyperLink("", "method_detail", ConfigurationImpl.getInstance().getText("doclet.navMethod"));
        } else {
            this.writer.printText("doclet.navMethod");
        }
    }
}

