/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.IcoEncoder;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandlerFactory;
import com.sun.javaws.Main;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.jnl.AssociationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.javaws.ui.DesktopIntegration;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public abstract class LocalInstallHandler {
    private static LocalInstallHandler _installHandler;

    public static synchronized LocalInstallHandler getInstance() {
        if (_installHandler == null) {
            _installHandler = LocalInstallHandlerFactory.newInstance();
        }
        return _installHandler;
    }

    public abstract void install(LaunchDesc var1, LocalApplicationProperties var2);

    public abstract void uninstall(LaunchDesc var1, LocalApplicationProperties var2, boolean var3);

    public abstract boolean isLocalInstallSupported();

    public abstract boolean isAssociationSupported();

    public abstract void associationCompleted();

    public abstract String getAssociationOpenCommand(String var1);

    public abstract String getAssociationPrintCommand(String var1);

    public abstract void registerAssociationInternal(Association var1) throws AssociationAlreadyRegisteredException, RegisterFailedException;

    public abstract void unregisterAssociationInternal(Association var1) throws AssociationNotRegisteredException, RegisterFailedException;

    public abstract String getDefaultIconPath();

    private String getJnlpLocation(LaunchDesc launchDesc) {
        File file = null;
        try {
            file = Cache.getCachedLaunchedFile(launchDesc.getCanonicalHome());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = file != null ? file.getAbsolutePath() : launchDesc.getLocation().toString();
        return string;
    }

    private boolean promptUserAssociation(LaunchDesc launchDesc, Association association, boolean bl, String string, boolean bl2, Frame frame) {
        if (bl2) {
            return true;
        }
        String string2 = "";
        String string3 = association.getMimeType();
        ArrayList arrayList = (ArrayList)association.getFileExtList();
        String string4 = "";
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                string4 = string4 + iterator.next();
                if (!iterator.hasNext()) continue;
                string4 = string4 + ", ";
            }
        }
        if (bl) {
            string2 = ResourceManager.getString((String)"javaws.association.dialog.existAsk") + "\n\n";
            if (string4 != "") {
                string2 = string2 + ResourceManager.getString((String)"javaws.association.dialog.ext", (String)string4) + "\n";
            }
            if (string3 != null) {
                string2 = string2 + ResourceManager.getString((String)"javaws.association.dialog.mime", (String)string3) + "\n";
            }
            string2 = string == null ? string2 + "\n" + ResourceManager.getString((String)"javaws.association.dialog.exist") : string2 + "\n" + ResourceManager.getString((String)"javaws.association.dialog.exist.command", (String)string);
            string2 = string2 + "\n" + ResourceManager.getString((String)"javaws.association.dialog.askReplace", (String)launchDesc.getInformation().getTitle());
        } else {
            string2 = ResourceManager.getString((String)"javaws.association.dialog.ask", (String)launchDesc.getInformation().getTitle()) + "\n";
            if (string4 != "") {
                string2 = string2 + ResourceManager.getString((String)"javaws.association.dialog.ext", (String)string4) + "\n";
            }
            if (string3 != null) {
                string2 = string2 + ResourceManager.getString((String)"javaws.association.dialog.mime", (String)string3) + "\n";
            }
        }
        int n = 1;
        if (!bl2) {
            n = DialogFactory.showConfirmDialog((Component)frame, (Object)string2, (String)ResourceManager.getString((String)"javaws.association.dialog.title"));
        }
        return n == 0;
    }

    private String getOpenActionCommand(Association association) {
        Action action = association.getActionByVerb("open");
        String string = null;
        if (action != null) {
            string = action.getCommand();
        }
        return string;
    }

    private boolean registerAssociation(LaunchDesc launchDesc, String string, String string2, boolean bl, Frame frame) {
        String string3;
        Object object;
        AssociationService associationService = new AssociationService();
        Association association = new Association();
        boolean bl2 = false;
        Association association2 = null;
        String string4 = "";
        String string5 = null;
        if (string != null) {
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = "." + ((StringTokenizer)object).nextToken();
                Trace.println((String)("associate with ext: " + string3), (TraceLevel)TraceLevel.BASIC);
                if (string4 == "") {
                    string4 = string3 + " file";
                }
                if ((association2 = associationService.getFileExtensionAssociation(string3)) != null) {
                    Trace.println((String)("associate with ext: " + string3 + " already EXIST"), (TraceLevel)TraceLevel.BASIC);
                    if (string5 == null) {
                        string5 = this.getOpenActionCommand(association2);
                    }
                    bl2 = true;
                }
                association.addFileExtension(string3);
            }
        }
        if (string2 != null) {
            Trace.println((String)("associate with mime: " + string2), (TraceLevel)TraceLevel.BASIC);
            association2 = associationService.getMimeTypeAssociation(string2);
            if (association2 != null) {
                Trace.println((String)("associate with mime: " + string2 + " already EXIST"), (TraceLevel)TraceLevel.BASIC);
                if (string5 == null) {
                    string5 = this.getOpenActionCommand(association2);
                }
                bl2 = true;
            }
            association.setMimeType(string2);
        }
        association.setName(launchDesc.getInformation().getTitle());
        association.setDescription(string4);
        object = IcoEncoder.getIconPath(launchDesc);
        if (object == null) {
            object = this.getDefaultIconPath();
        }
        association.setIconFileName((String)object);
        String string6 = this.getJnlpLocation(launchDesc);
        String string7 = this.getAssociationOpenCommand(string6);
        String string8 = this.getAssociationPrintCommand(string6);
        Trace.println((String)("register OPEN using: " + string7), (TraceLevel)TraceLevel.BASIC);
        string3 = new Action("open", string7, "open the file");
        association.addAction((Action)string3);
        if (string8 != null) {
            Trace.println((String)("register PRINT using: " + string8), (TraceLevel)TraceLevel.BASIC);
            string3 = new Action("print", string8, "print the file");
            association.addAction((Action)string3);
        }
        try {
            if (!Globals.createAssoc()) {
                switch (Config.getAssociationValue()) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (!bl2) break;
                        return false;
                    }
                    case 2: {
                        if (this.promptUserAssociation(launchDesc, association, bl2, string5, bl, frame)) break;
                        return false;
                    }
                    case 3: {
                        if (!bl2 || this.promptUserAssociation(launchDesc, association, bl2, string5, bl, frame)) break;
                        return false;
                    }
                    default: {
                        if (this.promptUserAssociation(launchDesc, association, bl2, string5, bl, frame)) break;
                        return false;
                    }
                }
            }
            this.registerAssociationInternal(association);
        }
        catch (AssociationAlreadyRegisteredException associationAlreadyRegisteredException) {
            try {
                this.unregisterAssociationInternal(association);
                this.registerAssociationInternal(association);
            }
            catch (AssociationNotRegisteredException associationNotRegisteredException) {
                Trace.ignoredException((Exception)((Object)associationNotRegisteredException));
                return false;
            }
            catch (AssociationAlreadyRegisteredException associationAlreadyRegisteredException2) {
                Trace.ignoredException((Exception)((Object)associationAlreadyRegisteredException2));
                return false;
            }
            catch (RegisterFailedException registerFailedException) {
                Trace.ignoredException((Exception)((Object)registerFailedException));
                return false;
            }
        }
        catch (RegisterFailedException registerFailedException) {
            Trace.ignoredException((Exception)((Object)registerFailedException));
            return false;
        }
        return true;
    }

    private void unregisterAssociation(LaunchDesc launchDesc, String string, String string2) {
        AssociationService associationService = new AssociationService();
        Association association = null;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = "." + stringTokenizer.nextToken();
                association = associationService.getFileExtensionAssociation(string3);
                if (association == null) continue;
                association.setName(launchDesc.getInformation().getTitle());
                Trace.println((String)("remove association with ext: " + string3), (TraceLevel)TraceLevel.BASIC);
                try {
                    this.unregisterAssociationInternal(association);
                }
                catch (AssociationNotRegisteredException associationNotRegisteredException) {
                    Trace.ignoredException((Exception)((Object)associationNotRegisteredException));
                }
                catch (RegisterFailedException registerFailedException) {
                    Trace.ignoredException((Exception)((Object)registerFailedException));
                }
            }
        }
        if (string != null && (association = associationService.getMimeTypeAssociation(string)) != null) {
            association.setName(launchDesc.getInformation().getTitle());
            Trace.println((String)("remove association with mime: " + string), (TraceLevel)TraceLevel.BASIC);
            try {
                this.unregisterAssociationInternal(association);
            }
            catch (AssociationNotRegisteredException associationNotRegisteredException) {
                Trace.ignoredException((Exception)((Object)associationNotRegisteredException));
            }
            catch (RegisterFailedException registerFailedException) {
                Trace.ignoredException((Exception)((Object)registerFailedException));
            }
        }
    }

    public void removeAssociations(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        AssociationDesc[] associationDescArray;
        if (this.isAssociationSupported() && (associationDescArray = localApplicationProperties.getAssociations()) != null) {
            for (int i = 0; i < associationDescArray.length; ++i) {
                String string = associationDescArray[i].getExtensions();
                String string2 = associationDescArray[i].getMimeType();
                this.unregisterAssociation(launchDesc, string2, string);
            }
            localApplicationProperties.setAssociations(null);
            this.associationCompleted();
        }
    }

    public void createAssociations(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, Frame frame) {
        if (Config.getAssociationValue() == 0) {
            return;
        }
        if (this.isAssociationSupported()) {
            AssociationDesc[] associationDescArray = launchDesc.getInformation().getAssociations();
            for (int i = 0; i < associationDescArray.length; ++i) {
                String string;
                String string2 = associationDescArray[i].getExtensions();
                if (!this.registerAssociation(launchDesc, string2, string = associationDescArray[i].getMimeType(), bl, frame)) continue;
                localApplicationProperties.addAssociation(associationDescArray[i]);
                LocalInstallHandler.save(localApplicationProperties);
            }
            this.associationCompleted();
        }
    }

    public void installFromLaunch(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, Frame frame) {
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        if (shortcutDesc != null && !shortcutDesc.getDesktop() && !shortcutDesc.getMenu()) {
            return;
        }
        if (bl && Globals.createShortcut()) {
            this.doInstall(launchDesc, localApplicationProperties);
            return;
        }
        switch (Config.getShortcutValue()) {
            case 0: {
                return;
            }
            case 1: {
                this.doInstall(launchDesc, localApplicationProperties);
                return;
            }
            case 4: {
                if (shortcutDesc != null) {
                    this.doInstall(launchDesc, localApplicationProperties);
                }
                return;
            }
            case 3: {
                if (shortcutDesc != null) break;
                return;
            }
        }
        if (localApplicationProperties.getAskedForInstall()) {
            return;
        }
        if (bl) {
            return;
        }
        this.showDialog(launchDesc, localApplicationProperties, frame);
    }

    private void showDialog(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Frame frame) {
        int n = DesktopIntegration.showDTIDialog(frame, launchDesc);
        switch (n) {
            case 1: {
                this.doInstall(launchDesc, localApplicationProperties);
                break;
            }
            case 0: {
                localApplicationProperties.setAskedForInstall(true);
                break;
            }
            default: {
                localApplicationProperties.setAskedForInstall(false);
            }
        }
    }

    public void doInstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        this.install(launchDesc, localApplicationProperties);
        localApplicationProperties.setAskedForInstall(true);
        RContentDesc[] rContentDescArray = launchDesc.getInformation().getRelatedContent();
        if (rContentDescArray != null) {
            for (int i = 0; i < rContentDescArray.length; ++i) {
                URL uRL = rContentDescArray[i].getHref();
                if ("jar".equals(uRL.getProtocol()) || !uRL.toString().endsWith(".jnlp")) continue;
                try {
                    Main.importApp(uRL.toString());
                    continue;
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
        }
    }

    public static boolean shouldInstallOverExisting(final LaunchDesc launchDesc) {
        final int[] nArray = new int[]{1};
        Runnable runnable = new Runnable(){

            public void run() {
                nArray[0] = DialogFactory.showConfirmDialog((Object)ResourceManager.getString((String)"install.alreadyInstalled", (String)launchDesc.getInformation().getTitle()), (String)ResourceManager.getString((String)"install.alreadyInstalledTitle"));
            }
        };
        if (!Globals.isSilentMode()) {
            LocalInstallHandler.invokeRunnable(runnable);
        }
        return nArray[0] == 0;
    }

    public static void invokeRunnable(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void save(LocalApplicationProperties localApplicationProperties) {
        try {
            localApplicationProperties.store();
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
    }

    public boolean addUninstallShortcut() {
        return Config.getBooleanProperty((String)"deployment.javaws.uninstall.shortcut") && !Globals.isSystemCache();
    }
}

