/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.JsseJce;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.net.ssl.SSLException;

final class RSACipher {
    private final Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");

    RSACipher() throws NoSuchAlgorithmException {
    }

    void encryptInit(PublicKey publicKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.cipher.init(1, (Key)publicKey, secureRandom);
    }

    void decryptInit(PrivateKey privateKey) throws InvalidKeyException {
        this.cipher.init(2, privateKey);
    }

    byte[] doEncrypt(byte[] byArray, int n, int n2) throws SSLException {
        try {
            byte[] byArray2 = this.cipher.doFinal(byArray, n, n2);
            return byArray2;
        }
        catch (Exception exception) {
            throw new SSLException(exception.toString());
        }
    }

    byte[] doDecrypt(byte[] byArray, int n, int n2) throws SSLException {
        try {
            byte[] byArray2 = this.cipher.doFinal(byArray, n, n2);
            return byArray2;
        }
        catch (Exception exception) {
            throw new SSLException(exception.toString());
        }
    }

    static RSACipher getInstance() throws NoSuchAlgorithmException {
        return new RSACipher();
    }
}

