/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Vector;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import sun.awt.windows.WPrinterJob;
import sun.print.ImagePrinter;
import sun.print.PrintJobAttributeException;
import sun.print.PrintJobFlavorException;
import sun.print.Win32PrintService;

public class Win32PrintJob
implements CancelablePrintJob {
    private transient Vector jobListeners;
    private transient Vector attrListeners;
    private transient Vector listenedAttributeSets;
    private Win32PrintService service;
    private boolean fidelity;
    private boolean printing = false;
    private boolean printReturned = false;
    private PrintRequestAttributeSet reqAttrSet = null;
    private PrintJobAttributeSet jobAttrSet = null;
    private PrinterJob job;
    private Doc doc;
    private String mDestination = null;
    private InputStream instream = null;
    private Reader reader = null;
    private String jobName = "Java Printing";
    private int copies = 0;
    private MediaSizeName mediaName = null;
    private MediaSize mediaSize = null;
    private OrientationRequested orient = null;
    private long hPrintJob;
    private static final int PRINTBUFFERLEN = 8192;

    Win32PrintJob(Win32PrintService win32PrintService) {
        this.service = win32PrintService;
    }

    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintJobAttributeSet getAttributes() {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet hashPrintJobAttributeSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(hashPrintJobAttributeSet);
            }
            return this.jobAttrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobListener(PrintJobListener printJobListener) {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (printJobListener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new Vector();
            }
            this.jobListeners.add(printJobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobListener(PrintJobListener printJobListener) {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (printJobListener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(printJobListener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataStreams() {
        if (this.doc == null) {
            return;
        }
        Object object = null;
        try {
            object = this.doc.getPrintData();
        }
        catch (IOException iOException) {
            return;
        }
        if (this.instream != null) {
            try {
                try {
                    this.instream.close();
                }
                catch (IOException iOException) {
                    Object var4_8 = null;
                    this.instream = null;
                }
                Object var4_7 = null;
                this.instream = null;
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                this.instream = null;
                throw throwable;
            }
        } else if (this.reader != null) {
            try {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    Object var6_12 = null;
                    this.reader = null;
                }
                Object var6_11 = null;
                this.reader = null;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                this.reader = null;
                throw throwable;
            }
        } else if (object instanceof InputStream) {
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
        } else if (object instanceof Reader) {
            try {
                ((Reader)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int n) {
        switch (n) {
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: {
                this.closeDataStreams();
            }
        }
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent printJobEvent = new PrintJobEvent(this, n);
                block13: for (int i = 0; i < this.jobListeners.size(); ++i) {
                    PrintJobListener printJobListener = (PrintJobListener)this.jobListeners.elementAt(i);
                    switch (n) {
                        case 102: {
                            printJobListener.printJobCompleted(printJobEvent);
                            continue block13;
                        }
                        case 101: {
                            printJobListener.printJobCanceled(printJobEvent);
                            continue block13;
                        }
                        case 103: {
                            printJobListener.printJobFailed(printJobEvent);
                            continue block13;
                        }
                        case 106: {
                            printJobListener.printDataTransferCompleted(printJobEvent);
                            continue block13;
                        }
                        case 105: {
                            printJobListener.printJobNoMoreEvents(printJobEvent);
                            continue block13;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener, PrintJobAttributeSet printJobAttributeSet) {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (printJobAttributeListener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new Vector();
                this.listenedAttributeSets = new Vector();
            }
            this.attrListeners.add(printJobAttributeListener);
            if (printJobAttributeSet == null) {
                printJobAttributeSet = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(printJobAttributeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener) {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (printJobAttributeListener == null || this.attrListeners == null) {
                return;
            }
            int n = this.attrListeners.indexOf(printJobAttributeListener);
            if (n == -1) {
                return;
            }
            this.attrListeners.remove(n);
            this.listenedAttributeSets.remove(n);
            if (this.attrListeners.isEmpty()) {
                this.attrListeners = null;
                this.listenedAttributeSets = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) throws PrintException {
        block43: {
            Object object;
            Object object2 = this;
            synchronized (object2) {
                if (this.printing) {
                    throw new PrintException("already printing");
                }
                this.printing = true;
            }
            if (this.service.getAttribute(PrinterIsAcceptingJobs.class) == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS) {
                throw new PrintException("Printer is not accepting job.");
            }
            this.doc = doc;
            object2 = doc.getDocFlavor();
            try {
                object = doc.getPrintData();
            }
            catch (IOException iOException) {
                this.notifyEvent(103);
                throw new PrintException("can't get print data: " + iOException.toString());
            }
            if (object2 == null || !this.service.isDocFlavorSupported((DocFlavor)object2)) {
                this.notifyEvent(103);
                throw new PrintJobFlavorException("invalid flavor", (DocFlavor)object2);
            }
            this.initializeAttributeSets(doc, printRequestAttributeSet);
            this.getAttributeValues((DocFlavor)object2);
            String string = ((DocFlavor)object2).getRepresentationClassName();
            if (((DocFlavor)object2).equals(DocFlavor.INPUT_STREAM.GIF) || ((DocFlavor)object2).equals(DocFlavor.INPUT_STREAM.JPEG) || ((DocFlavor)object2).equals(DocFlavor.INPUT_STREAM.PNG) || ((DocFlavor)object2).equals(DocFlavor.BYTE_ARRAY.GIF) || ((DocFlavor)object2).equals(DocFlavor.BYTE_ARRAY.JPEG) || ((DocFlavor)object2).equals(DocFlavor.BYTE_ARRAY.PNG)) {
                try {
                    this.instream = doc.getStreamForBytes();
                    if (this.instream == null) {
                        this.notifyEvent(103);
                        throw new PrintException("No stream for data");
                    }
                    this.printableJob(new ImagePrinter(this.instream));
                    this.service.wakeNotifier();
                    return;
                }
                catch (ClassCastException classCastException) {
                    this.notifyEvent(103);
                    throw new PrintException(classCastException);
                }
                catch (IOException iOException) {
                    this.notifyEvent(103);
                    throw new PrintException(iOException);
                }
            }
            if (object2 == DocFlavor.URL.GIF || object2 == DocFlavor.URL.JPEG || object2 == DocFlavor.URL.PNG) {
                try {
                    this.printableJob(new ImagePrinter((URL)object));
                    this.service.wakeNotifier();
                    return;
                }
                catch (ClassCastException classCastException) {
                    this.notifyEvent(103);
                    throw new PrintException(classCastException);
                }
            }
            if (string.equals("java.awt.print.Pageable")) {
                try {
                    this.pageableJob((Pageable)doc.getPrintData());
                    this.service.wakeNotifier();
                    return;
                }
                catch (ClassCastException classCastException) {
                    this.notifyEvent(103);
                    throw new PrintException(classCastException);
                }
                catch (IOException iOException) {
                    this.notifyEvent(103);
                    throw new PrintException(iOException);
                }
            }
            if (string.equals("java.awt.print.Printable")) {
                try {
                    this.printableJob((Printable)doc.getPrintData());
                    this.service.wakeNotifier();
                    return;
                }
                catch (ClassCastException classCastException) {
                    this.notifyEvent(103);
                    throw new PrintException(classCastException);
                }
                catch (IOException iOException) {
                    this.notifyEvent(103);
                    throw new PrintException(iOException);
                }
            }
            if (string.equals("[B") || string.equals("java.io.InputStream") || string.equals("java.net.URL")) {
                Object object3;
                if (string.equals("java.net.URL")) {
                    object3 = (URL)object;
                    try {
                        this.instream = ((URL)object3).openStream();
                    }
                    catch (IOException iOException) {
                        this.notifyEvent(103);
                        throw new PrintException(iOException.toString());
                    }
                }
                try {
                    this.instream = doc.getStreamForBytes();
                }
                catch (IOException iOException) {
                    this.notifyEvent(103);
                    throw new PrintException(iOException.toString());
                }
                if (this.instream == null) {
                    this.notifyEvent(103);
                    throw new PrintException("No stream for data");
                }
                if (this.mDestination != null) {
                    try {
                        int n;
                        object3 = new FileOutputStream(this.mDestination);
                        byte[] byArray = new byte[1024];
                        while ((n = this.instream.read(byArray, 0, byArray.length)) >= 0) {
                            ((FileOutputStream)object3).write(byArray, 0, n);
                        }
                        ((OutputStream)object3).flush();
                        ((FileOutputStream)object3).close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.notifyEvent(103);
                        throw new PrintException(fileNotFoundException.toString());
                    }
                    catch (IOException iOException) {
                        this.notifyEvent(103);
                        throw new PrintException(iOException.toString());
                    }
                    this.notifyEvent(106);
                    this.notifyEvent(102);
                    this.service.wakeNotifier();
                    return;
                }
                if (!this.startPrintRawData(this.service.getName())) {
                    this.notifyEvent(103);
                    throw new PrintException("Print job failed to start.");
                }
                object3 = new BufferedInputStream(this.instream);
                int n = 0;
                try {
                    try {
                        byte[] byArray = new byte[8192];
                        while ((n = ((BufferedInputStream)object3).read(byArray, 0, 8192)) >= 0) {
                            if (this.printRawData(byArray, n)) continue;
                            ((BufferedInputStream)object3).close();
                            this.notifyEvent(103);
                            throw new PrintException("Problem while spooling data");
                        }
                        ((BufferedInputStream)object3).close();
                        if (!this.endPrintRawData()) {
                            this.notifyEvent(103);
                            throw new PrintException("Print job failed to close properly.");
                        }
                        this.notifyEvent(106);
                    }
                    catch (IOException iOException) {
                        this.notifyEvent(103);
                        throw new PrintException(iOException.toString());
                    }
                    Object var10_25 = null;
                    this.notifyEvent(105);
                    break block43;
                }
                catch (Throwable throwable) {
                    Object var10_26 = null;
                    this.notifyEvent(105);
                    throw throwable;
                }
            }
            this.notifyEvent(103);
            throw new PrintException("unrecognized class: " + string);
        }
        this.service.wakeNotifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printableJob(Printable printable) throws PrintException {
        try {
            try {
                Object object;
                Object object2 = this;
                synchronized (object2) {
                    if (this.job != null) {
                        throw new PrintException("already printing");
                    }
                    this.job = new WPrinterJob();
                }
                object2 = this.getPrintService();
                this.job.setPrintService((PrintService)object2);
                if (this.copies == 0) {
                    object = (Copies)object2.getDefaultAttributeValue(Copies.class);
                    this.copies = ((IntegerSyntax)object).getValue();
                }
                if (this.mediaName == null && (object = object2.getDefaultAttributeValue(Media.class)) instanceof MediaSizeName) {
                    this.mediaName = (MediaSizeName)object;
                    this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                }
                if (this.orient == null) {
                    this.orient = (OrientationRequested)object2.getDefaultAttributeValue(OrientationRequested.class);
                }
                this.job.setCopies(this.copies);
                this.job.setJobName(this.jobName);
                object = new PageFormat();
                if (this.mediaSize != null) {
                    Paper paper = new Paper();
                    paper.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                    paper.setImageableArea(72.0, 72.0, paper.getWidth() - 144.0, paper.getHeight() - 144.0);
                    ((PageFormat)object).setPaper(paper);
                }
                if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                    ((PageFormat)object).setOrientation(2);
                } else if (this.orient == OrientationRequested.LANDSCAPE) {
                    ((PageFormat)object).setOrientation(0);
                }
                this.job.setPrintable(printable, (PageFormat)object);
                this.job.print(this.reqAttrSet);
                this.notifyEvent(106);
                Object var6_7 = null;
                this.printReturned = true;
                this.notifyEvent(105);
                return;
            }
            catch (PrinterException printerException) {
                this.notifyEvent(103);
                throw new PrintException(printerException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.printReturned = true;
            this.notifyEvent(105);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageableJob(Pageable pageable) throws PrintException {
        try {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.job != null) {
                        throw new PrintException("already printing");
                    }
                    this.job = new WPrinterJob();
                }
                object = this.getPrintService();
                this.job.setPrintService((PrintService)object);
                if (this.copies == 0) {
                    Copies copies = (Copies)object.getDefaultAttributeValue(Copies.class);
                    this.copies = copies.getValue();
                }
                this.job.setCopies(this.copies);
                this.job.setJobName(this.jobName);
                this.job.setPageable(pageable);
                this.job.print(this.reqAttrSet);
                this.notifyEvent(106);
                Object var5_6 = null;
                this.printReturned = true;
                this.notifyEvent(105);
                return;
            }
            catch (PrinterException printerException) {
                this.notifyEvent(103);
                throw new PrintException(printerException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.printReturned = true;
            this.notifyEvent(105);
            throw throwable;
        }
    }

    private synchronized void initializeAttributeSets(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) {
        TextSyntax textSyntax;
        DocAttributeSet docAttributeSet;
        Attribute[] attributeArray;
        this.reqAttrSet = new HashPrintRequestAttributeSet();
        this.jobAttrSet = new HashPrintJobAttributeSet();
        if (printRequestAttributeSet != null) {
            this.reqAttrSet.addAll(printRequestAttributeSet);
            attributeArray = printRequestAttributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (!(attributeArray[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attributeArray[i]);
            }
        }
        if ((docAttributeSet = doc.getAttributes()) != null) {
            attributeArray = docAttributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (attributeArray[i] instanceof PrintRequestAttribute) {
                    this.reqAttrSet.add(attributeArray[i]);
                }
                if (!(attributeArray[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attributeArray[i]);
            }
        }
        String string = "";
        try {
            string = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null || string.equals("")) {
            textSyntax = (RequestingUserName)printRequestAttributeSet.get(RequestingUserName.class);
            if (textSyntax != null) {
                this.jobAttrSet.add(new JobOriginatingUserName(textSyntax.getValue(), textSyntax.getLocale()));
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName("", null));
            }
        } else {
            this.jobAttrSet.add(new JobOriginatingUserName(string, null));
        }
        if (this.jobAttrSet.get(JobName.class) == null) {
            if (docAttributeSet != null && docAttributeSet.get(DocumentName.class) != null) {
                DocumentName documentName = (DocumentName)docAttributeSet.get(DocumentName.class);
                textSyntax = new JobName(documentName.getValue(), documentName.getLocale());
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            } else {
                String string2 = "JPS Job:" + doc;
                try {
                    Object object = doc.getPrintData();
                    if (object instanceof URL) {
                        string2 = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                textSyntax = new JobName(string2, null);
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    private void getAttributeValues(DocFlavor docFlavor) throws PrintException {
        this.fidelity = this.reqAttrSet.get(Fidelity.class) == Fidelity.FIDELITY_TRUE;
        Attribute[] attributeArray = this.reqAttrSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = attributeArray[i];
            Class<? extends Attribute> clazz = attribute.getCategory();
            if (this.fidelity) {
                if (!this.service.isAttributeCategorySupported(clazz)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported category: " + clazz, clazz, null);
                }
                if (!this.service.isAttributeValueSupported(attribute, docFlavor, null)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported attribute: " + attribute, null, attribute);
                }
            }
            if (clazz == Destination.class) {
                URI uRI = ((Destination)attribute).getURI();
                if (!"file".equals(uRI.getScheme())) {
                    this.notifyEvent(103);
                    throw new PrintException("Not a file: URI");
                }
                try {
                    this.mDestination = new File(uRI).getPath();
                }
                catch (Exception exception) {
                    throw new PrintException(exception);
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager == null) continue;
                try {
                    securityManager.checkWrite(this.mDestination);
                    continue;
                }
                catch (SecurityException securityException) {
                    this.notifyEvent(103);
                    throw new PrintException(securityException);
                }
            }
            if (clazz == JobName.class) {
                this.jobName = ((JobName)attribute).getValue();
                continue;
            }
            if (clazz == Copies.class) {
                this.copies = ((Copies)attribute).getValue();
                continue;
            }
            if (clazz == Media.class) {
                if (!(attribute instanceof MediaSizeName)) continue;
                this.mediaName = (MediaSizeName)attribute;
                if (this.service.isAttributeValueSupported(attribute, null, null)) continue;
                this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                continue;
            }
            if (clazz != OrientationRequested.class) continue;
            this.orient = (OrientationRequested)attribute;
        }
    }

    private native boolean startPrintRawData(String var1);

    private native boolean printRawData(byte[] var1, int var2);

    private native boolean endPrintRawData();

    public void cancel() throws PrintException {
        Win32PrintJob win32PrintJob = this;
        synchronized (win32PrintJob) {
            if (!this.printing) {
                throw new PrintException("Job is not yet submitted.");
            }
            if (this.job != null && !this.printReturned) {
                this.job.cancel();
                this.notifyEvent(101);
                return;
            }
            throw new PrintException("Job could not be cancelled.");
        }
    }
}

