/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import sun.awt.image.RemoteOffScreenImage;
import sun.awt.image.ToolkitImage;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontManager;
import sun.font.PhysicalFont;
import sun.print.ProxyGraphics2D;
import sun.print.RasterPrinterJob;

public abstract class PathGraphics
extends ProxyGraphics2D {
    private Printable mPainter;
    private PageFormat mPageFormat;
    private int mPageIndex;
    private boolean mCanRedraw;
    protected static SoftReference<Hashtable<Font2DHandle, Object>> fontMapRef = new SoftReference<Object>(null);

    protected PathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n, boolean bl) {
        super(graphics2D, printerJob);
        this.mPainter = printable;
        this.mPageFormat = pageFormat;
        this.mPageIndex = n;
        this.mCanRedraw = bl;
    }

    protected Printable getPrintable() {
        return this.mPainter;
    }

    protected PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    protected int getPageIndex() {
        return this.mPageIndex;
    }

    public boolean canDoRedraws() {
        return this.mCanRedraw;
    }

    public abstract void redrawRegion(Rectangle2D var1, double var2, double var4, Rectangle2D var6, AffineTransform var7) throws PrinterException;

    public void drawLine(int n, int n2, int n3, int n4) {
        Paint paint = this.getPaint();
        try {
            AffineTransform affineTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(affineTransform));
            }
            this.deviceDrawLine(n, n2, n3, n4, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        Paint paint = this.getPaint();
        try {
            AffineTransform affineTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(affineTransform));
            }
            this.deviceFrameRect(n, n2, n3, n4, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        Paint paint = this.getPaint();
        try {
            AffineTransform affineTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(affineTransform));
            }
            this.deviceFillRect(n, n2, n3, n4, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle2D.Float(n, n2, n3, n4), this.getBackground());
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            float f = nArray[0];
            float f2 = nArray2[0];
            for (int i = 1; i < n; ++i) {
                float f3 = nArray[i];
                float f4 = nArray2[i];
                this.draw(new Line2D.Float(f, f2, f3, f4));
                f = f3;
                f2 = f4;
            }
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    public void drawPolygon(Polygon polygon) {
        this.draw(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n));
    }

    public void fillPolygon(Polygon polygon) {
        this.fill(polygon);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        if (string.length() == 0) {
            return;
        }
        TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
        textLayout.draw(this, f, f2);
    }

    protected void drawString(String string, float f, float f2, Font font, FontRenderContext fontRenderContext, float f3) {
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
        this.fill(shape);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, f, f2);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        if (RasterPrinterJob.shapeTextProp || !this.printedSimpleGlyphVector(glyphVector, f, f2)) {
            this.fill(glyphVector.getOutline(f, f2));
        }
    }

    protected int platformFontCount(Font font, String string) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean printedSimpleGlyphVector(GlyphVector glyphVector, float f, float f2) {
        int n = glyphVector.getLayoutFlags();
        if (n != 0 && n != 2) {
            return false;
        }
        Font font = glyphVector.getFont();
        Font2D font2D = FontManager.getFont2D(font);
        if (font2D.handle.font2D != font2D) {
            return false;
        }
        Class<PathGraphics> clazz = PathGraphics.class;
        synchronized (PathGraphics.class) {
            boolean bl;
            int n2;
            int n3;
            Object[] objectArray;
            Object object;
            FontRenderContext fontRenderContext;
            GlyphVector glyphVector2;
            int n4;
            int n5;
            int n6;
            Hashtable<Font2DHandle, Object> hashtable = fontMapRef.get();
            if (hashtable == null) {
                hashtable = new Hashtable();
                fontMapRef = new SoftReference<Hashtable<Font2DHandle, Object>>(hashtable);
            }
            // ** MonitorExit[var8_7] (shouldn't be in output)
            int n7 = glyphVector.getNumGlyphs();
            int[] nArray = glyphVector.getGlyphCodes(0, n7, null);
            char[] cArray = null;
            Object object2 = null;
            CompositeFont compositeFont = null;
            Object object3 = hashtable;
            synchronized (object3) {
                if (font2D instanceof CompositeFont) {
                    compositeFont = (CompositeFont)font2D;
                    n6 = compositeFont.getNumSlots();
                    object2 = (char[][])hashtable.get(font2D.handle);
                    if (object2 == null) {
                        object2 = new char[n6][];
                        hashtable.put(font2D.handle, object2);
                    }
                    for (n5 = 0; n5 < n7; ++n5) {
                        n4 = nArray[n5] >>> 24;
                        if (n4 >= n6) {
                            return false;
                        }
                        if (object2[n4] != null) continue;
                        PhysicalFont physicalFont = compositeFont.getSlotFont(n4);
                        char[] cArray2 = (char[])hashtable.get(physicalFont.handle);
                        if (cArray2 == null) {
                            cArray2 = PathGraphics.getGlyphToCharMapForFont(physicalFont);
                        }
                        object2[n4] = cArray2;
                    }
                } else {
                    cArray = (char[])hashtable.get(font2D.handle);
                    if (cArray == null) {
                        cArray = PathGraphics.getGlyphToCharMapForFont(font2D);
                        hashtable.put(font2D.handle, cArray);
                    }
                }
            }
            object3 = new char[n7];
            if (compositeFont != null) {
                for (n6 = 0; n6 < n7; ++n6) {
                    n5 = nArray[n6];
                    char[] cArray3 = object2[n5 >>> 24];
                    n5 &= 0xFFFFFF;
                    if (cArray3 == null) {
                        return false;
                    }
                    if (n5 < 0 || n5 >= cArray3.length) {
                        return false;
                    }
                    char c = cArray3[n5];
                    if (c == '\uffff') {
                        return false;
                    }
                    object3[n6] = c;
                }
            } else {
                for (n6 = 0; n6 < n7; ++n6) {
                    n5 = nArray[n6];
                    if (n5 < 0 || n5 >= cArray.length) {
                        return false;
                    }
                    n4 = cArray[n5];
                    if (n4 == 65535) {
                        return false;
                    }
                    object3[n6] = n4;
                }
            }
            if ((glyphVector2 = font.createGlyphVector(fontRenderContext = glyphVector.getFontRenderContext(), (char[])object3)).getNumGlyphs() != n7) {
                return false;
            }
            int[] nArray2 = glyphVector2.getGlyphCodes(0, n7, null);
            for (int i = 0; i < n7; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                return false;
            }
            FontRenderContext fontRenderContext2 = this.getFontRenderContext();
            boolean bl2 = fontRenderContext.equals(fontRenderContext2);
            if (!bl2 && fontRenderContext.usesFractionalMetrics() == fontRenderContext2.usesFractionalMetrics()) {
                object = fontRenderContext.getTransform();
                AffineTransform affineTransform = this.getTransform();
                objectArray = new double[4];
                double[] dArray = new double[4];
                ((AffineTransform)object).getMatrix((double[])objectArray);
                affineTransform.getMatrix(dArray);
                bl2 = true;
                for (n3 = 0; n3 < 4; ++n3) {
                    if (objectArray[n3] == dArray[n3]) continue;
                    bl2 = false;
                    break;
                }
            }
            if ((n2 = this.platformFontCount(font, (String)(object = new String((char[])object3, 0, n7)))) == 0) {
                return false;
            }
            objectArray = glyphVector.getGlyphPositions(0, n7, null);
            boolean bl3 = bl = (n & 2) == 0 || this.samePositions(glyphVector2, nArray2, nArray, (float[])objectArray);
            if (bl2 && bl) {
                this.drawString((String)object, f, f2, font, fontRenderContext, 0.0f);
                return true;
            }
            if (n2 == 1 && this.canDrawStringToWidth() && bl) {
                Point2D point2D = glyphVector.getGlyphPosition(n7);
                this.drawString((String)object, f, f2, font, fontRenderContext, (float)point2D.getX());
                return true;
            }
            for (n3 = 0; n3 < ((Object)object3).length; ++n3) {
                if (object3[n3] < 1424 || object3[n3] > 4255) continue;
                return false;
            }
            for (n3 = 0; n3 < n7; ++n3) {
                String string = new String((char[])object3, n3, 1);
                this.drawString(string, f + objectArray[n3 * 2], f2 + objectArray[n3 * 2 + 1], font, fontRenderContext, 0.0f);
            }
            return true;
        }
    }

    private boolean samePositions(GlyphVector glyphVector, int[] nArray, int[] nArray2, float[] fArray) {
        int n = glyphVector.getNumGlyphs();
        float[] fArray2 = glyphVector.getGlyphPositions(0, n, null);
        if (n != nArray.length || nArray2.length != nArray.length || fArray.length != fArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i] && fArray2[i] == fArray[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean canDrawStringToWidth() {
        return false;
    }

    private static char[] getGlyphToCharMapForFont(Font2D font2D) {
        int n;
        int n2 = font2D.getNumGlyphs();
        int n3 = font2D.getMissingGlyphCode();
        char[] cArray = new char[n2];
        for (n = 0; n < n2; ++n) {
            cArray[n] = 65535;
        }
        for (n = 0; n < 65535; n = (int)((char)(n + 1))) {
            int n4;
            if (n >= 55296 && n <= 57343 || (n4 = font2D.charToGlyph(n)) == n3 || n4 >= n2 || cArray[n4] != '\uffff') continue;
            cArray[n4] = n;
        }
        return cArray;
    }

    public void draw(Shape shape) {
        this.fill(this.getStroke().createStrokedShape(shape));
    }

    public void fill(Shape shape) {
        Paint paint = this.getPaint();
        try {
            this.fill(shape, (Color)paint);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void fill(Shape shape, Color color) {
        AffineTransform affineTransform = this.getTransform();
        if (this.getClip() != null) {
            this.deviceClip(this.getClip().getPathIterator(affineTransform));
        }
        this.deviceFill(shape.getPathIterator(affineTransform), color);
    }

    protected abstract void deviceFill(PathIterator var1, Color var2);

    protected abstract void deviceClip(PathIterator var1);

    protected abstract void deviceFrameRect(int var1, int var2, int var3, int var4, Color var5);

    protected abstract void deviceDrawLine(int var1, int var2, int var3, int var4, Color var5);

    protected abstract void deviceFillRect(int var1, int var2, int var3, int var4, Color var5);

    protected BufferedImage getBufferedImage(Image image) {
        if (image instanceof RemoteOffScreenImage) {
            return ((RemoteOffScreenImage)image).getSnapshot();
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        if (image instanceof ToolkitImage) {
            return ((ToolkitImage)image).getBufferedImage();
        }
        if (image instanceof VolatileImage) {
            return ((VolatileImage)image).getSnapshot();
        }
        return null;
    }

    protected boolean hasTransparentPixels(BufferedImage bufferedImage) {
        boolean bl;
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl2 = colorModel == null ? true : (bl = colorModel.getTransparency() != 1);
        if (bl && bufferedImage != null && (bufferedImage.getType() == 2 || bufferedImage.getType() == 3)) {
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
            if (dataBuffer instanceof DataBufferInt && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n = bufferedImage.getMinX();
                int n2 = bufferedImage.getMinY();
                int n3 = bufferedImage.getWidth();
                int n4 = bufferedImage.getHeight();
                int n5 = singlePixelPackedSampleModel.getScanlineStride();
                boolean bl3 = false;
                for (int i = n2; i < n2 + n4; ++i) {
                    int n6 = n2 * n5;
                    for (int j = n; j < n + n3; ++j) {
                        if ((nArray[n6 + j] & 0xFF000000) == -16777216) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) break;
                }
                if (!bl3) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean isBitmaskTransparency(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        return colorModel != null && colorModel.getTransparency() == 2;
    }

    protected boolean drawBitmaskImage(BufferedImage bufferedImage, AffineTransform affineTransform, Color color, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        ColorModel colorModel = bufferedImage.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        if (colorModel.getTransparency() != 2) {
            return false;
        }
        if (color != null && color.getAlpha() < 128) {
            return false;
        }
        if ((affineTransform.getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        if ((this.getTransform().getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        BufferedImage bufferedImage2 = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n9 = indexColorModel.getTransparentPixel();
        byte[] byArray = new byte[indexColorModel.getMapSize()];
        indexColorModel.getAlphas(byArray);
        if (n9 >= 0) {
            byArray[n9] = 0;
        }
        int n10 = writableRaster.getWidth();
        int n11 = writableRaster.getHeight();
        if (n > n10 || n2 > n11) {
            return false;
        }
        if (n + n3 > n10) {
            n8 = n10;
            n7 = n8 - n;
        } else {
            n8 = n + n3;
            n7 = n3;
        }
        if (n2 + n4 > n11) {
            n6 = n11;
            n5 = n6 - n2;
        } else {
            n6 = n2 + n4;
            n5 = n4;
        }
        int[] nArray = new int[n7];
        for (int i = n2; i < n6; ++i) {
            int n12 = -1;
            writableRaster.getPixels(n, i, n7, 1, nArray);
            for (int j = n; j < n8; ++j) {
                if (byArray[nArray[j - n]] == 0) {
                    if (n12 < 0) continue;
                    bufferedImage2 = bufferedImage.getSubimage(n12, i, j - n12, 1);
                    affineTransform.translate(n12, i);
                    this.drawImageToPlatform(bufferedImage2, affineTransform, color, 0, 0, j - n12, 1, true);
                    affineTransform.translate(-n12, -i);
                    n12 = -1;
                    continue;
                }
                if (n12 >= 0) continue;
                n12 = j;
            }
            if (n12 < 0) continue;
            bufferedImage2 = bufferedImage.getSubimage(n12, i, n8 - n12, 1);
            affineTransform.translate(n12, i);
            this.drawImageToPlatform(bufferedImage2, affineTransform, color, 0, 0, n8 - n12, 1, true);
            affineTransform.translate(-n12, -i);
        }
        return true;
    }

    protected abstract boolean drawImageToPlatform(Image var1, AffineTransform var2, Color var3, int var4, int var5, int var6, int var7, boolean var8);

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        boolean bl = n3 < 0 || n4 < 0 ? false : this.drawImage(image, n, n2, n3, n4, color, imageObserver);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        boolean bl = n5 < 0 || n6 < 0 ? false : this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, n5, n6, imageObserver);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        float f = (float)(n3 - n) / (float)n9;
        float f2 = (float)(n4 - n2) / (float)n10;
        AffineTransform affineTransform = new AffineTransform(f, 0.0f, 0.0f, f2, (float)n - (float)n5 * f, (float)n2 - (float)n6 * f2);
        return this.drawImageToPlatform(image, affineTransform, color, n5, n6, n9, n10, false);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        boolean bl = n < 0 || n2 < 0 ? false : this.drawImageToPlatform(image, affineTransform, null, 0, 0, n, n2, false);
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (bufferedImage == null) {
            return;
        }
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        if (n3 < 0 || n4 < 0) {
            boolean bl = false;
        } else {
            AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2);
            boolean bl = this.drawImageToPlatform(bufferedImage, affineTransform, null, 0, 0, n3, n4, false);
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (renderedImage == null) {
            return;
        }
        BufferedImage bufferedImage = null;
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
        this.drawImageToPlatform(bufferedImage, affineTransform, null, 0, 0, n, n2, false);
    }
}

