/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import sun.awt.windows.WComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.opengl.WGLGraphicsConfig;

public abstract class WGLSurfaceData
extends OGLSurfaceData {
    protected WComponentPeer peer;
    private WGLGraphicsConfig graphicsConfig;

    private static native void initIDs(Class var0, Object var1);

    private native void initOps(WComponentPeer var1, WGLGraphicsConfig var2);

    protected native boolean initWindow(long var1, long var3, long var5, int var7, int var8);

    protected native boolean initPbuffer(long var1, long var3, int var5, int var6);

    protected WGLSurfaceData(WComponentPeer wComponentPeer, WGLGraphicsConfig wGLGraphicsConfig, SurfaceType surfaceType, ColorModel colorModel, int n) {
        super(surfaceType, colorModel, n);
        this.peer = wComponentPeer;
        this.graphicsConfig = wGLGraphicsConfig;
        this.solidloops = this.graphicsConfig.getSolidLoops(surfaceType);
        this.initOps(wComponentPeer, this.graphicsConfig);
    }

    public boolean initWindow() {
        int n;
        int n2;
        Component component = (Component)this.peer.getTarget();
        if (component instanceof Container) {
            Insets insets = ((Container)component).getInsets();
            if (this.type == 5) {
                n2 = 0;
                n = -insets.top;
            } else {
                n2 = -insets.left;
                n = -insets.bottom;
            }
        } else {
            n = 0;
            n2 = 0;
        }
        long l = this.peer.getData();
        long l2 = this.graphicsConfig.getNativeConfigInfo();
        if (this.initWindow(this.getNativeOps(), l, l2, n2, n)) {
            if (this.type == 0) {
                this.type = 1;
            }
            return true;
        }
        return false;
    }

    protected boolean initPixmap(long l, long l2, int n, int n2, int n3) {
        return false;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public OGLContext getContext() {
        return this.graphicsConfig.getContext();
    }

    public long getSharedContext() {
        WGLSurfaceData wGLSurfaceData = this;
        return wGLSurfaceData.graphicsConfig.getThreadSharedContext();
    }

    public boolean isBlendPremultAvailable() {
        return this.graphicsConfig.isBlendPremultAvailable();
    }

    public boolean isTexNonPow2Available() {
        return this.graphicsConfig.isTexNonPow2Available();
    }

    public static WGLWindowSurfaceData createData(WComponentPeer wComponentPeer) {
        WGLGraphicsConfig wGLGraphicsConfig = WGLSurfaceData.getGC(wComponentPeer);
        return new WGLWindowSurfaceData(wComponentPeer, wGLGraphicsConfig);
    }

    public static WGLOffScreenSurfaceData createData(WComponentPeer wComponentPeer, boolean bl) {
        WGLGraphicsConfig wGLGraphicsConfig = WGLSurfaceData.getGC(wComponentPeer);
        Rectangle rectangle = wComponentPeer.getBounds();
        int n = bl ? 6 : 5;
        return new WGLOffScreenSurfaceData(wComponentPeer, wGLGraphicsConfig, rectangle.width, rectangle.height, null, wComponentPeer.getColorModel(), n);
    }

    public static WGLOffScreenSurfaceData createData(WGLGraphicsConfig wGLGraphicsConfig, int n, int n2, ColorModel colorModel, Image image, int n3) {
        return new WGLOffScreenSurfaceData(null, wGLGraphicsConfig, n, n2, image, colorModel, n3);
    }

    public static WGLGraphicsConfig getGC(WComponentPeer wComponentPeer) {
        if (wComponentPeer != null) {
            return (WGLGraphicsConfig)wComponentPeer.getGraphicsConfiguration();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return (WGLGraphicsConfig)graphicsDevice.getDefaultConfiguration();
    }

    static {
        WGLSurfaceData.initIDs(WGLGraphicsConfig.class, OGLContext.LOCK);
    }

    public static class WGLOffScreenSurfaceData
    extends WGLSurfaceData {
        private Image offscreenImage;
        private int width;
        private int height;
        private int transparency;

        public WGLOffScreenSurfaceData(WComponentPeer wComponentPeer, WGLGraphicsConfig wGLGraphicsConfig, int n, int n2, Image image, ColorModel colorModel, int n3) {
            super(wComponentPeer, wGLGraphicsConfig, n3 == 4 ? OpenGLTexture : (n3 == 3 ? OpenGLSurfaceRTT : OpenGLSurface), colorModel, n3);
            this.width = n;
            this.height = n2;
            this.offscreenImage = image;
            this.transparency = colorModel.getTransparency();
            this.initSurface(n, n2, this.depth);
        }

        public SurfaceData getReplacement() {
            return WGLOffScreenSurfaceData.restoreContents(this.offscreenImage);
        }

        public int getTransparency() {
            return this.transparency;
        }

        public Rectangle getBounds() {
            if (this.type == 6) {
                Rectangle rectangle = this.peer.getBounds();
                rectangle.y = 0;
                rectangle.x = 0;
                return rectangle;
            }
            return new Rectangle(this.width, this.height);
        }
    }

    public static class WGLWindowSurfaceData
    extends WGLSurfaceData {
        public WGLWindowSurfaceData(WComponentPeer wComponentPeer, WGLGraphicsConfig wGLGraphicsConfig) {
            super(wComponentPeer, wGLGraphicsConfig, OpenGLSurface, wComponentPeer.getColorModel(), 0);
        }

        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        public Rectangle getBounds() {
            Rectangle rectangle = this.peer.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            return rectangle;
        }
    }
}

