/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.image.ColorModel;
import sun.awt.DisplayChangedListener;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.WindowsFlags;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;

public class WinVolatileSurfaceManager
extends VolatileSurfaceManager
implements DisplayChangedListener {
    private boolean accelerationEnabled;

    public WinVolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        super(sunVolatileImage, object);
        Win32GraphicsEnvironment win32GraphicsEnvironment = (Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        win32GraphicsEnvironment.addDisplayChangedListener(this);
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)sunVolatileImage.getGraphicsConfig().getDevice();
        this.accelerationEnabled = WindowsFlags.isDDEnabled() && WindowsFlags.isDDOffscreenEnabled() && (sunVolatileImage.getTransparency() == 1 || sunVolatileImage.getTransparency() == 3 && WindowsFlags.isTranslucentAccelerationEnabled() && win32GraphicsDevice.isD3DEnabledOnDevice());
    }

    protected Win32OffScreenSurfaceData createAccelSurface() {
        int n = this.vImg.getTransparency();
        GraphicsConfiguration graphicsConfiguration = this.vImg.getGraphicsConfig();
        ColorModel colorModel = n != 3 ? this.getDeviceColorModel() : graphicsConfiguration.getColorModel(3);
        return Win32OffScreenSurfaceData.createData(this.vImg.getWidth(), this.vImg.getHeight(), colorModel, graphicsConfiguration, this.vImg, n);
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    public void setAccelerationEnabled(boolean bl) {
        if (bl != this.accelerationEnabled) {
            this.sdCurrent = this.getBackupSurface();
            this.sdAccel = null;
            this.accelerationEnabled = bl;
        }
    }

    protected SurfaceData initAcceleratedSurface() {
        Win32OffScreenSurfaceData win32OffScreenSurfaceData;
        try {
            win32OffScreenSurfaceData = this.createAccelSurface();
        }
        catch (InvalidPipeException invalidPipeException) {
            win32OffScreenSurfaceData = null;
        }
        return win32OffScreenSurfaceData;
    }

    public SurfaceData restoreContents() {
        this.acceleratedSurfaceLost();
        return super.restoreContents();
    }

    protected ColorModel getDeviceColorModel() {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.vImg.getGraphicsConfig();
        return win32GraphicsConfig.getDeviceColorModel();
    }

    protected void restoreAcceleratedSurface() {
        ((Win32OffScreenSurfaceData)this.sdAccel).restoreSurface();
    }

    public void displayChanged() {
        if (!this.isAccelerationEnabled()) {
            return;
        }
        this.lostSurface = true;
        if (this.sdAccel != null) {
            this.sdBackup = null;
            this.sdCurrent = this.getBackupSurface();
            SurfaceData surfaceData = this.sdAccel;
            this.sdAccel = null;
            surfaceData.invalidate();
        }
        this.vImg.updateGraphicsConfig();
    }

    public void paletteChanged() {
        this.lostSurface = true;
    }

    public ImageCapabilities getCapabilities() {
        if (this.isAccelerationEnabled() && !(this.imageCaps instanceof DDImageCaps)) {
            this.imageCaps = new DDImageCaps();
        }
        return super.getCapabilities();
    }

    public void flush() {
        this.lostSurface = true;
        Win32OffScreenSurfaceData win32OffScreenSurfaceData = (Win32OffScreenSurfaceData)this.sdAccel;
        this.sdAccel = null;
        if (win32OffScreenSurfaceData != null) {
            win32OffScreenSurfaceData.flush();
        }
    }

    private class DDImageCaps
    extends VolatileSurfaceManager.DefaultImageCapabilities {
        private DDImageCaps() {
            super(WinVolatileSurfaceManager.this);
        }

        public boolean isTrueVolatile() {
            return this.isAccelerated();
        }
    }
}

