/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements SynthUI,
PropertyChangeListener {
    protected JPopupMenu systemPopupMenu;
    protected JButton menuButton;
    private SynthStyle style;

    public SynthInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public String getUIClassID() {
        return "InternalFrameTitlePaneUI";
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        if (this.frame != null && this.frame.isSelected()) {
            return 512;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    protected void addSubComponents() {
        this.menuButton.setName("InternalFrameTitlePane.menuButton");
        this.iconButton.setName("InternalFrameTitlePane.iconifyButton");
        this.maxButton.setName("InternalFrameTitlePane.maximizeButton");
        this.closeButton.setName("InternalFrameTitlePane.closeButton");
        this.add(this.menuButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    private void updateStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(this, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.maxIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.maximizeIcon");
            this.minIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.minimizeIcon");
            this.iconIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.iconifyIcon");
            this.closeIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.closeIcon");
        }
        synthContext.dispose();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        JInternalFrame.JDesktopIcon jDesktopIcon = this.frame.getDesktopIcon();
        if (jDesktopIcon != null && jDesktopIcon.getComponentPopupMenu() == this.systemPopupMenu) {
            jDesktopIcon.setComponentPopupMenu(null);
        }
        super.uninstallDefaults();
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenuUIResource();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.menuButton = this.createNoFocusButton();
        this.menuButton.setIcon(this.frame.getFrameIcon());
        this.menuButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SynthInternalFrameTitlePane.this.showSystemMenu();
            }
        });
        JPopupMenu jPopupMenu = this.frame.getComponentPopupMenu();
        if (jPopupMenu == null || jPopupMenu instanceof UIResource) {
            this.frame.setComponentPopupMenu(this.systemPopupMenu);
        }
        if (this.frame.getDesktopIcon() != null && ((jPopupMenu = this.frame.getDesktopIcon().getComponentPopupMenu()) == null || jPopupMenu instanceof UIResource)) {
            this.frame.getDesktopIcon().setComponentPopupMenu(this.systemPopupMenu);
        }
        this.setInheritsPopupMenu(true);
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        jPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    protected void showSystemMenu() {
        Dimension dimension = new Dimension();
        Insets insets = this.frame.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.bottom + insets.top;
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(this.menuButton, this.getX() - dimension.width, this.getY() + this.getHeight() - dimension.height);
        } else {
            this.systemPopupMenu.show(this.menuButton, this.getX() - dimension.width, this.getY() - this.systemPopupMenu.getPreferredSize().height - dimension.height);
        }
    }

    public void paintComponent(Graphics graphics) {
        SynthContext synthContext = this.getContext(this);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintInternalFrameTitlePaneBackground(synthContext, graphics, 0, 0, this.getWidth(), this.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintInternalFrameTitlePaneBorder(synthContext, graphics, n, n2, n3, n4);
    }

    protected LayoutManager createLayout() {
        SynthContext synthContext = this.getContext(this);
        LayoutManager layoutManager = (LayoutManager)this.style.get(synthContext, "InternalFrameTitlePane.titlePaneLayout");
        synthContext.dispose();
        return layoutManager != null ? layoutManager : new SynthTitlePaneLayout();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle(this);
        }
    }

    private JButton createNoFocusButton() {
        JButton jButton = new JButton();
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    private static class JPopupMenuUIResource
    extends JPopupMenu
    implements UIResource {
        private JPopupMenuUIResource() {
        }
    }

    class SynthTitlePaneLayout
    implements LayoutManager {
        SynthTitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            int n3 = 22;
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                n3 += 19;
            }
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                n3 += 19;
            }
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                n3 += 19;
            }
            FontMetrics fontMetrics = SynthInternalFrameTitlePane.this.frame.getFontMetrics(SynthInternalFrameTitlePane.this.getFont());
            SynthContext synthContext = SynthInternalFrameTitlePane.this.getContext(SynthInternalFrameTitlePane.this.frame);
            SynthGraphicsUtils synthGraphicsUtils = synthContext.getStyle().getGraphicsUtils(synthContext);
            String string = SynthInternalFrameTitlePane.this.frame.getTitle();
            int n4 = string != null ? synthGraphicsUtils.computeStringWidth(synthContext, fontMetrics.getFont(), fontMetrics, string) : 0;
            int n5 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 3 ? (n3 += n4 < (n = synthGraphicsUtils.computeStringWidth(synthContext, fontMetrics.getFont(), fontMetrics, string.substring(0, 3) + "...")) ? n4 : n) : (n3 += n4);
            Icon icon = SynthInternalFrameTitlePane.this.frame.getFrameIcon();
            int n6 = fontMetrics.getHeight();
            n6 += 2;
            int n7 = 0;
            if (icon != null) {
                n7 = Math.min(icon.getIconHeight(), 16);
            }
            int n8 = Math.max(n6, n7 += 2);
            Dimension dimension = new Dimension(n3, n8);
            if (SynthInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = SynthInternalFrameTitlePane.this.getBorder().getBorderInsets(container);
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
            }
            synthContext.dispose();
            return dimension;
        }

        public void layoutContainer(Container container) {
            Icon icon;
            int n;
            boolean bl = SynthLookAndFeel.isLeftToRight(SynthInternalFrameTitlePane.this.frame);
            int n2 = SynthInternalFrameTitlePane.this.getWidth();
            int n3 = SynthInternalFrameTitlePane.this.getHeight();
            Icon icon2 = SynthInternalFrameTitlePane.this.closeButton.getIcon();
            int n4 = n = icon2 != null ? icon2.getIconHeight() : 12;
            if (n == 0) {
                n = 12;
            }
            int n5 = (icon = SynthInternalFrameTitlePane.this.frame.getFrameIcon()) != null ? icon.getIconHeight() : n;
            Insets insets = SynthInternalFrameTitlePane.this.frame.getInsets();
            int n6 = bl ? insets.left : n2 - 16 - insets.right;
            SynthInternalFrameTitlePane.this.menuButton.setBounds(n6, (n3 - n5) / 2, 16, 14);
            int n7 = n6 = bl ? n2 - 16 - insets.right : insets.left;
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                SynthInternalFrameTitlePane.this.closeButton.setBounds(n6, (n3 - n) / 2, 16, 14);
                n6 += bl ? -18 : 18;
            }
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                SynthInternalFrameTitlePane.this.maxButton.setBounds(n6, (n3 - n) / 2, 16, 14);
                n6 += bl ? -18 : 18;
            }
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                SynthInternalFrameTitlePane.this.iconButton.setBounds(n6, (n3 - n) / 2, 16, 14);
            }
        }
    }
}

