/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.Arrays;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(Object[].class);
    private static final int scale = unsafe.arrayIndexScale(Object[].class);
    private final Object[] array;

    private long rawIndex(int n) {
        if (n < 0 || n >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n);
        }
        return base + n * scale;
    }

    public AtomicReferenceArray(int n) {
        this.array = new Object[n];
        if (n > 0) {
            unsafe.putObjectVolatile(this.array, this.rawIndex(0), null);
        }
    }

    public AtomicReferenceArray(E[] EArray) {
        if (EArray == null) {
            throw new NullPointerException();
        }
        int n = EArray.length;
        this.array = new Object[n];
        if (n > 0) {
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                this.array[i] = EArray[i];
            }
            E e = EArray[n2];
            unsafe.putObjectVolatile(this.array, this.rawIndex(n2), e);
        }
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int n) {
        return (E)unsafe.getObjectVolatile(this.array, this.rawIndex(n));
    }

    public final void set(int n, E e) {
        unsafe.putObjectVolatile(this.array, this.rawIndex(n), e);
    }

    public final E getAndSet(int n, E e) {
        E e2;
        while (!this.compareAndSet(n, e2 = this.get(n), e)) {
        }
        return e2;
    }

    public final boolean compareAndSet(int n, E e, E e2) {
        return unsafe.compareAndSwapObject(this.array, this.rawIndex(n), e, e2);
    }

    public final boolean weakCompareAndSet(int n, E e, E e2) {
        return this.compareAndSet(n, e, e2);
    }

    public String toString() {
        if (this.array.length > 0) {
            this.get(0);
        }
        return Arrays.toString(this.array);
    }
}

