/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V>,
Cloneable,
Serializable {
    private Comparator<? super K> comparator = null;
    private transient Entry<K, V> root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public TreeMap() {
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map<? extends K, ? extends V> map) {
        this.putAll(map);
    }

    public TreeMap(SortedMap<K, ? extends V> sortedMap) {
        this.comparator = sortedMap.comparator();
        try {
            this.buildFromSorted(sortedMap.size(), sortedMap.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.root == null ? false : (object == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, object));
    }

    private boolean valueSearchNull(Entry entry) {
        if (entry.value == null) {
            return true;
        }
        return entry.left != null && this.valueSearchNull(entry.left) || entry.right != null && this.valueSearchNull(entry.right);
    }

    private boolean valueSearchNonNull(Entry entry, Object object) {
        if (object.equals(entry.value)) {
            return true;
        }
        return entry.left != null && this.valueSearchNonNull(entry.left, object) || entry.right != null && this.valueSearchNonNull(entry.right, object);
    }

    @Override
    public V get(Object object) {
        Entry<K, V> entry = this.getEntry(object);
        return entry == null ? null : (V)entry.value;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        return TreeMap.key(this.firstEntry());
    }

    @Override
    public K lastKey() {
        return TreeMap.key(this.lastEntry());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator comparator;
        int n = map.size();
        if (this.size == 0 && n != 0 && map instanceof SortedMap && ((comparator = ((SortedMap)map).comparator()) == this.comparator || comparator != null && ((Object)comparator).equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(n, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    private Entry<K, V> getEntry(Object object) {
        Entry<K, V> entry = this.root;
        Object object2 = object;
        while (entry != null) {
            int n = this.compare(object2, entry.key);
            if (n == 0) {
                return entry;
            }
            if (n < 0) {
                entry = entry.left;
                continue;
            }
            entry = entry.right;
        }
        return null;
    }

    private Entry<K, V> getCeilEntry(K k) {
        Entry<K, V> entry = this.root;
        if (entry == null) {
            return null;
        }
        while (true) {
            int n;
            if ((n = this.compare(k, entry.key)) == 0) {
                return entry;
            }
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        Entry entry2 = entry.parent;
        Entry<K, V> entry3 = entry;
        while (entry2 != null && entry3 == entry2.right) {
            entry3 = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    private Entry<K, V> getPrecedingEntry(K k) {
        Entry<K, V> entry = this.root;
        if (entry == null) {
            return null;
        }
        while (true) {
            int n;
            if ((n = this.compare(k, entry.key)) > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (entry.left == null) break;
            entry = entry.left;
        }
        Entry entry2 = entry.parent;
        Entry<K, V> entry3 = entry;
        while (entry2 != null && entry3 == entry2.left) {
            entry3 = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    private static <K> K key(Entry<K, ?> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.key;
    }

    @Override
    public V put(K k, V v) {
        Entry<K, V> entry = this.root;
        if (entry == null) {
            this.incrementSize();
            this.root = new Entry<K, V>(k, v, null);
            return null;
        }
        while (true) {
            int n;
            if ((n = this.compare(k, entry.key)) == 0) {
                return entry.setValue(v);
            }
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize();
                entry.left = new Entry<K, V>(k, v, entry);
                this.fixAfterInsertion(entry.left);
                return null;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        this.incrementSize();
        entry.right = new Entry<K, V>(k, v, entry);
        this.fixAfterInsertion(entry.right);
        return null;
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        Object v = entry.value;
        this.deleteEntry(entry);
        return v;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        TreeMap treeMap = null;
        try {
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        treeMap.root = null;
        treeMap.size = 0;
        treeMap.modCount = 0;
        treeMap.entrySet = null;
        try {
            treeMap.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return treeMap;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator();
                }

                @Override
                public int size() {
                    return TreeMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    return TreeMap.this.containsKey(object);
                }

                @Override
                public boolean remove(Object object) {
                    int n = TreeMap.this.size;
                    TreeMap.this.remove(object);
                    return TreeMap.this.size != n;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return TreeMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    Entry entry = TreeMap.this.firstEntry();
                    while (entry != null) {
                        if (TreeMap.valEquals(entry.getValue(), object)) {
                            return true;
                        }
                        entry = TreeMap.this.successor(entry);
                    }
                    return false;
                }

                @Override
                public boolean remove(Object object) {
                    Entry entry = TreeMap.this.firstEntry();
                    while (entry != null) {
                        if (TreeMap.valEquals(entry.getValue(), object)) {
                            TreeMap.this.deleteEntry(entry);
                            return true;
                        }
                        entry = TreeMap.this.successor(entry);
                    }
                    return false;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v = entry.getValue();
                    Entry entry2 = TreeMap.this.getEntry(entry.getKey());
                    return entry2 != null && TreeMap.valEquals(entry2.getValue(), v);
                }

                @Override
                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v = entry.getValue();
                    Entry entry2 = TreeMap.this.getEntry(entry.getKey());
                    if (entry2 != null && TreeMap.valEquals(entry2.getValue(), v)) {
                        TreeMap.this.deleteEntry(entry2);
                        return true;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return TreeMap.this.size();
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        return new SubMap(k, k2);
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        return new SubMap(k, true);
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        return new SubMap(k, false);
    }

    private int compare(K k, K k2) {
        return this.comparator == null ? ((Comparable)k).compareTo(k2) : this.comparator.compare(k, k2);
    }

    private static boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private Entry<K, V> firstEntry() {
        Entry<K, V> entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    private Entry<K, V> lastEntry() {
        Entry<K, V> entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    private Entry<K, V> successor(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry entry2 = entry.right;
            while (entry2.left != null) {
                entry2 = entry2.left;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry<K, V> entry4 = entry;
        while (entry3 != null && entry4 == entry3.right) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    private static <K, V> boolean colorOf(Entry<K, V> entry) {
        return entry == null ? true : entry.color;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> entry) {
        return entry == null ? null : entry.parent;
    }

    private static <K, V> void setColor(Entry<K, V> entry, boolean bl) {
        if (entry != null) {
            entry.color = bl;
        }
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> entry) {
        return entry == null ? null : entry.left;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> entry) {
        return entry == null ? null : entry.right;
    }

    private void rotateLeft(Entry<K, V> entry) {
        Entry entry2 = entry.right;
        entry.right = entry2.left;
        if (entry2.left != null) {
            entry2.left.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.left == entry) {
            entry.parent.left = entry2;
        } else {
            entry.parent.right = entry2;
        }
        entry2.left = entry;
        entry.parent = entry2;
    }

    private void rotateRight(Entry<K, V> entry) {
        Entry entry2 = entry.left;
        entry.left = entry2.right;
        if (entry2.right != null) {
            entry2.right.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.right == entry) {
            entry.parent.right = entry2;
        } else {
            entry.parent.left = entry2;
        }
        entry2.right = entry;
        entry.parent = entry2;
    }

    private void fixAfterInsertion(Entry<K, V> entry) {
        entry.color = false;
        while (entry != null && entry != this.root && !entry.parent.color) {
            Entry<K, V> entry2;
            if (TreeMap.parentOf(entry) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(TreeMap.parentOf(entry), true);
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                    entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                    continue;
                }
                if (entry == TreeMap.rightOf(TreeMap.parentOf(entry))) {
                    entry = TreeMap.parentOf(entry);
                    this.rotateLeft(entry);
                }
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                if (TreeMap.parentOf(TreeMap.parentOf(entry)) == null) continue;
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(entry)));
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                continue;
            }
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry = TreeMap.parentOf(entry);
                this.rotateRight(entry);
            }
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
            if (TreeMap.parentOf(TreeMap.parentOf(entry)) == null) continue;
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(entry)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry<K, V> entry) {
        Entry entry2;
        this.decrementSize();
        if (entry.left != null && entry.right != null) {
            entry2 = this.successor(entry);
            entry.key = entry2.key;
            entry.value = entry2.value;
            entry = entry2;
        }
        Entry entry3 = entry2 = entry.left != null ? entry.left : entry.right;
        if (entry2 != null) {
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry == entry.parent.left) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry.parent = null;
            entry.right = null;
            entry.left = null;
            if (entry.color) {
                this.fixAfterDeletion(entry2);
            }
        } else if (entry.parent == null) {
            this.root = null;
        } else {
            if (entry.color) {
                this.fixAfterDeletion(entry);
            }
            if (entry.parent != null) {
                if (entry == entry.parent.left) {
                    entry.parent.left = null;
                } else if (entry == entry.parent.right) {
                    entry.parent.right = null;
                }
                entry.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry<K, V> entry) {
        while (entry != this.root && TreeMap.colorOf(entry)) {
            Entry<K, V> entry2;
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(entry), false);
                    this.rotateLeft(TreeMap.parentOf(entry));
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(entry2)) && TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(entry2, false);
                    entry = TreeMap.parentOf(entry);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(TreeMap.leftOf(entry2), true);
                    TreeMap.setColor(entry2, false);
                    this.rotateRight(entry2);
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                this.rotateLeft(TreeMap.parentOf(entry));
                entry = this.root;
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(entry), false);
                this.rotateRight(TreeMap.parentOf(entry));
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(entry2)) && TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(entry2, false);
                entry = TreeMap.parentOf(entry);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                TreeMap.setColor(entry2, false);
                this.rotateLeft(entry2);
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.leftOf(entry2), true);
            this.rotateRight(TreeMap.parentOf(entry));
            entry = this.root;
        }
        TreeMap.setColor(entry, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.buildFromSorted(n, null, objectInputStream, null);
    }

    void readTreeSet(int n, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.buildFromSorted(n, null, objectInputStream, v);
    }

    void addAllForTreeSet(SortedSet<Map.Entry<K, V>> sortedSet, V v) {
        try {
            this.buildFromSorted(sortedSet.size(), sortedSet.iterator(), null, v);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int n, Iterator iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        this.size = n;
        this.root = this.buildFromSorted(0, 0, n - 1, TreeMap.computeRedLevel(n), iterator, objectInputStream, v);
    }

    private final Entry<K, V> buildFromSorted(int n, int n2, int n3, int n4, Iterator iterator, ObjectInputStream objectInputStream, V v) throws IOException, ClassNotFoundException {
        V v2;
        Object object;
        Entry<Object, V> entry;
        if (n3 < n2) {
            return null;
        }
        int n5 = (n2 + n3) / 2;
        Entry<K, V> entry2 = null;
        if (n2 < n5) {
            entry2 = this.buildFromSorted(n + 1, n2, n5 - 1, n4, iterator, objectInputStream, v);
        }
        if (iterator != null) {
            if (v == null) {
                entry = (Entry<Object, V>)iterator.next();
                object = entry.getKey();
                v2 = entry.getValue();
            } else {
                object = iterator.next();
                v2 = v;
            }
        } else {
            object = objectInputStream.readObject();
            v2 = v != null ? v : objectInputStream.readObject();
        }
        entry = new Entry<Object, V>(object, v2, null);
        if (n == n4) {
            entry.color = false;
        }
        if (entry2 != null) {
            entry.left = entry2;
            entry2.parent = entry;
        }
        if (n5 < n3) {
            Entry<K, V> entry3 = this.buildFromSorted(n + 1, n5 + 1, n3, n4, iterator, objectInputStream, v);
            entry.right = entry3;
            entry3.parent = entry;
        }
        return entry;
    }

    private static int computeRedLevel(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            ++n2;
            n3 = n3 / 2 - 1;
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        Entry<K, V> left = null;
        Entry<K, V> right = null;
        Entry<K, V> parent;
        boolean color = true;

        Entry(K k, V v, Entry<K, V> entry) {
            this.key = k;
            this.value = v;
            this.parent = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return TreeMap.valEquals(this.key, entry.getKey()) && TreeMap.valEquals(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            int n = this.key == null ? 0 : this.key.hashCode();
            int n2 = this.value == null ? 0 : this.value.hashCode();
            return n ^ n2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends PrivateEntryIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        private int expectedModCount;
        private Entry<K, V> lastReturned;
        Entry<K, V> next;

        PrivateEntryIterator() {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.next = TreeMap.this.firstEntry();
        }

        PrivateEntryIterator(Entry<K, V> entry) {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.next = entry;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = TreeMap.this.successor(this.next);
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart = false;
        private boolean toEnd = false;
        private K fromKey;
        private K toKey;
        private transient Set<Map.Entry<K, V>> entrySet = new EntrySetView();

        SubMap(K k, K k2) {
            if (TreeMap.this.compare(k, k2) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = k;
            this.toKey = k2;
        }

        SubMap(K k, boolean bl) {
            TreeMap.this.compare(k, k);
            if (bl) {
                this.fromStart = true;
                this.toKey = k;
            } else {
                this.toEnd = true;
                this.fromKey = k;
            }
        }

        SubMap(boolean bl, K k, boolean bl2, K k2) {
            this.fromStart = bl;
            this.fromKey = k;
            this.toEnd = bl2;
            this.toKey = k2;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.inRange(object) && TreeMap.this.containsKey(object);
        }

        @Override
        public V get(Object object) {
            if (!this.inRange(object)) {
                return null;
            }
            return TreeMap.this.get(object);
        }

        @Override
        public V put(K k, V v) {
            if (!this.inRange(k)) {
                throw new IllegalArgumentException("key out of range");
            }
            return TreeMap.this.put(k, v);
        }

        @Override
        public Comparator<? super K> comparator() {
            return TreeMap.this.comparator;
        }

        @Override
        public K firstKey() {
            Entry entry = this.fromStart ? TreeMap.this.firstEntry() : TreeMap.this.getCeilEntry(this.fromKey);
            Object object = TreeMap.key(entry);
            if (!this.toEnd && TreeMap.this.compare(object, this.toKey) >= 0) {
                throw new NoSuchElementException();
            }
            return object;
        }

        @Override
        public K lastKey() {
            Entry entry = this.toEnd ? TreeMap.this.lastEntry() : TreeMap.this.getPrecedingEntry(this.toKey);
            Object object = TreeMap.key(entry);
            if (!this.fromStart && TreeMap.this.compare(object, this.fromKey) < 0) {
                throw new NoSuchElementException();
            }
            return object;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entrySet;
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            if (!this.inRange2(k)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(k2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(k, k2);
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            if (!this.inRange2(k)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromStart, this.fromKey, false, k);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            if (!this.inRange2(k)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(false, k, this.toEnd, this.toKey);
        }

        private boolean inRange(K k) {
            return !(!this.fromStart && TreeMap.this.compare(k, this.fromKey) < 0 || !this.toEnd && TreeMap.this.compare(k, this.toKey) >= 0);
        }

        private boolean inRange2(K k) {
            return !(!this.fromStart && TreeMap.this.compare(k, this.fromKey) < 0 || !this.toEnd && TreeMap.this.compare(k, this.toKey) > 0);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            private EntrySetView() {
            }

            @Override
            public int size() {
                if (this.size == -1 || this.sizeModCount != TreeMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = TreeMap.this.modCount;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        ++this.size;
                        iterator.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!SubMap.this.inRange(k)) {
                    return false;
                }
                Entry entry2 = TreeMap.this.getEntry(k);
                return entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!SubMap.this.inRange(k)) {
                    return false;
                }
                Entry entry2 = TreeMap.this.getEntry(k);
                if (entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue())) {
                    TreeMap.this.deleteEntry(entry2);
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new SubMapEntryIterator(SubMap.this.fromStart ? TreeMap.this.firstEntry() : TreeMap.this.getCeilEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : TreeMap.this.getCeilEntry(SubMap.this.toKey));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubMapEntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        private final K firstExcludedKey;

        SubMapEntryIterator(Entry<K, V> entry, Entry<K, V> entry2) {
            super(entry);
            this.firstExcludedKey = entry2 == null ? null : entry2.key;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.key != this.firstExcludedKey;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.next == null || this.next.key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends PrivateEntryIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }
}

