/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jlex.internal;

import com.sun.jlex.internal.CAlloc;
import com.sun.jlex.internal.CBunch;
import com.sun.jlex.internal.CDTrans;
import com.sun.jlex.internal.CDfa;
import com.sun.jlex.internal.CLexGen;
import com.sun.jlex.internal.CNfa;
import com.sun.jlex.internal.CSpec;
import com.sun.jlex.internal.CUtility;
import com.sun.jlex.internal.SparseBitSet;
import java.util.Stack;
import java.util.Vector;

class CNfa2Dfa {
    private CSpec m_spec;
    private int m_unmarked_dfa;
    private CLexGen m_lexGen;
    private static final int NOT_IN_DSTATES = -1;

    CNfa2Dfa() {
        this.reset();
    }

    private void set(CLexGen cLexGen, CSpec cSpec) {
        this.m_lexGen = cLexGen;
        this.m_spec = cSpec;
        this.m_unmarked_dfa = 0;
    }

    private void reset() {
        this.m_lexGen = null;
        this.m_spec = null;
        this.m_unmarked_dfa = 0;
    }

    void make_dfa(CLexGen cLexGen, CSpec cSpec) {
        this.reset();
        this.set(cLexGen, cSpec);
        this.make_dtrans();
        this.free_nfa_states();
        if (this.m_spec.m_verbose) {
            // empty if block
        }
        this.free_dfa_states();
    }

    private void make_dtrans() {
        System.out.print("Working on DFA states.");
        CBunch cBunch = new CBunch();
        this.m_unmarked_dfa = 0;
        int n = this.m_spec.m_state_rules.length;
        this.m_spec.m_state_dtrans = new int[n];
        for (int i = 0; n > i; ++i) {
            CDfa cDfa;
            int n2;
            cBunch.m_nfa_set = (Vector)this.m_spec.m_state_rules[i].clone();
            this.sortStates(cBunch.m_nfa_set);
            cBunch.m_nfa_bit = new SparseBitSet();
            int n3 = cBunch.m_nfa_set.size();
            for (n2 = 0; n3 > n2; ++n2) {
                CNfa cNfa = (CNfa)cBunch.m_nfa_set.elementAt(n2);
                cBunch.m_nfa_bit.set(cNfa.m_label);
            }
            cBunch.m_accept = null;
            cBunch.m_anchor = 0;
            cBunch.m_accept_index = Integer.MAX_VALUE;
            this.e_closure(cBunch);
            this.add_to_dstates(cBunch);
            this.m_spec.m_state_dtrans[i] = this.m_spec.m_dtrans_vector.size();
            while (null != (cDfa = this.get_unmarked())) {
                System.out.print(".");
                System.out.flush();
                CUtility._assert(false == cDfa.m_mark);
                cDfa.m_mark = true;
                CDTrans cDTrans = new CDTrans(this.m_spec.m_dtrans_vector.size(), this.m_spec);
                cDTrans.m_accept = cDfa.m_accept;
                cDTrans.m_anchor = cDfa.m_anchor;
                for (n2 = 0; n2 < this.m_spec.m_dtrans_ncols; ++n2) {
                    int n4;
                    CUtility._assert(0 <= n2);
                    CUtility._assert(this.m_spec.m_dtrans_ncols > n2);
                    this.move(cDfa.m_nfa_set, cDfa.m_nfa_bit, n2, cBunch);
                    if (null != cBunch.m_nfa_set) {
                        this.e_closure(cBunch);
                    }
                    CUtility._assert(null == cBunch.m_nfa_set && null == cBunch.m_nfa_bit || null != cBunch.m_nfa_set && null != cBunch.m_nfa_bit);
                    if (null == cBunch.m_nfa_set) {
                        n4 = -1;
                    } else {
                        n4 = this.in_dstates(cBunch);
                        if (-1 == n4) {
                            n4 = this.add_to_dstates(cBunch);
                        }
                    }
                    CUtility._assert(n4 < this.m_spec.m_dfa_states.size());
                    cDTrans.m_dtrans[n2] = n4;
                }
                CUtility._assert(this.m_spec.m_dtrans_vector.size() == cDfa.m_label);
                this.m_spec.m_dtrans_vector.addElement(cDTrans);
            }
        }
        System.out.println();
    }

    private void free_dfa_states() {
        this.m_spec.m_dfa_states = null;
        this.m_spec.m_dfa_sets = null;
    }

    private void free_nfa_states() {
        this.m_spec.m_nfa_states = null;
        this.m_spec.m_nfa_start = null;
        this.m_spec.m_state_rules = null;
    }

    private void e_closure(CBunch cBunch) {
        CNfa cNfa;
        CUtility._assert(null != cBunch);
        CUtility._assert(null != cBunch.m_nfa_set);
        CUtility._assert(null != cBunch.m_nfa_bit);
        cBunch.m_accept = null;
        cBunch.m_anchor = 0;
        cBunch.m_accept_index = Integer.MAX_VALUE;
        Stack<CNfa> stack = new Stack<CNfa>();
        int n = cBunch.m_nfa_set.size();
        for (int i = 0; i < n; ++i) {
            cNfa = (CNfa)cBunch.m_nfa_set.elementAt(i);
            CUtility._assert(cBunch.m_nfa_bit.get(cNfa.m_label));
            stack.push(cNfa);
        }
        while (!stack.empty()) {
            cNfa = (CNfa)stack.pop();
            if (null != cNfa.m_accept && cNfa.m_label < cBunch.m_accept_index) {
                cBunch.m_accept_index = cNfa.m_label;
                cBunch.m_accept = cNfa.m_accept;
                cBunch.m_anchor = cNfa.m_anchor;
                CUtility._assert(null != cBunch.m_accept);
                CUtility._assert(0 == cBunch.m_anchor || 0 != (cBunch.m_anchor & 2) || 0 != (cBunch.m_anchor & 1));
            }
            if (-3 != cNfa.m_edge) continue;
            if (null != cNfa.m_next && !cBunch.m_nfa_set.contains(cNfa.m_next)) {
                CUtility._assert(false == cBunch.m_nfa_bit.get(cNfa.m_next.m_label));
                cBunch.m_nfa_bit.set(cNfa.m_next.m_label);
                cBunch.m_nfa_set.addElement(cNfa.m_next);
                stack.push(cNfa.m_next);
            }
            if (null == cNfa.m_next2 || cBunch.m_nfa_set.contains(cNfa.m_next2)) continue;
            CUtility._assert(false == cBunch.m_nfa_bit.get(cNfa.m_next2.m_label));
            cBunch.m_nfa_bit.set(cNfa.m_next2.m_label);
            cBunch.m_nfa_set.addElement(cNfa.m_next2);
            stack.push(cNfa.m_next2);
        }
        if (null != cBunch.m_nfa_set) {
            this.sortStates(cBunch.m_nfa_set);
        }
    }

    void move(Vector vector, SparseBitSet sparseBitSet, int n, CBunch cBunch) {
        cBunch.m_nfa_set = null;
        cBunch.m_nfa_bit = null;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            CNfa cNfa = (CNfa)vector.elementAt(i);
            if (n != cNfa.m_edge && (-1 != cNfa.m_edge || !cNfa.m_set.contains(n))) continue;
            if (null == cBunch.m_nfa_set) {
                CUtility._assert(null == cBunch.m_nfa_bit);
                cBunch.m_nfa_set = new Vector();
                cBunch.m_nfa_bit = new SparseBitSet();
            }
            cBunch.m_nfa_set.addElement(cNfa.m_next);
            cBunch.m_nfa_bit.set(cNfa.m_next.m_label);
        }
        if (null != cBunch.m_nfa_set) {
            CUtility._assert(null != cBunch.m_nfa_bit);
            this.sortStates(cBunch.m_nfa_set);
        }
    }

    private void sortStates(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            CNfa cNfa = (CNfa)vector.elementAt(i);
            int n2 = cNfa.m_label;
            int n3 = i;
            for (int j = i + 1; j < n; ++j) {
                cNfa = (CNfa)vector.elementAt(j);
                int n4 = cNfa.m_label;
                if (n4 >= n2) continue;
                n3 = j;
                n2 = n4;
            }
            CNfa cNfa2 = (CNfa)vector.elementAt(i);
            cNfa = (CNfa)vector.elementAt(n3);
            vector.setElementAt(cNfa, i);
            vector.setElementAt(cNfa2, n3);
        }
    }

    private CDfa get_unmarked() {
        int n = this.m_spec.m_dfa_states.size();
        while (this.m_unmarked_dfa < n) {
            CDfa cDfa = (CDfa)this.m_spec.m_dfa_states.elementAt(this.m_unmarked_dfa);
            if (!cDfa.m_mark) {
                if (this.m_spec.m_verbose) {
                    // empty if block
                }
                return cDfa;
            }
            ++this.m_unmarked_dfa;
        }
        return null;
    }

    private int add_to_dstates(CBunch cBunch) {
        CUtility._assert(null != cBunch.m_nfa_set);
        CUtility._assert(null != cBunch.m_nfa_bit);
        CUtility._assert(null != cBunch.m_accept || 0 == cBunch.m_anchor);
        CDfa cDfa = CAlloc.newCDfa(this.m_spec);
        cDfa.m_nfa_set = (Vector)cBunch.m_nfa_set.clone();
        cDfa.m_nfa_bit = (SparseBitSet)cBunch.m_nfa_bit.clone();
        cDfa.m_accept = cBunch.m_accept;
        cDfa.m_anchor = cBunch.m_anchor;
        cDfa.m_mark = false;
        this.m_spec.m_dfa_sets.put(cDfa.m_nfa_bit, cDfa);
        return cDfa.m_label;
    }

    private int in_dstates(CBunch cBunch) {
        CDfa cDfa = (CDfa)this.m_spec.m_dfa_sets.get(cBunch.m_nfa_bit);
        if (null != cDfa) {
            return cDfa.m_label;
        }
        return -1;
    }
}

