/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class CompactShortArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    static final int BLOCKSHIFT = 7;
    static final int BLOCKCOUNT = 128;
    static final int INDEXSHIFT = 9;
    static final int INDEXCOUNT = 512;
    static final int BLOCKMASK = 127;
    private short[] values;
    private short[] indices;
    private int[] hashes;
    private boolean isCompact;
    short defaultValue;

    public CompactShortArray() {
        this(0);
    }

    public CompactShortArray(short s) {
        int n;
        this.values = new short[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        for (n = 0; n < 65536; ++n) {
            this.values[n] = s;
        }
        for (n = 0; n < 512; ++n) {
            this.indices[n] = (short)(n << 7);
            this.hashes[n] = 0;
        }
        this.isCompact = false;
        this.defaultValue = s;
    }

    public CompactShortArray(short[] sArray, short[] sArray2, short s) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        for (int i = 0; i < 512; ++i) {
            short s2 = sArray[i];
            if (s2 >= 0 && s2 < sArray2.length + 128) continue;
            throw new IllegalArgumentException("Index out of bounds.");
        }
        this.indices = sArray;
        this.values = sArray2;
        this.isCompact = true;
        this.defaultValue = s;
    }

    public short elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public void setElementAt(char c, short s) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = s;
        this.touchBlock(c >> 7, s);
    }

    public void setElementAt(char n, char c, short s) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i = n; i <= c; ++i) {
            this.values[i] = s;
            this.touchBlock(i >> 7, s);
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.indices.length) {
                this.indices[n4] = -1;
                boolean bl = this.blockTouched(n4);
                if (!bl && n3 != -1) {
                    this.indices[n4] = n3;
                } else {
                    int n5 = 0;
                    int n6 = 0;
                    n6 = 0;
                    while (n6 < n) {
                        if (this.hashes[n4] == this.hashes[n6] && CompactShortArray.arrayRegionMatches(this.values, n2, this.values, n5, 128)) {
                            this.indices[n4] = (short)n5;
                        }
                        ++n6;
                        n5 += 128;
                    }
                    if (this.indices[n4] == -1) {
                        System.arraycopy(this.values, n2, this.values, n5, 128);
                        this.indices[n4] = (short)n5;
                        this.hashes[n6] = this.hashes[n4];
                        ++n;
                        if (!bl) {
                            n3 = (short)n5;
                        }
                    }
                }
                ++n4;
                n2 += 128;
            }
            n4 = n * 128;
            short[] sArray = new short[n4];
            System.arraycopy(this.values, 0, sArray, 0, n4);
            this.values = sArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    public static final boolean arrayRegionMatches(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        for (int i = n; i < n4; ++i) {
            if (sArray[i] == sArray2[i + n5]) continue;
            return false;
        }
        return true;
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public short[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactShortArray compactShortArray = (CompactShortArray)super.clone();
            compactShortArray.values = (short[])this.values.clone();
            compactShortArray.indices = (short[])this.indices.clone();
            return compactShortArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactShortArray compactShortArray = (CompactShortArray)object;
        for (int i = 0; i < 65536; ++i) {
            if (this.elementAt((char)i) == compactShortArray.elementAt((char)i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        for (int i = 0; i < this.values.length; i += n2) {
            n = n * 37 + this.values[i];
        }
        return n;
    }

    public Iterator getIterator() {
        return new Iterator();
    }

    private void expand() {
        if (this.isCompact) {
            int n;
            short[] sArray = new short[65536];
            for (n = 0; n < 65536; ++n) {
                sArray[n] = this.elementAt((char)n);
            }
            for (n = 0; n < 512; ++n) {
                this.indices[n] = (short)(n << 7);
            }
            this.values = null;
            this.values = sArray;
            this.isCompact = false;
        }
    }

    public class Iterator {
        int nextIndex = -1;
        int index = -1;
        short nextValue;
        short value;
        short iUntouched = (short)-1;
        boolean touched = true;
        short defValue;

        Iterator() {
            this.defValue = CompactShortArray.this.defaultValue;
            CompactShortArray.this.compact();
        }

        public boolean hasNext() {
            this.nextIndex = this.index;
            boolean bl = true;
            if (this.index != this.nextIndex) {
                return true;
            }
            while (++this.nextIndex < 65535) {
                if ((this.nextIndex & 0x7F) == 0) {
                    int n = this.nextIndex >> 7;
                    if (CompactShortArray.this.indices[n] == this.iUntouched) {
                        this.nextIndex += 127;
                        continue;
                    }
                    if (this.iUntouched == -1 && !this.touched) {
                        this.iUntouched = CompactShortArray.this.indices[n - 1];
                    } else {
                        this.touched = false;
                    }
                }
                this.nextValue = CompactShortArray.this.elementAt((char)this.nextIndex);
                if (this.nextValue == this.defValue) continue;
                this.touched = true;
                break;
            }
            return this.nextIndex < 65535;
        }

        public char next() {
            if (this.index == this.nextIndex && !this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.index = this.nextIndex;
            this.value = this.nextValue;
            return (char)this.index;
        }

        public short shortValue() {
            return this.value;
        }
    }
}

