/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateIssuerUniqueIdentity;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateSubjectUniqueIdentity;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.OIDMap;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509AttributeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CertInfo
implements CertAttrSet {
    public static final String IDENT = "x509.info";
    public static final String NAME = "info";
    public static final String VERSION = "version";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String ALGORITHM_ID = "algorithmID";
    public static final String ISSUER = "issuer";
    public static final String VALIDITY = "validity";
    public static final String SUBJECT = "subject";
    public static final String KEY = "key";
    public static final String ISSUER_ID = "issuerID";
    public static final String SUBJECT_ID = "subjectID";
    public static final String EXTENSIONS = "extensions";
    protected CertificateVersion version = new CertificateVersion();
    protected CertificateSerialNumber serialNum = null;
    protected CertificateAlgorithmId algId = null;
    protected CertificateIssuerName issuer = null;
    protected CertificateValidity interval = null;
    protected CertificateSubjectName subject = null;
    protected CertificateX509Key pubKey = null;
    protected CertificateIssuerUniqueIdentity issuerUniqueId = null;
    protected CertificateSubjectUniqueIdentity subjectUniqueId = null;
    protected CertificateExtensions extensions = null;
    private static final int ATTR_VERSION = 1;
    private static final int ATTR_SERIAL = 2;
    private static final int ATTR_ALGORITHM = 3;
    private static final int ATTR_ISSUER = 4;
    private static final int ATTR_VALIDITY = 5;
    private static final int ATTR_SUBJECT = 6;
    private static final int ATTR_KEY = 7;
    private static final int ATTR_ISSUER_ID = 8;
    private static final int ATTR_SUBJECT_ID = 9;
    private static final int ATTR_EXTENSIONS = 10;
    private byte[] rawCertInfo = null;
    private static final Map<String, Integer> map = new HashMap<String, Integer>();

    public X509CertInfo() {
    }

    public X509CertInfo(byte[] byArray) throws CertificateParsingException {
        try {
            DerValue derValue = new DerValue(byArray);
            this.parse(derValue);
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.toString());
            certificateParsingException.initCause(iOException);
            throw certificateParsingException;
        }
    }

    public X509CertInfo(DerValue derValue) throws CertificateParsingException {
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.toString());
            certificateParsingException.initCause(iOException);
            throw certificateParsingException;
        }
    }

    @Override
    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        if (this.rawCertInfo == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.emit(derOutputStream);
            this.rawCertInfo = derOutputStream.toByteArray();
        }
        outputStream.write((byte[])this.rawCertInfo.clone());
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(VERSION);
        attributeNameEnumeration.addElement(SERIAL_NUMBER);
        attributeNameEnumeration.addElement(ALGORITHM_ID);
        attributeNameEnumeration.addElement(ISSUER);
        attributeNameEnumeration.addElement(VALIDITY);
        attributeNameEnumeration.addElement(SUBJECT);
        attributeNameEnumeration.addElement(KEY);
        attributeNameEnumeration.addElement(ISSUER_ID);
        attributeNameEnumeration.addElement(SUBJECT_ID);
        attributeNameEnumeration.addElement(EXTENSIONS);
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public byte[] getEncodedInfo() throws CertificateEncodingException {
        try {
            if (this.rawCertInfo == null) {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.emit(derOutputStream);
                this.rawCertInfo = derOutputStream.toByteArray();
            }
            return (byte[])this.rawCertInfo.clone();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
        catch (CertificateException certificateException) {
            throw new CertificateEncodingException(certificateException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof X509CertInfo) {
            return this.equals((X509CertInfo)object);
        }
        return false;
    }

    public boolean equals(X509CertInfo x509CertInfo) {
        if (this == x509CertInfo) {
            return true;
        }
        if (this.rawCertInfo == null || x509CertInfo.rawCertInfo == null) {
            return false;
        }
        if (this.rawCertInfo.length != x509CertInfo.rawCertInfo.length) {
            return false;
        }
        for (int i = 0; i < this.rawCertInfo.length; ++i) {
            if (this.rawCertInfo[i] == x509CertInfo.rawCertInfo[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.rawCertInfo.length; ++i) {
            n += this.rawCertInfo[i] * i;
        }
        return n;
    }

    @Override
    public String toString() {
        if (this.subject == null || this.pubKey == null || this.interval == null || this.issuer == null || this.algId == null || this.serialNum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\n");
        stringBuilder.append("  " + this.version.toString() + "\n");
        stringBuilder.append("  Subject: " + this.subject.toString() + "\n");
        stringBuilder.append("  Signature Algorithm: " + this.algId.toString() + "\n");
        stringBuilder.append("  Key:  " + this.pubKey.toString() + "\n");
        stringBuilder.append("  " + this.interval.toString() + "\n");
        stringBuilder.append("  Issuer: " + this.issuer.toString() + "\n");
        stringBuilder.append("  " + this.serialNum.toString() + "\n");
        if (this.issuerUniqueId != null) {
            stringBuilder.append("  Issuer Id:\n" + this.issuerUniqueId.toString() + "\n");
        }
        if (this.subjectUniqueId != null) {
            stringBuilder.append("  Subject Id:\n" + this.subjectUniqueId.toString() + "\n");
        }
        if (this.extensions != null) {
            HexDumpEncoder hexDumpEncoder;
            Collection<Extension> collection = this.extensions.getAllExtensions();
            Object[] objectArray = collection.toArray();
            stringBuilder.append("\nCertificate Extensions: " + objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuilder.append("\n[" + (i + 1) + "]: ");
                Extension extension = (Extension)objectArray[i];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuilder.append(extension.toString());
                        Object object = extension.getExtensionValue();
                        if (object == null) continue;
                        DerOutputStream object2 = new DerOutputStream();
                        object2.putOctetString((byte[])object);
                        object = object2.toByteArray();
                        hexDumpEncoder = new HexDumpEncoder();
                        stringBuilder.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer((byte[])object) + "\n");
                        continue;
                    }
                    stringBuilder.append(extension.toString());
                    continue;
                }
                catch (Exception exception) {
                    stringBuilder.append(", Error parsing this extension");
                }
            }
            Map<String, Extension> map = this.extensions.getUnparseableExtensions();
            if (!map.isEmpty()) {
                stringBuilder.append("\nUnparseable certificate extensions: " + map.size());
                int n = 1;
                for (Extension extension : map.values()) {
                    stringBuilder.append("\n[" + n++ + "]: ");
                    stringBuilder.append(extension);
                    hexDumpEncoder = new HexDumpEncoder();
                    stringBuilder.append(hexDumpEncoder.encodeBuffer(extension.getExtensionValue()));
                }
            }
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    @Override
    public void set(String string, Object object) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            throw new CertificateException("Attribute name not recognized: " + string);
        }
        this.rawCertInfo = null;
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 1: {
                if (string2 == null) {
                    this.setVersion(object);
                    break;
                }
                this.version.set(string2, object);
                break;
            }
            case 2: {
                if (string2 == null) {
                    this.setSerialNumber(object);
                    break;
                }
                this.serialNum.set(string2, object);
                break;
            }
            case 3: {
                if (string2 == null) {
                    this.setAlgorithmId(object);
                    break;
                }
                this.algId.set(string2, object);
                break;
            }
            case 4: {
                if (string2 == null) {
                    this.setIssuer(object);
                    break;
                }
                this.issuer.set(string2, object);
                break;
            }
            case 5: {
                if (string2 == null) {
                    this.setValidity(object);
                    break;
                }
                this.interval.set(string2, object);
                break;
            }
            case 6: {
                if (string2 == null) {
                    this.setSubject(object);
                    break;
                }
                this.subject.set(string2, object);
                break;
            }
            case 7: {
                if (string2 == null) {
                    this.setKey(object);
                    break;
                }
                this.pubKey.set(string2, object);
                break;
            }
            case 8: {
                if (string2 == null) {
                    this.setIssuerUniqueId(object);
                    break;
                }
                this.issuerUniqueId.set(string2, object);
                break;
            }
            case 9: {
                if (string2 == null) {
                    this.setSubjectUniqueId(object);
                    break;
                }
                this.subjectUniqueId.set(string2, object);
                break;
            }
            case 10: {
                if (string2 == null) {
                    this.setExtensions(object);
                    break;
                }
                if (this.extensions == null) {
                    this.extensions = new CertificateExtensions();
                }
                this.extensions.set(string2, object);
            }
        }
    }

    @Override
    public void delete(String string) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            throw new CertificateException("Attribute name not recognized: " + string);
        }
        this.rawCertInfo = null;
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 1: {
                if (string2 == null) {
                    this.version = null;
                    break;
                }
                this.version.delete(string2);
                break;
            }
            case 2: {
                if (string2 == null) {
                    this.serialNum = null;
                    break;
                }
                this.serialNum.delete(string2);
                break;
            }
            case 3: {
                if (string2 == null) {
                    this.algId = null;
                    break;
                }
                this.algId.delete(string2);
                break;
            }
            case 4: {
                if (string2 == null) {
                    this.issuer = null;
                    break;
                }
                this.issuer.delete(string2);
                break;
            }
            case 5: {
                if (string2 == null) {
                    this.interval = null;
                    break;
                }
                this.interval.delete(string2);
                break;
            }
            case 6: {
                if (string2 == null) {
                    this.subject = null;
                    break;
                }
                this.subject.delete(string2);
                break;
            }
            case 7: {
                if (string2 == null) {
                    this.pubKey = null;
                    break;
                }
                this.pubKey.delete(string2);
                break;
            }
            case 8: {
                if (string2 == null) {
                    this.issuerUniqueId = null;
                    break;
                }
                this.issuerUniqueId.delete(string2);
                break;
            }
            case 9: {
                if (string2 == null) {
                    this.subjectUniqueId = null;
                    break;
                }
                this.subjectUniqueId.delete(string2);
                break;
            }
            case 10: {
                if (string2 == null) {
                    this.extensions = null;
                    break;
                }
                if (this.extensions == null) break;
                this.extensions.delete(string2);
            }
        }
    }

    @Override
    public Object get(String string) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            throw new CertificateParsingException("Attribute name not recognized: " + string);
        }
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 10: {
                if (string2 == null) {
                    return this.extensions;
                }
                if (this.extensions == null) {
                    return null;
                }
                return this.extensions.get(string2);
            }
            case 6: {
                if (string2 == null) {
                    return this.subject;
                }
                return this.subject.get(string2);
            }
            case 4: {
                if (string2 == null) {
                    return this.issuer;
                }
                return this.issuer.get(string2);
            }
            case 7: {
                if (string2 == null) {
                    return this.pubKey;
                }
                return this.pubKey.get(string2);
            }
            case 3: {
                if (string2 == null) {
                    return this.algId;
                }
                return this.algId.get(string2);
            }
            case 5: {
                if (string2 == null) {
                    return this.interval;
                }
                return this.interval.get(string2);
            }
            case 1: {
                if (string2 == null) {
                    return this.version;
                }
                return this.version.get(string2);
            }
            case 2: {
                if (string2 == null) {
                    return this.serialNum;
                }
                return this.serialNum.get(string2);
            }
            case 8: {
                if (string2 == null) {
                    return this.issuerUniqueId;
                }
                if (this.issuerUniqueId == null) {
                    return null;
                }
                return this.issuerUniqueId.get(string2);
            }
            case 9: {
                if (string2 == null) {
                    return this.subjectUniqueId;
                }
                if (this.subjectUniqueId == null) {
                    return null;
                }
                return this.subjectUniqueId.get(string2);
            }
        }
        return null;
    }

    private void parse(DerValue derValue) throws CertificateParsingException, IOException {
        if (derValue.tag != 48) {
            throw new CertificateParsingException("signed fields invalid");
        }
        this.rawCertInfo = derValue.toByteArray();
        DerInputStream derInputStream = derValue.data;
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)0)) {
            this.version = new CertificateVersion(derValue2);
            derValue2 = derInputStream.getDerValue();
        }
        this.serialNum = new CertificateSerialNumber(derValue2);
        this.algId = new CertificateAlgorithmId(derInputStream);
        this.issuer = new CertificateIssuerName(derInputStream);
        X500Name x500Name = (X500Name)this.issuer.get("dname");
        if (x500Name.isEmpty()) {
            throw new CertificateParsingException("Empty issuer DN not allowed in X509Certificates");
        }
        this.interval = new CertificateValidity(derInputStream);
        this.subject = new CertificateSubjectName(derInputStream);
        X500Name x500Name2 = (X500Name)this.subject.get("dname");
        if (this.version.compare(0) == 0 && x500Name2.isEmpty()) {
            throw new CertificateParsingException("Empty subject DN not allowed in v1 certificate");
        }
        this.pubKey = new CertificateX509Key(derInputStream);
        if (derInputStream.available() != 0) {
            if (this.version.compare(0) == 0) {
                throw new CertificateParsingException("no more data allowed for version 1 certificate");
            }
        } else {
            return;
        }
        derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)1)) {
            this.issuerUniqueId = new CertificateIssuerUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (derValue2.isContextSpecific((byte)2)) {
            this.subjectUniqueId = new CertificateSubjectUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (this.version.compare(2) != 0) {
            throw new CertificateParsingException("Extensions not allowed in v2 certificate");
        }
        if (derValue2.isConstructed() && derValue2.isContextSpecific((byte)3)) {
            this.extensions = new CertificateExtensions(derValue2.data);
        }
        this.verifyCert(this.subject, this.extensions);
    }

    private void verifyCert(CertificateSubjectName certificateSubjectName, CertificateExtensions certificateExtensions) throws CertificateParsingException, IOException {
        X500Name x500Name = (X500Name)certificateSubjectName.get("dname");
        if (x500Name.isEmpty()) {
            if (certificateExtensions == null) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and certificate has no extensions");
            }
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = null;
            Object var5_5 = null;
            GeneralNames generalNames = null;
            try {
                subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)certificateExtensions.get("SubjectAlternativeName");
                generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
            }
            catch (IOException iOException) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is absent");
            }
            if (generalNames == null || generalNames.isEmpty()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is empty");
            }
            if (!subjectAlternativeNameExtension.isCritical()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: SubjectAlternativeName extension MUST be marked critical when subject field is empty");
            }
        }
    }

    private void emit(DerOutputStream derOutputStream) throws CertificateException, IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.version.encode(derOutputStream2);
        this.serialNum.encode(derOutputStream2);
        this.algId.encode(derOutputStream2);
        if (this.version.compare(0) == 0 && this.issuer.toString() == null) {
            throw new CertificateParsingException("Null issuer DN not allowed in v1 certificate");
        }
        this.issuer.encode(derOutputStream2);
        this.interval.encode(derOutputStream2);
        if (this.version.compare(0) == 0 && this.subject.toString() == null) {
            throw new CertificateParsingException("Null subject DN not allowed in v1 certificate");
        }
        this.subject.encode(derOutputStream2);
        this.pubKey.encode(derOutputStream2);
        if (this.issuerUniqueId != null) {
            this.issuerUniqueId.encode(derOutputStream2);
        }
        if (this.subjectUniqueId != null) {
            this.subjectUniqueId.encode(derOutputStream2);
        }
        if (this.extensions != null) {
            this.extensions.encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    private int attributeMap(String string) {
        Integer n = map.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private void setVersion(Object object) throws CertificateException {
        if (!(object instanceof CertificateVersion)) {
            throw new CertificateException("Version class type invalid.");
        }
        this.version = (CertificateVersion)object;
    }

    private void setSerialNumber(Object object) throws CertificateException {
        if (!(object instanceof CertificateSerialNumber)) {
            throw new CertificateException("SerialNumber class type invalid.");
        }
        this.serialNum = (CertificateSerialNumber)object;
    }

    private void setAlgorithmId(Object object) throws CertificateException {
        if (!(object instanceof CertificateAlgorithmId)) {
            throw new CertificateException("AlgorithmId class type invalid.");
        }
        this.algId = (CertificateAlgorithmId)object;
    }

    private void setIssuer(Object object) throws CertificateException {
        if (!(object instanceof CertificateIssuerName)) {
            throw new CertificateException("Issuer class type invalid.");
        }
        this.issuer = (CertificateIssuerName)object;
    }

    private void setValidity(Object object) throws CertificateException {
        if (!(object instanceof CertificateValidity)) {
            throw new CertificateException("CertificateValidity class type invalid.");
        }
        this.interval = (CertificateValidity)object;
    }

    private void setSubject(Object object) throws CertificateException {
        if (!(object instanceof CertificateSubjectName)) {
            throw new CertificateException("Subject class type invalid.");
        }
        this.subject = (CertificateSubjectName)object;
    }

    private void setKey(Object object) throws CertificateException {
        if (!(object instanceof CertificateX509Key)) {
            throw new CertificateException("Key class type invalid.");
        }
        this.pubKey = (CertificateX509Key)object;
    }

    private void setIssuerUniqueId(Object object) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateIssuerUniqueIdentity)) {
            throw new CertificateException("IssuerUniqueId class type invalid.");
        }
        this.issuerUniqueId = (CertificateIssuerUniqueIdentity)object;
    }

    private void setSubjectUniqueId(Object object) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateSubjectUniqueIdentity)) {
            throw new CertificateException("SubjectUniqueId class type invalid.");
        }
        this.subjectUniqueId = (CertificateSubjectUniqueIdentity)object;
    }

    private void setExtensions(Object object) throws CertificateException {
        if (this.version.compare(2) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(object instanceof CertificateExtensions)) {
            throw new CertificateException("Extensions class type invalid.");
        }
        this.extensions = (CertificateExtensions)object;
    }

    static {
        map.put(VERSION, 1);
        map.put(SERIAL_NUMBER, 2);
        map.put(ALGORITHM_ID, 3);
        map.put(ISSUER, 4);
        map.put(VALIDITY, 5);
        map.put(SUBJECT, 6);
        map.put(KEY, 7);
        map.put(ISSUER_ID, 8);
        map.put(SUBJECT_ID, 9);
        map.put(EXTENSIONS, 10);
    }
}

