/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIServerSocketFactory;

public final class LocalRMIServerSocketFactory
implements RMIServerSocketFactory {
    public ServerSocket createServerSocket(int n) throws IOException {
        return new ServerSocket(n){

            public Socket accept() throws IOException {
                Socket socket = super.accept();
                InetAddress inetAddress = socket.getInetAddress();
                try {
                    if (inetAddress.isAnyLocalAddress()) {
                        throw new IOException("The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.");
                    }
                    new ServerSocket(0, 10, inetAddress).close();
                    return socket;
                }
                catch (IOException iOException) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    throw (IOException)new IOException("The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.").initCause(iOException);
                }
            }
        };
    }

    public boolean equals(Object object) {
        return object instanceof LocalRMIServerSocketFactory;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

