/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc.ee;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.PooledConnection;
import sun.jdbc.odbc.ee.CommonDataSource;
import sun.jdbc.odbc.ee.ConnectionAttributes;
import sun.jdbc.odbc.ee.ConnectionPool;
import sun.jdbc.odbc.ee.ConnectionPoolFactory;
import sun.jdbc.odbc.ee.PoolProperties;

public class ConnectionPoolDataSource
extends CommonDataSource
implements javax.sql.ConnectionPoolDataSource {
    private int maxStatements;
    private int initialPoolSize;
    private int minPoolSize;
    private int maxPoolSize;
    private int maxIdleTime;
    private int propertyCycle;
    private int timeoutFromPool;
    private int mInterval;
    private boolean shutdown = false;
    static final long serialVersionUID = 8730440750011279189L;

    public ConnectionPoolDataSource() {
    }

    public ConnectionPoolDataSource(String string) {
        super.setDataSourceName(string);
    }

    public Connection getConnection() throws SQLException {
        return this.getPooledConnection().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getPooledConnection(string, string2).getConnection();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return (PooledConnection)((Object)this.getPool().checkOut());
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        Properties properties = super.getAttributes().getProperties();
        properties.put("user", string);
        properties.put("password", string2);
        return (PooledConnection)((Object)this.getPool().checkOut(properties));
    }

    public void setMaxStatements(String string) throws SQLException {
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setInitialPoolSize(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("Initial pool size cannot be null");
        }
        try {
            this.initialPoolSize = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Initial pool size is not a number ");
        }
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setMaxPoolSize(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("Max pool size cannot be null");
        }
        try {
            this.maxPoolSize = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Max pool size is not a number ");
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMinPoolSize(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("Min pool size cannot be null");
        }
        try {
            this.minPoolSize = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Min pool size is not a number ");
        }
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMaxIdleTime(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("Idle time cannot be null");
        }
        try {
            this.maxIdleTime = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Max Idle time is not a number ");
        }
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setPropertyCycle(String string) {
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public void setTimeoutFromPool(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("timeout cannot be null");
        }
        try {
            this.timeoutFromPool = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Timeout is not a number ");
        }
    }

    public int getTimeoutFromPool() {
        return this.timeoutFromPool;
    }

    public void setMaintenanceInterval(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("Maintenance interval cannot be null");
        }
        try {
            this.mInterval = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Maintenance interval is not a number ");
        }
    }

    public int getMaintenanceInterval() {
        return this.mInterval;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "sun.jdbc.odbc.ee.ObjectFactory", null);
        reference.add(new StringRefAddr("databaseName", super.getDatabaseName()));
        reference.add(new StringRefAddr("dataSourceName", super.getDataSourceName()));
        ConnectionAttributes connectionAttributes = super.getAttributes();
        reference.add(new StringRefAddr("user", connectionAttributes.getUser()));
        reference.add(new StringRefAddr("password", connectionAttributes.getPassword()));
        reference.add(new StringRefAddr("charSet", connectionAttributes.getCharSet()));
        reference.add(new StringRefAddr("loginTimeout", "" + super.getLoginTimeout()));
        reference.add(new StringRefAddr("maxStatements", "" + this.maxStatements));
        reference.add(new StringRefAddr("initialPoolSize", "" + this.initialPoolSize));
        reference.add(new StringRefAddr("maxPoolSize", "" + this.maxPoolSize));
        reference.add(new StringRefAddr("minPoolSize", "" + this.minPoolSize));
        reference.add(new StringRefAddr("maxIdleTime", "" + this.maxIdleTime));
        reference.add(new StringRefAddr("propertyCycle", "" + this.propertyCycle));
        reference.add(new StringRefAddr("timeoutFromPool", "" + this.timeoutFromPool));
        reference.add(new StringRefAddr("mInterval", "" + this.mInterval));
        return reference;
    }

    public void shutDown(boolean bl) {
        ConnectionPool connectionPool = ConnectionPoolFactory.obtainConnectionPool(this.getDataSourceName());
        connectionPool.shutDown(bl);
        this.shutdown = true;
    }

    private ConnectionPool getPool() throws SQLException {
        if (this.shutdown) {
            throw new SQLException("Pool is shutdown!");
        }
        ConnectionPool connectionPool = ConnectionPoolFactory.obtainConnectionPool(super.getDataSourceName());
        connectionPool.setTracer(super.getTracer());
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.set("initialPoolSize", this.initialPoolSize);
        poolProperties.set("maxPoolSize", this.maxPoolSize);
        poolProperties.set("minPoolSize", this.minPoolSize);
        poolProperties.set("maxIdleTime", this.maxIdleTime);
        poolProperties.set("timeOutFromPool", this.timeoutFromPool);
        poolProperties.set("mInterval", this.mInterval);
        connectionPool.setProperties(poolProperties);
        connectionPool.setConnectionDetails(super.getAttributes().getProperties());
        connectionPool.initializePool();
        return connectionPool;
    }
}

