/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import sun.font.CharToGlyphMapper;
import sun.font.FileFont;
import sun.font.FontManager;
import sun.font.NativeFont;
import sun.font.TrueTypeGlyphMapper;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public class TrueTypeFont
extends FileFont {
    public static final int cmapTag = 1668112752;
    public static final int glyfTag = 1735162214;
    public static final int headTag = 1751474532;
    public static final int hheaTag = 1751672161;
    public static final int hmtxTag = 1752003704;
    public static final int locaTag = 1819239265;
    public static final int maxpTag = 1835104368;
    public static final int nameTag = 1851878757;
    public static final int postTag = 1886352244;
    public static final int os_2Tag = 1330851634;
    public static final int GDEFTag = 1195656518;
    public static final int GPOSTag = 1196445523;
    public static final int GSUBTag = 1196643650;
    public static final int mortTag = 1836020340;
    public static final int fdscTag = 1717859171;
    public static final int fvarTag = 1719034226;
    public static final int featTag = 1717920116;
    public static final int EBLCTag = 1161972803;
    public static final int ttcfTag = 1953784678;
    public static final int v1ttTag = 65536;
    public static final int trueTag = 1953658213;
    public static final int MS_PLATFORM_ID = 3;
    public static final short ENGLISH_LOCALE_ID = 1033;
    public static final int FAMILY_NAME_ID = 1;
    public static final int FULL_NAME_ID = 4;
    public static final int POSTSCRIPT_NAME_ID = 6;
    TTDisposerRecord disposerRecord = new TTDisposerRecord();
    int fontIndex = 0;
    int directoryCount = 1;
    int directoryOffset;
    int numTables;
    DirectoryEntry[] tableDirectory;
    private static final int TTCHEADERSIZE = 12;
    private static final int DIRECTORYHEADERSIZE = 12;
    private static final int DIRECTORYENTRYSIZE = 16;
    static final String[] encoding_mapping = new String[]{"cp1252", "cp1250", "cp1251", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "", "", "", "", "", "", "", "", "ms874", "ms932", "gbk", "ms949", "ms950", "ms1361", "", "", "", "", "", "", "", "", "", ""};
    public static final int reserved_bits1 = Integer.MIN_VALUE;
    public static final int reserved_bits2 = 65535;
    private static final int fsSelectionItalicBit = 1;
    private static final int fsSelectionBoldBit = 32;
    private static final int fsSelectionRegularBit = 64;

    TrueTypeFont(String string, Object object, int n, boolean bl) throws FontFormatException {
        super(string, object);
        this.useJavaRasterizer = bl;
        this.fontRank = 3;
        try {
            this.verify();
            this.init(n);
        }
        catch (Throwable throwable) {
            this.close();
            if (throwable instanceof FontFormatException) {
                throw (FontFormatException)throwable;
            }
            throw new FontFormatException("Unexpected runtime exception.");
        }
        Disposer.addObjectRecord(this, this.disposerRecord);
    }

    protected void checkUseNatives() {
        this.checkedNatives = true;
        if (!FontManager.isSolaris || this.useJavaRasterizer || FontManager.useT2K || this.nativeNames == null || this.getDirectoryEntry(1161972803) != null || GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (this.nativeNames instanceof String) {
            String string = (String)this.nativeNames;
            if (string.indexOf("8859") > 0) {
                return;
            }
            if (NativeFont.hasExternalBitmaps(string)) {
                this.nativeFonts = new NativeFont[1];
                try {
                    this.nativeFonts[0] = new NativeFont(string, true);
                    this.useNatives = true;
                }
                catch (FontFormatException fontFormatException) {
                    this.nativeFonts = null;
                }
            }
        } else if (this.nativeNames instanceof String[]) {
            int n;
            String[] stringArray = (String[])this.nativeNames;
            int n2 = stringArray.length;
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                if (stringArray[n].indexOf("8859") > 0) {
                    return;
                }
                if (!NativeFont.hasExternalBitmaps(stringArray[n])) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.useNatives = true;
            this.nativeFonts = new NativeFont[n2];
            for (n = 0; n < n2; ++n) {
                try {
                    this.nativeFonts[n] = new NativeFont(stringArray[n], true);
                    continue;
                }
                catch (FontFormatException fontFormatException) {
                    this.useNatives = false;
                    this.nativeFonts = null;
                }
            }
        }
        if (this.useNatives) {
            this.glyphToCharMap = new char[this.getMapper().getNumGlyphs()];
        }
    }

    private synchronized FileChannel open() throws FontFormatException {
        if (this.disposerRecord.channel == null) {
            try {
                RandomAccessFile randomAccessFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return new RandomAccessFile(TrueTypeFont.this.platName, "r");
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return null;
                        }
                    }
                });
                this.disposerRecord.channel = randomAccessFile.getChannel();
                this.fileSize = (int)this.disposerRecord.channel.size();
                FontManager.addToPool(this);
            }
            catch (NullPointerException nullPointerException) {
                this.close();
                throw new FontFormatException(nullPointerException.toString());
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                this.close();
                this.open();
            }
            catch (IOException iOException) {
                this.close();
                throw new FontFormatException(iOException.toString());
            }
        }
        return this.disposerRecord.channel;
    }

    protected synchronized void close() {
        this.disposerRecord.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readBlock(ByteBuffer byteBuffer, int n, int n2) {
        int n3;
        block21: {
            n3 = 0;
            try {
                TrueTypeFont trueTypeFont = this;
                synchronized (trueTypeFont) {
                    if (this.disposerRecord.channel == null) {
                        this.open();
                    }
                    if (n + n2 > this.fileSize) {
                        if (n >= this.fileSize) {
                            if (FontManager.logging) {
                                String string = "Read offset is " + n + " file size is " + this.fileSize + " file is " + this.platName;
                                FontManager.logger.severe(string);
                            }
                            return -1;
                        }
                        n2 = this.fileSize - n;
                    }
                    byteBuffer.clear();
                    this.disposerRecord.channel.position(n);
                    while (n3 < n2) {
                        int n4 = this.disposerRecord.channel.read(byteBuffer);
                        if (n4 == -1) {
                            String string = "Unexpected EOF " + this;
                            int n5 = (int)this.disposerRecord.channel.size();
                            if (n5 != this.fileSize) {
                                string = string + " File size was " + this.fileSize + " and now is " + n5;
                            }
                            if (FontManager.logging) {
                                FontManager.logger.severe(string);
                            }
                            if (n3 > n2 / 2 || n3 > 16384) {
                                byteBuffer.flip();
                                if (FontManager.logging) {
                                    string = "Returning " + n3 + " bytes instead of " + n2;
                                    FontManager.logger.severe(string);
                                }
                            } else {
                                n3 = -1;
                            }
                            throw new IOException(string);
                        }
                        n3 += n4;
                    }
                    byteBuffer.flip();
                    if (n3 > n2) {
                        n3 = n2;
                    }
                }
            }
            catch (FontFormatException fontFormatException) {
                fontFormatException.printStackTrace();
                if (FontManager.logging) {
                    FontManager.logger.log(Level.SEVERE, "While reading " + this.platName, fontFormatException);
                }
                n3 = -1;
                this.deregisterFontAndClearStrikeCache();
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                this.close();
                return this.readBlock(byteBuffer, n, n2);
            }
            catch (IOException iOException) {
                if (FontManager.logging) {
                    FontManager.logger.log(Level.SEVERE, "While reading " + this.platName, iOException);
                }
                if (n3 != 0) break block21;
                n3 = -1;
                this.deregisterFontAndClearStrikeCache();
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer readBlock(int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        try {
            TrueTypeFont trueTypeFont = this;
            synchronized (trueTypeFont) {
                if (this.disposerRecord.channel == null) {
                    this.open();
                }
                if (n + n2 > this.fileSize) {
                    if (n > this.fileSize) {
                        return null;
                    }
                    byteBuffer = ByteBuffer.allocate(this.fileSize - n);
                }
                this.disposerRecord.channel.position(n);
                this.disposerRecord.channel.read(byteBuffer);
                byteBuffer.flip();
            }
        }
        catch (FontFormatException fontFormatException) {
            return null;
        }
        catch (ClosedChannelException closedChannelException) {
            Thread.interrupted();
            this.close();
            this.readBlock(byteBuffer, n, n2);
        }
        catch (IOException iOException) {
            return null;
        }
        return byteBuffer;
    }

    byte[] readBytes(int n, int n2) {
        ByteBuffer byteBuffer = this.readBlock(n, n2);
        if (byteBuffer.hasArray()) {
            return byteBuffer.array();
        }
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    private void verify() throws FontFormatException {
        this.open();
    }

    protected void init(int n) throws FontFormatException {
        int n2 = 0;
        ByteBuffer byteBuffer = this.readBlock(0, 12);
        try {
            switch (byteBuffer.getInt()) {
                case 1953784678: {
                    byteBuffer.getInt();
                    this.directoryCount = byteBuffer.getInt();
                    if (n >= this.directoryCount) {
                        throw new FontFormatException("Bad collection index");
                    }
                    this.fontIndex = n;
                    byteBuffer = this.readBlock(12 + 4 * n, 4);
                    n2 = byteBuffer.getInt();
                    break;
                }
                case 65536: 
                case 1953658213: {
                    break;
                }
                default: {
                    throw new FontFormatException("Unsupported sfnt " + this.platName);
                }
            }
            byteBuffer = this.readBlock(n2 + 4, 2);
            this.numTables = byteBuffer.getShort();
            this.directoryOffset = n2 + 12;
            ByteBuffer byteBuffer2 = this.readBlock(this.directoryOffset, this.numTables * 16);
            IntBuffer intBuffer = byteBuffer2.asIntBuffer();
            this.tableDirectory = new DirectoryEntry[this.numTables];
            for (int i = 0; i < this.numTables; ++i) {
                DirectoryEntry directoryEntry;
                this.tableDirectory[i] = directoryEntry = new DirectoryEntry();
                directoryEntry.tag = intBuffer.get();
                intBuffer.get();
                directoryEntry.offset = intBuffer.get();
                directoryEntry.length = intBuffer.get();
                if (directoryEntry.offset + directoryEntry.length <= this.fileSize) continue;
                throw new FontFormatException("bad table, tag=" + directoryEntry.tag);
            }
            this.initNames();
        }
        catch (Exception exception) {
            if (FontManager.logging) {
                FontManager.logger.severe(exception.toString());
            }
            if (exception instanceof FontFormatException) {
                throw (FontFormatException)exception;
            }
            throw new FontFormatException(exception.toString());
        }
        if (this.familyName == null || this.fullName == null) {
            throw new FontFormatException("Font name not found");
        }
        this.setStyle();
    }

    boolean supportsEncoding(String string) {
        int n;
        ByteBuffer byteBuffer = this.getTableBuffer(1330851634);
        if (byteBuffer == null || byteBuffer.capacity() < 86) {
            return false;
        }
        int n2 = byteBuffer.getInt(78);
        if ((n2 & Integer.MIN_VALUE | (n = byteBuffer.getInt(82)) & 0xFFFF) != 0) {
            return false;
        }
        for (int i = 0; i < encoding_mapping.length; ++i) {
            if (!encoding_mapping[i].equals(string) || (1 << i & n2) == 0) continue;
            return true;
        }
        return false;
    }

    boolean supportsJA() {
        ByteBuffer byteBuffer = this.getTableBuffer(1330851634);
        if (byteBuffer == null || byteBuffer.capacity() < 50) {
            return false;
        }
        int n = byteBuffer.getInt(46);
        return (n & 0x60000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getTableBuffer(int n) {
        int n2;
        DirectoryEntry directoryEntry = null;
        for (n2 = 0; n2 < this.numTables; ++n2) {
            if (this.tableDirectory[n2].tag != n) continue;
            directoryEntry = this.tableDirectory[n2];
            break;
        }
        if (directoryEntry == null || directoryEntry.length == 0 || directoryEntry.offset + directoryEntry.length > this.fileSize) {
            return null;
        }
        n2 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(directoryEntry.length);
        TrueTypeFont trueTypeFont = this;
        synchronized (trueTypeFont) {
            try {
                if (this.disposerRecord.channel == null) {
                    this.open();
                }
                this.disposerRecord.channel.position(directoryEntry.offset);
                n2 = this.disposerRecord.channel.read(byteBuffer);
                byteBuffer.flip();
            }
            catch (ClosedChannelException closedChannelException) {
                Thread.interrupted();
                this.close();
                return this.getTableBuffer(n);
            }
            catch (IOException iOException) {
                return null;
            }
            catch (FontFormatException fontFormatException) {
                return null;
            }
            if (n2 < directoryEntry.length) {
                return null;
            }
            return byteBuffer;
        }
    }

    byte[] getTableBytes(int n) {
        ByteBuffer byteBuffer = this.getTableBuffer(n);
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.hasArray()) {
            try {
                return byteBuffer.array();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray = new byte[this.getTableSize(n)];
        byteBuffer.get(byArray);
        return byArray;
    }

    int getTableSize(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i].length;
        }
        return 0;
    }

    int getTableOffset(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i].offset;
        }
        return 0;
    }

    DirectoryEntry getDirectoryEntry(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i];
        }
        return null;
    }

    public String getFullName() {
        return this.fullName;
    }

    protected void setStyle() {
        ByteBuffer byteBuffer = this.getTableBuffer(1330851634);
        if (byteBuffer == null || byteBuffer.capacity() < 64) {
            super.setStyle();
            return;
        }
        int n = byteBuffer.getChar(62) & 0xFFFF;
        int n2 = n & 1;
        int n3 = n & 0x20;
        int n4 = n & 0x40;
        if (n4 != 0 && (n2 | n3) != 0) {
            super.setStyle();
            return;
        }
        if ((n4 | n2 | n3) == 0) {
            super.setStyle();
            return;
        }
        switch (n3 | n2) {
            case 1: {
                this.style = 2;
                break;
            }
            case 32: {
                if (FontManager.isSolaris && this.platName.endsWith("HG-GothicB.ttf")) {
                    this.style = 0;
                    break;
                }
                this.style = 1;
                break;
            }
            case 33: {
                this.style = 3;
            }
        }
    }

    private String makeString(byte[] byArray, short n, short s) {
        Object object;
        if (s >= 2 && s <= 6) {
            object = byArray;
            int n2 = n;
            byArray = new byte[n2];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (object[i] == false) continue;
                int n3 = n;
                n = (short)(n + 1);
                byArray[n3] = (byte)object[i];
            }
        }
        switch (s) {
            case 1: {
                object = "UTF-16";
                break;
            }
            case 0: {
                object = "UTF-16";
                break;
            }
            case 2: {
                object = "SJIS";
                break;
            }
            case 3: {
                object = "GBK";
                break;
            }
            case 4: {
                object = "MS950";
                break;
            }
            case 5: {
                object = "EUC_KR";
                break;
            }
            case 6: {
                object = "Johab";
                break;
            }
            default: {
                object = "UTF-16";
            }
        }
        try {
            return new String(byArray, 0, n, (String)object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (FontManager.logging) {
                FontManager.logger.warning(unsupportedEncodingException + " EncodingID=" + s);
            }
            return new String(byArray, 0, n);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void initNames() {
        byte[] byArray = new byte[256];
        ByteBuffer byteBuffer = this.getTableBuffer(1851878757);
        if (byteBuffer != null) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get();
            int n = shortBuffer.get();
            short s = shortBuffer.get();
            block4: for (int i = 0; i < n; ++i) {
                short s2 = shortBuffer.get();
                if (s2 != 3) {
                    shortBuffer.position(shortBuffer.position() + 5);
                    continue;
                }
                short s3 = shortBuffer.get();
                short s4 = shortBuffer.get();
                short s5 = shortBuffer.get();
                short s6 = shortBuffer.get();
                short s7 = (short)(shortBuffer.get() + s);
                switch (s5) {
                    case 1: {
                        if (this.familyName != null && s4 != 1033) continue block4;
                        byteBuffer.position(s7);
                        byteBuffer.get(byArray, 0, s6);
                        this.familyName = this.makeString(byArray, s6, s3);
                        continue block4;
                    }
                    case 4: {
                        if (this.fullName != null && s4 != 1033) continue block4;
                        byteBuffer.position(s7);
                        byteBuffer.get(byArray, 0, s6);
                        this.fullName = this.makeString(byArray, s6, s3);
                    }
                }
            }
        }
    }

    protected String lookupName(short s, int n) {
        String string = null;
        byte[] byArray = new byte[1024];
        ByteBuffer byteBuffer = this.getTableBuffer(1851878757);
        if (byteBuffer != null) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get();
            int n2 = shortBuffer.get();
            short s2 = shortBuffer.get();
            for (int i = 0; i < n2; ++i) {
                short s3 = shortBuffer.get();
                if (s3 != 3) {
                    shortBuffer.position(shortBuffer.position() + 5);
                    continue;
                }
                short s4 = shortBuffer.get();
                short s5 = shortBuffer.get();
                short s6 = shortBuffer.get();
                short s7 = shortBuffer.get();
                short s8 = (short)(shortBuffer.get() + s2);
                if (s6 != n || (string != null || s5 != 1033) && s5 != s) continue;
                byteBuffer.position(s8);
                byteBuffer.get(byArray, 0, s7);
                string = this.makeString(byArray, s7, s4);
                if (s5 != s) continue;
                return string;
            }
        }
        return string;
    }

    public int getFontCount() {
        return this.directoryCount;
    }

    private native long createScaler(int var1, int var2);

    protected synchronized long getScaler() {
        if (this.pScaler == 0L) {
            this.pScaler = this.createScaler(this.fileSize, this.fontIndex);
            if (this.pScaler != 0L) {
                Disposer.addObjectRecord(this, new FileFont.FileFontDisposer(this.pScaler));
            } else {
                this.pScaler = TrueTypeFont.getNullScaler();
                FontManager.deRegisterBadFont(this);
            }
        }
        return this.pScaler;
    }

    public String getPostscriptName() {
        String string = this.lookupName((short)1033, 6);
        if (string == null) {
            return this.fullName;
        }
        return string;
    }

    public String getFontName(Locale locale) {
        if (locale == null) {
            return this.fullName;
        }
        short s = FontManager.getLCIDFromLocale(locale);
        String string = this.lookupName(s, 4);
        if (string == null) {
            return this.fullName;
        }
        return string;
    }

    public String getFamilyName(Locale locale) {
        if (locale == null) {
            return this.familyName;
        }
        short s = FontManager.getLCIDFromLocale(locale);
        String string = this.lookupName(s, 1);
        if (string == null) {
            return this.familyName;
        }
        return string;
    }

    public CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new TrueTypeGlyphMapper(this);
        }
        return this.mapper;
    }

    protected void initAllNames(int n, HashSet hashSet) {
        byte[] byArray = new byte[256];
        ByteBuffer byteBuffer = this.getTableBuffer(1851878757);
        if (byteBuffer != null) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get();
            int n2 = shortBuffer.get();
            short s = shortBuffer.get();
            for (int i = 0; i < n2; ++i) {
                short s2 = shortBuffer.get();
                if (s2 != 3) {
                    shortBuffer.position(shortBuffer.position() + 5);
                    continue;
                }
                short s3 = shortBuffer.get();
                short s4 = shortBuffer.get();
                short s5 = shortBuffer.get();
                short s6 = shortBuffer.get();
                short s7 = (short)(shortBuffer.get() + s);
                if (s5 != n) continue;
                byteBuffer.position(s7);
                byteBuffer.get(byArray, 0, s6);
                hashSet.add(this.makeString(byArray, s6, s3));
            }
        }
    }

    String[] getAllFamilyNames() {
        HashSet hashSet = new HashSet();
        try {
            this.initAllNames(1, hashSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet.toArray(new String[0]);
    }

    String[] getAllFullNames() {
        HashSet hashSet = new HashSet();
        try {
            this.initAllNames(4, hashSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet.toArray(new String[0]);
    }

    synchronized native Point2D.Float getGlyphPoint(long var1, int var3, int var4);

    public String toString() {
        return "** TrueType Font: Family=" + this.familyName + " Name=" + this.fullName + " style=" + this.style + " fileName=" + this.platName;
    }

    class DirectoryEntry {
        int tag;
        int offset;
        int length;

        DirectoryEntry() {
        }
    }

    private static class TTDisposerRecord
    extends DisposerRecord {
        FileChannel channel = null;

        private TTDisposerRecord() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void dispose() {
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.channel = null;
            }
        }
    }
}

