/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;
import sun.awt.DisplayChangedListener;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.WindowsFlags;
import sun.awt.image.CachingSurfaceManager;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.awt.windows.Win32SurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;

public class WinCachingSurfaceManager
extends CachingSurfaceManager
implements DisplayChangedListener {
    private static final int MAX_SIZE = 65536;
    private static final int ICM_HISTOGRAM_SIZE = 256;
    private static final int ICM_HISTOGRAM_MASK = 255;
    private static final int DCM_HISTOGRAM_SIZE = 1024;
    private static final int DCM_HISTOGRAM_MASK = 1023;
    private int transparency;
    private Color transColor;
    private int timesTried = 0;

    public WinCachingSurfaceManager(BufferedImage bufferedImage) {
        super(bufferedImage);
        Object object;
        ColorModel colorModel = bufferedImage.getColorModel();
        this.transparency = colorModel.getTransparency();
        if (this.localAccelerationEnabled) {
            this.localAccelerationEnabled = this.isValidColorModel(colorModel);
        }
        if (accelerationThreshold == 0 && this.localAccelerationEnabled) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.initAcceleratedSurface((GraphicsConfiguration)object, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (accelerationEnabled && this.localAccelerationEnabled && object instanceof Win32GraphicsEnvironment) {
            ((Win32GraphicsEnvironment)object).addDisplayChangedListener(this);
        }
    }

    private boolean isValidColorModel(ColorModel colorModel) {
        if (this.transparency == 1) {
            return true;
        }
        if (this.transparency == 2) {
            if (colorModel instanceof IndexColorModel) {
                return true;
            }
            return colorModel instanceof DirectColorModel && colorModel.getPixelSize() == 25 && colorModel.getTransferType() == 3 && this.bImg.getWidth() * this.bImg.getHeight() <= 65536;
        }
        return WindowsFlags.isTranslucentAccelerationEnabled();
    }

    private boolean isValidDeviceColorModel(ColorModel colorModel) {
        if (this.transparency == 1) {
            return true;
        }
        if (this.transparency == 2) {
            return colorModel.getPixelSize() != 8;
        }
        return Win32GraphicsConfig.getTranslucentColorModel().equals(colorModel);
    }

    protected SurfaceData getAccelSurface(GraphicsConfiguration graphicsConfiguration) {
        return this.accelSurfaces != null ? (SurfaceData)this.accelSurfaces.get(graphicsConfiguration.getDevice()) : null;
    }

    protected boolean isDestSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof Win32OffScreenSurfaceData && !((Win32OffScreenSurfaceData)surfaceData).surfacePunted() || surfaceData instanceof Win32SurfaceData;
    }

    protected boolean isOperationSupported(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        if (this.transparency == 1) {
            if (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType)) {
                return !bl || Win32OffScreenSurfaceData.isDDScaleEnabled();
            }
        } else if (this.transparency == 3 ? (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcOver.equals(compositeType)) && color == null : CompositeType.SrcOverNoEa.equals(compositeType) && color == null && surfaceData.getTransparency() != 3) {
            return !bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAcceleratedSurface(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        WinCachingSurfaceManager winCachingSurfaceManager = this;
        synchronized (winCachingSurfaceManager) {
            try {
                ColorModel colorModel;
                this.sdAccel = this.getAccelSurface(graphicsConfiguration);
                if (this.sdAccel == null && this.isValidDeviceColorModel(colorModel = this.transparency == 3 ? this.bImg.getColorModel() : ((Win32GraphicsConfig)graphicsConfiguration).getDeviceColorModel())) {
                    this.sdAccel = Win32OffScreenSurfaceData.createData(n, n2, colorModel, graphicsConfiguration, this.bImg, this.transparency);
                    if (this.sdAccel != null) {
                        this.accelSurfaces.put(graphicsConfiguration.getDevice(), this.sdAccel);
                    }
                }
            }
            catch (InvalidPipeException invalidPipeException) {
                this.sdAccel = null;
            }
            if (this.sdAccel == null) {
                if (this.timesTried++ > 3) {
                    this.localAccelerationEnabled = false;
                }
            } else {
                this.timesTried = 0;
            }
            if (this.sdAccel != null && this.transparency == 2 && this.getTransparentPixelColor() == null) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceData restoreContents() {
        if (accelerationEnabled) {
            WinCachingSurfaceManager winCachingSurfaceManager = this;
            synchronized (winCachingSurfaceManager) {
                if (this.sdAccel != null) {
                    this.validate(this.sdAccel.getDeviceConfiguration());
                }
            }
        }
        return super.restoreContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreAcceleratedSurface() {
        WinCachingSurfaceManager winCachingSurfaceManager = this;
        synchronized (winCachingSurfaceManager) {
            if (this.sdAccel != null) {
                ((Win32OffScreenSurfaceData)this.sdAccel).restoreSurface();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayChanged() {
        if (!accelerationEnabled) {
            return;
        }
        WinCachingSurfaceManager winCachingSurfaceManager = this;
        synchronized (winCachingSurfaceManager) {
            if (this.sdAccel != null) {
                Hashtable hashtable = this.accelSurfaces;
                this.sdAccel = null;
                this.accelSurfaces = new Hashtable();
                if (hashtable != null) {
                    Object[] objectArray = hashtable.values().toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((SurfaceData)objectArray[i]).invalidate();
                    }
                }
            }
        }
    }

    public void paletteChanged() {
        this.sdDefault.setNeedsBackup(true);
    }

    public synchronized void flush() {
        this.sdAccel = null;
        if (this.accelSurfaces != null) {
            Hashtable hashtable = this.accelSurfaces;
            this.accelSurfaces = new Hashtable();
            Object[] objectArray = hashtable.values().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Win32OffScreenSurfaceData)objectArray[i]).flush();
            }
        }
    }

    protected Color getTransparentPixelColor() {
        if (!this.localAccelerationEnabled || this.transparency != 2) {
            return null;
        }
        this.transColor = this.setupTransparentPixel();
        if (this.transColor == null) {
            this.localAccelerationEnabled = false;
        }
        return this.transColor;
    }

    protected Color setupTransparentPixel() {
        Color color = null;
        Integer n = null;
        ColorModel colorModel = this.bImg.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            n = this.findUnusedPixelICM();
        } else if (colorModel instanceof DirectColorModel) {
            n = this.findUnusedPixelDCM();
        }
        if (n != null) {
            int n2 = n;
            ((Win32OffScreenSurfaceData)this.sdAccel).setTransparentPixel(n2);
            int n3 = this.sdAccel.rgbFor(n2);
            color = new Color(n3);
        }
        return color;
    }

    private Integer findUnusedPixelICM() {
        int n;
        int n2;
        IndexColorModel indexColorModel = (IndexColorModel)this.bImg.getColorModel();
        int n3 = indexColorModel.getMapSize();
        int[] nArray = new int[256];
        int[] nArray2 = new int[n3];
        indexColorModel.getRGBs(nArray2);
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.sdAccel.pixelFor(nArray2[n2]);
            int n4 = n & 0xFF;
            nArray[n4] = nArray[n4] + 1;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n != 0) continue;
            return new Integer(n2);
        }
        return null;
    }

    private Integer findUnusedPixelDCM() {
        int n;
        int n2;
        DataBufferInt dataBufferInt = (DataBufferInt)this.bImg.getRaster().getDataBuffer();
        this.localAccelerationEnabled = true;
        int[] nArray = dataBufferInt.getData();
        int[] nArray2 = new int[1024];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = this.sdAccel.pixelFor(nArray[n2]);
            int n3 = n & 0x3FF;
            nArray2[n3] = nArray2[n3] + 1;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            n = nArray2[n2];
            if (n != 0) continue;
            return new Integer(n2);
        }
        return null;
    }

    public void acceleratedSurfaceLost() {
        throw new InvalidPipeException("Managed surface lost");
    }

    public String toString() {
        return new String("WinCachingSurfaceManager@" + Integer.toHexString(this.hashCode()) + " transparency: " + (this.transparency == 1 ? "OPAQUE" : (this.transparency == 2 ? "BITMASK" : "TRANSLUCENT")));
    }

    static {
        if (accelerationEnabled) {
            accelerationEnabled = WindowsFlags.isDDEnabled() && WindowsFlags.isDDOffscreenEnabled();
        }
    }
}

