/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalSliderUI
extends BasicSliderUI {
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    private int safeLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    private static Icon SAFE_HORIZ_THUMB_ICON;
    private static Icon SAFE_VERT_THUMB_ICON;
    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalSliderUI();
    }

    public MetalSliderUI() {
        super(null);
    }

    private static Icon getHorizThumbIcon() {
        if (System.getSecurityManager() != null) {
            return SAFE_HORIZ_THUMB_ICON;
        }
        return horizThumbIcon;
    }

    private static Icon getVertThumbIcon() {
        if (System.getSecurityManager() != null) {
            return SAFE_VERT_THUMB_ICON;
        }
        return vertThumbIcon;
    }

    public void installUI(JComponent jComponent) {
        trackWidth = (Integer)UIManager.get("Slider.trackWidth");
        tickLength = this.safeLength = ((Integer)UIManager.get("Slider.majorTickLength")).intValue();
        horizThumbIcon = SAFE_HORIZ_THUMB_ICON = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = SAFE_VERT_THUMB_ICON = UIManager.getIcon("Slider.verticalThumbIcon");
        super.installUI(jComponent);
        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");
        this.scrollListener.setScrollByBlock(false);
        Object object = jComponent.getClientProperty("JSlider.isFilled");
        if (object != null) {
            this.filledSlider = (Boolean)object;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new MetalPropertyListener();
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.getOrientation() == 0) {
            MetalSliderUI.getHorizThumbIcon().paintIcon(this.slider, graphics, 0, 0);
        } else {
            MetalSliderUI.getVertThumbIcon().paintIcon(this.slider, graphics, 0, 0);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private Color chooseColor(boolean bl, Color color, Color color2) {
        if (bl) {
            return color2;
        }
        return color;
    }

    private Rectangle getPaintTrackRect() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.slider.getOrientation() == 0) {
            n4 = this.trackRect.height - 1 - this.getThumbOverhang();
            n3 = n4 - (this.getTrackWidth() - 1);
            n2 = this.trackRect.width - 1;
        } else {
            if (MetalUtils.isLeftToRight(this.slider)) {
                n = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n2 = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n = this.getThumbOverhang();
                n2 = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n4 = this.trackRect.height - 1;
        }
        return new Rectangle(this.trackRect.x + n, this.trackRect.y + n3, n2 - n, n4 - n3);
    }

    public void paintTrack(Graphics graphics) {
        if (MetalLookAndFeel.usingOcean()) {
            this.oceanPaintTrack(graphics);
            return;
        }
        ColorUIResource colorUIResource = !this.slider.isEnabled() ? MetalLookAndFeel.getControlShadow() : this.slider.getForeground();
        boolean bl = MetalUtils.isLeftToRight(this.slider);
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.slider.getOrientation() == 0) {
            n4 = this.trackRect.height - 1 - this.getThumbOverhang();
            n2 = n4 - (this.getTrackWidth() - 1);
            n3 = this.trackRect.width - 1;
        } else {
            if (bl) {
                n = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n3 = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n = this.getThumbOverhang();
                n3 = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n4 = this.trackRect.height - 1;
        }
        if (this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(n, n2, n3 - n - 1, n4 - n2 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n + 1, n4, n3, n4);
            graphics.drawLine(n3, n2 + 1, n3, n4);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(n + 1, n2 + 1, n3 - 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 2);
        } else {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawRect(n, n2, n3 - n - 1, n4 - n2 - 1);
        }
        if (this.filledSlider) {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            if (this.slider.getOrientation() == 0) {
                n5 = this.thumbRect.x + this.thumbRect.width / 2;
                n5 -= this.trackRect.x;
                n6 = !this.slider.isEnabled() ? n2 : n2 + 1;
                int n10 = n8 = !this.slider.isEnabled() ? n4 - 1 : n4 - 2;
                if (!this.drawInverted()) {
                    n7 = !this.slider.isEnabled() ? n : n + 1;
                    n9 = n5;
                } else {
                    n7 = n5;
                    n9 = !this.slider.isEnabled() ? n3 - 1 : n3 - 2;
                }
            } else {
                n5 = this.thumbRect.y + this.thumbRect.height / 2;
                n5 -= this.trackRect.y;
                n7 = !this.slider.isEnabled() ? n : n + 1;
                int n11 = n9 = !this.slider.isEnabled() ? n3 - 1 : n3 - 2;
                if (!this.drawInverted()) {
                    n6 = n5;
                    n8 = !this.slider.isEnabled() ? n4 - 1 : n4 - 2;
                } else {
                    n6 = !this.slider.isEnabled() ? n2 : n2 + 1;
                    n8 = n5;
                }
            }
            if (this.slider.isEnabled()) {
                graphics.setColor(this.slider.getBackground());
                graphics.drawLine(n7, n6, n9, n6);
                graphics.drawLine(n7, n6, n7, n8);
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n7 + 1, n6 + 1, n9 - n7, n8 - n6);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n7, n6, n9 - n7, n4 - n2);
            }
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    private void oceanPaintTrack(Graphics graphics) {
        boolean bl = MetalUtils.isLeftToRight(this.slider);
        boolean bl2 = this.drawInverted();
        Color color = (Color)UIManager.get("Slider.altTrackColor");
        Rectangle rectangle = this.getPaintTrackRect();
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (!this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        } else if (this.slider.getOrientation() == 0) {
            int n3;
            int n4;
            int n5 = this.thumbRect.x + this.thumbRect.width / 2 - rectangle.x;
            if (n5 > 0) {
                graphics.setColor(this.chooseColor(bl2, MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getControlDarkShadow()));
                graphics.drawRect(0, 0, n5 - 1, n2 - 1);
            }
            if (n5 < n) {
                graphics.setColor(this.chooseColor(bl2, MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getPrimaryControlDarkShadow()));
                graphics.drawRect(n5, 0, n - n5 - 1, n2 - 1);
            }
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            if (bl2) {
                n4 = n5;
                n3 = n - 2;
                graphics.drawLine(1, 1, n5, 1);
            } else {
                n4 = 1;
                n3 = n5;
                graphics.drawLine(n5, 1, n - 1, 1);
            }
            if (n2 == 6) {
                graphics.setColor(MetalLookAndFeel.getWhite());
                graphics.drawLine(n4, 1, n3, 1);
                graphics.setColor(color);
                graphics.drawLine(n4, 2, n3, 2);
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawLine(n4, 3, n3, 3);
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                graphics.drawLine(n4, 4, n3, 4);
            }
        } else {
            int n6;
            int n7;
            int n8 = this.thumbRect.y + this.thumbRect.height / 2 - rectangle.y;
            if (n8 > 0) {
                graphics.setColor(this.chooseColor(bl2, MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getPrimaryControlDarkShadow()));
                graphics.drawRect(0, 0, n - 1, n8 - 1);
            }
            if (n8 < n2) {
                graphics.setColor(this.chooseColor(bl2, MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getControlDarkShadow()));
                graphics.drawRect(0, n8, n - 1, n2 - n8 - 1);
            }
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            if (this.drawInverted()) {
                n7 = 1;
                n6 = n8;
                if (bl) {
                    graphics.drawLine(1, n8, 1, n2 - 1);
                } else {
                    graphics.drawLine(n - 2, n8, n - 2, n2 - 1);
                }
            } else {
                n7 = n8;
                n6 = n2 - 2;
                if (bl) {
                    graphics.drawLine(1, 1, 1, n8);
                } else {
                    graphics.drawLine(n - 2, 1, n - 2, n8);
                }
            }
            if (n == 6) {
                graphics.setColor(this.chooseColor(!bl, MetalLookAndFeel.getWhite(), MetalLookAndFeel.getPrimaryControlShadow()));
                graphics.drawLine(1, n7, 1, n6);
                graphics.setColor(this.chooseColor(!bl, color, MetalLookAndFeel.getControlShadow()));
                graphics.drawLine(2, n7, 2, n6);
                graphics.setColor(this.chooseColor(!bl, MetalLookAndFeel.getControlShadow(), color));
                graphics.drawLine(3, n7, 3, n6);
                graphics.setColor(this.chooseColor(!bl, MetalLookAndFeel.getPrimaryControlShadow(), MetalLookAndFeel.getWhite()));
                graphics.drawLine(4, n7, 4, n6);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void paintFocus(Graphics graphics) {
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = MetalSliderUI.getVertThumbIcon().getIconWidth();
            dimension.height = MetalSliderUI.getVertThumbIcon().getIconHeight();
        } else {
            dimension.width = MetalSliderUI.getHorizThumbIcon().getIconWidth();
            dimension.height = MetalSliderUI.getHorizThumbIcon().getIconHeight();
        }
        return dimension;
    }

    public int getTickLength() {
        return this.slider.getOrientation() == 0 ? this.safeLength + 4 + 1 : this.safeLength + 4 + 3;
    }

    protected int getTrackWidth() {
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }

    protected int getTrackLength() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.width;
        }
        return this.trackRect.height;
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    protected void scrollDueToClickInTrack(int n) {
        this.scrollByUnit(n);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n, 4, n, 4 + this.safeLength / 2);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        graphics.drawLine(n, 4, n, 4 + (this.safeLength - 1));
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n, 4 + this.safeLength / 2, n);
        } else {
            graphics.drawLine(0, n, this.safeLength / 2, n);
        }
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? this.slider.getForeground() : MetalLookAndFeel.getControlShadow());
        if (MetalUtils.isLeftToRight(this.slider)) {
            graphics.drawLine(4, n, 4 + this.safeLength, n);
        } else {
            graphics.drawLine(0, n, this.safeLength, n);
        }
    }

    protected class MetalPropertyListener
    extends BasicSliderUI.PropertyChangeHandler {
        protected MetalPropertyListener() {
            super(MetalSliderUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("JSlider.isFilled")) {
                MetalSliderUI.this.filledSlider = propertyChangeEvent.getNewValue() != null ? (Boolean)propertyChangeEvent.getNewValue() : false;
            }
        }
    }
}

