/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicLongFieldUpdater<T> {
    public static <U> AtomicLongFieldUpdater<U> newUpdater(Class<U> clazz, String string) {
        if (AtomicLong.VM_SUPPORTS_LONG_CAS) {
            return new CASUpdater<U>(clazz, string);
        }
        return new LockedUpdater<U>(clazz, string);
    }

    protected AtomicLongFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, long var2, long var4);

    public abstract boolean weakCompareAndSet(T var1, long var2, long var4);

    public abstract void set(T var1, long var2);

    public abstract long get(T var1);

    public long getAndSet(T t, long l) {
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l)) {
        }
        return l2;
    }

    public long getAndIncrement(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 + 1L)) {
        }
        return l2;
    }

    public long getAndDecrement(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 - 1L)) {
        }
        return l2;
    }

    public long getAndAdd(T t, long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(t, l3 = this.get(t), l2 = l3 + l)) {
        }
        return l3;
    }

    public long incrementAndGet(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 + 1L)) {
        }
        return l;
    }

    public long decrementAndGet(T t) {
        long l;
        long l2;
        while (!this.compareAndSet(t, l2 = this.get(t), l = l2 - 1L)) {
        }
        return l;
    }

    public long addAndGet(T t, long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(t, l3 = this.get(t), l2 = l3 + l)) {
        }
        return l2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CASUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class cclass;

        CASUpdater(Class<T> clazz, String string) {
            Field field = null;
            Class clazz2 = null;
            int n = 0;
            try {
                field = clazz.getDeclaredField(string);
                clazz2 = Reflection.getCallerClass(3);
                n = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz2, clazz, null, n);
                ReflectUtil.checkPackageAccess(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Class<?> clazz3 = field.getType();
            if (clazz3 != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(n)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n) && clazz2 != clazz ? clazz2 : null;
            this.tclass = clazz;
            this.offset = unsafe.objectFieldOffset(field);
        }

        @Override
        public boolean compareAndSet(T t, long l, long l2) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
            return unsafe.compareAndSwapLong(t, this.offset, l, l2);
        }

        @Override
        public boolean weakCompareAndSet(T t, long l, long l2) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
            return unsafe.compareAndSwapLong(t, this.offset, l, l2);
        }

        @Override
        public void set(T t, long l) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
            unsafe.putLongVolatile(t, this.offset, l);
        }

        @Override
        public long get(T t) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
            return unsafe.getLongVolatile(t, this.offset);
        }

        private void ensureProtectedAccess(T t) {
            if (this.cclass.isInstance(t)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t.getClass().getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LockedUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class cclass;

        LockedUpdater(Class<T> clazz, String string) {
            Field field = null;
            Class clazz2 = null;
            int n = 0;
            try {
                field = clazz.getDeclaredField(string);
                clazz2 = Reflection.getCallerClass(3);
                n = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz2, clazz, null, n);
                ReflectUtil.checkPackageAccess(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Class<?> clazz3 = field.getType();
            if (clazz3 != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(n)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n) && clazz2 != clazz ? clazz2 : null;
            this.tclass = clazz;
            this.offset = unsafe.objectFieldOffset(field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean compareAndSet(T t, long l, long l2) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                long l3 = unsafe.getLong(t, this.offset);
                if (l3 != l) {
                    return false;
                }
                unsafe.putLong(t, this.offset, l2);
                return true;
            }
        }

        @Override
        public boolean weakCompareAndSet(T t, long l, long l2) {
            return this.compareAndSet(t, l, l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T t, long l) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                unsafe.putLong(t, this.offset, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long get(T t) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                return unsafe.getLong(t, this.offset);
            }
        }

        private void ensureProtectedAccess(T t) {
            if (this.cclass.isInstance(t)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t.getClass().getName()));
        }
    }
}

