/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Rectangle
extends Rectangle2D
implements Shape,
Serializable {
    public int x;
    public int y;
    public int width;
    public int height;
    private static final long serialVersionUID = -4345857070255674764L;

    private static native void initIDs();

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Rectangle(int n, int n2) {
        this(0, 0, n, n2);
    }

    public Rectangle(Point point, Dimension dimension) {
        this(point.x, point.y, dimension.width, dimension.height);
    }

    public Rectangle(Point point) {
        this(point.x, point.y, 0, 0);
    }

    public Rectangle(Dimension dimension) {
        this(0, 0, dimension.width, dimension.height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void setRect(double d, double d2, double d3, double d4) {
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d2);
        int n3 = (int)Math.ceil(d + d3);
        int n4 = (int)Math.ceil(d2 + d4);
        this.setBounds(n, n2, n3 - n, n4 - n2);
    }

    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    @Deprecated
    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    @Deprecated
    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean contains(Rectangle rectangle) {
        return this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        int n5 = this.width;
        int n6 = this.height;
        if ((n5 | n6 | n3 | n4) < 0) {
            return false;
        }
        int n7 = this.x;
        int n8 = this.y;
        if (n < n7 || n2 < n8) {
            return false;
        }
        n5 += n7;
        if ((n3 += n) <= n ? n5 >= n7 || n3 > n5 : n5 >= n7 && n3 > n5) {
            return false;
        }
        n6 += n8;
        return !((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6);
    }

    @Deprecated
    public boolean inside(int n, int n2) {
        int n3 = this.width;
        int n4 = this.height;
        if ((n3 | n4) < 0) {
            return false;
        }
        int n5 = this.x;
        int n6 = this.y;
        if (n < n5 || n2 < n6) {
            return false;
        }
        n4 += n6;
        return !((n3 += n5) >= n5 && n3 <= n || n4 >= n6 && n4 <= n2);
    }

    public boolean intersects(Rectangle rectangle) {
        int n = this.width;
        int n2 = this.height;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (n3 <= 0 || n4 <= 0 || n <= 0 || n2 <= 0) {
            return false;
        }
        int n5 = this.x;
        int n6 = this.y;
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        n4 += n8;
        n += n5;
        n2 += n6;
        return !((n3 += n7) >= n7 && n3 <= n5 || n4 >= n8 && n4 <= n6 || n >= n5 && n <= n7 || n2 >= n6 && n2 <= n8);
    }

    public Rectangle intersection(Rectangle rectangle) {
        int n = this.x;
        int n2 = this.y;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        long l = n;
        l += (long)this.width;
        long l2 = n2;
        l2 += (long)this.height;
        long l3 = n3;
        l3 += (long)rectangle.width;
        long l4 = n4;
        l4 += (long)rectangle.height;
        if (n < n3) {
            n = n3;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        if (l > l3) {
            l = l3;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        l2 -= (long)n2;
        if ((l -= (long)n) < Integer.MIN_VALUE) {
            l = Integer.MIN_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        return new Rectangle(n, n2, (int)l, (int)l2);
    }

    public Rectangle union(Rectangle rectangle) {
        int n = Math.min(this.x, rectangle.x);
        int n2 = Math.max(this.x + this.width, rectangle.x + rectangle.width);
        int n3 = Math.min(this.y, rectangle.y);
        int n4 = Math.max(this.y + this.height, rectangle.y + rectangle.height);
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    public void add(int n, int n2) {
        int n3 = Math.min(this.x, n);
        int n4 = Math.max(this.x + this.width, n);
        int n5 = Math.min(this.y, n2);
        int n6 = Math.max(this.y + this.height, n2);
        this.x = n3;
        this.y = n5;
        this.width = n4 - n3;
        this.height = n6 - n5;
    }

    public void add(Point point) {
        this.add(point.x, point.y);
    }

    public void add(Rectangle rectangle) {
        int n = Math.min(this.x, rectangle.x);
        int n2 = Math.max(this.x + this.width, rectangle.x + rectangle.width);
        int n3 = Math.min(this.y, rectangle.y);
        int n4 = Math.max(this.y + this.height, rectangle.y + rectangle.height);
        this.x = n;
        this.y = n3;
        this.width = n2 - n;
        this.height = n4 - n3;
    }

    public void grow(int n, int n2) {
        this.x -= n;
        this.y -= n2;
        this.width += n * 2;
        this.height += n2 * 2;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public int outcode(double d, double d2) {
        int n = 0;
        if (this.width <= 0) {
            n |= 5;
        } else if (d < (double)this.x) {
            n |= 1;
        } else if (d > (double)this.x + (double)this.width) {
            n |= 4;
        }
        if (this.height <= 0) {
            n |= 0xA;
        } else if (d2 < (double)this.y) {
            n |= 2;
        } else if (d2 > (double)this.y + (double)this.height) {
            n |= 8;
        }
        return n;
    }

    public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return this.intersection((Rectangle)rectangle2D);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.intersect(this, rectangle2D, double_);
        return double_;
    }

    public Rectangle2D createUnion(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return this.union((Rectangle)rectangle2D);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.union(this, rectangle2D, double_);
        return double_;
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return super.equals(object);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Rectangle.initIDs();
        }
    }
}

