/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.comp;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.tools.apt.comp.AnnotationProcessingError;
import com.sun.tools.apt.comp.BootstrapAPF;
import com.sun.tools.apt.comp.UsageMessageNeededException;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.apt.AnnotationProcessorEnvironmentImpl;
import com.sun.tools.apt.mirror.apt.FilerImpl;
import com.sun.tools.apt.mirror.declaration.DeclarationMaker;
import com.sun.tools.apt.util.Bark;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Apt
extends ListBuffer<Env<AttrContext>> {
    Set<String> genSourceFileNames = new LinkedHashSet<String>();
    Set<String> genClassFileNames = new LinkedHashSet<String>();
    AptEnv aptenv;
    private Context context;
    protected static final Context.Key<Apt> aptKey = new Context.Key();
    private static final Pattern allMatches = Pattern.compile(".*");
    private static final Pattern noMatches = Pattern.compile("(\\P{all})+");

    public Set<String> getSourceFileNames() {
        return this.genSourceFileNames;
    }

    public Set<String> getClassFileNames() {
        return this.genClassFileNames;
    }

    public static Apt instance(Context context) {
        Apt apt2 = context.get(aptKey);
        if (apt2 == null) {
            apt2 = new Apt(context);
        }
        return apt2;
    }

    protected Apt(Context context) {
        this.context = context;
        context.put(aptKey, this);
        this.aptenv = AptEnv.instance(context);
    }

    Set<String> computeAnnotationSet(Collection<Symbol.ClassSymbol> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Symbol.ClassSymbol classSymbol : collection) {
            this.computeAnnotationSet(classSymbol, hashSet);
        }
        return hashSet;
    }

    void computeAnnotationSet(Symbol symbol, Set<String> set) {
        if (symbol != null) {
            if (symbol.attributes() != null) {
                for (Attribute.Compound object : symbol.attributes()) {
                    set.add(object.type.tsym.toString());
                }
            }
            if (symbol instanceof Symbol.MethodSymbol) {
                for (Symbol.VarSymbol varSymbol : ((Symbol.MethodSymbol)symbol).params()) {
                    this.computeAnnotationSet(varSymbol, set);
                }
            }
            if (symbol.members() != null) {
                for (Iterator<Object> iterator : symbol.members().table) {
                    this.computeAnnotationSet(((Scope.Entry)((Object)iterator)).sym, set);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void main(List<Tree> list, ListBuffer<Symbol.ClassSymbol> listBuffer, Map<String, String> map, ClassLoader classLoader, AnnotationProcessorFactory annotationProcessorFactory, Set<Class<? extends AnnotationProcessorFactory>> set) {
        LinkedHashMap<Object, Object> linkedHashMap;
        Bark bark = Bark.instance(this.context);
        PrintWriter printWriter = bark.warnWriter;
        Options options = Options.instance(this.context);
        LinkedHashSet<TypeDeclaration> linkedHashSet = new LinkedHashSet<TypeDeclaration>();
        LinkedHashSet<TypeDeclaration> linkedHashSet2 = new LinkedHashSet<TypeDeclaration>();
        LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>();
        Set set2 = Collections.emptySet();
        LinkedHashSet linkedHashSet4 = new LinkedHashSet();
        AptTreeScanner aptTreeScanner = new AptTreeScanner();
        for (Tree iterator2 : list) {
            iterator2.accept(aptTreeScanner);
        }
        for (Symbol.ClassSymbol classSymbol : aptTreeScanner.specifiedDeclCollection) {
            linkedHashMap = this.aptenv.declMaker.getTypeDeclaration(classSymbol);
            linkedHashSet.add((TypeDeclaration)((Object)linkedHashMap));
        }
        for (Symbol.ClassSymbol classSymbol : aptTreeScanner.declCollection) {
            linkedHashMap = this.aptenv.declMaker.getTypeDeclaration(classSymbol);
            linkedHashSet2.add((TypeDeclaration)((Object)linkedHashMap));
        }
        linkedHashSet3.addAll(aptTreeScanner.getAnnotationSet());
        for (Symbol.ClassSymbol classSymbol : listBuffer) {
            linkedHashMap = this.aptenv.declMaker.getTypeDeclaration(classSymbol);
            linkedHashSet.add((TypeDeclaration)((Object)linkedHashMap));
            linkedHashSet2.add((TypeDeclaration)((Object)linkedHashMap));
            this.computeAnnotationSet(classSymbol, linkedHashSet3);
        }
        if (options.get("-XListAnnotationTypes") != null) {
            printWriter.println("Set of annotations found:" + new TreeSet(linkedHashSet3).toString());
        }
        AnnotationProcessorEnvironmentImpl annotationProcessorEnvironmentImpl = new AnnotationProcessorEnvironmentImpl(linkedHashSet, linkedHashSet2, map, this.context);
        if (options.get("-XListDeclarations") != null) {
            printWriter.println("Set of Specified Declarations:" + linkedHashSet);
            printWriter.println("Set of Included Declarations: " + linkedHashSet2);
        }
        if (options.get("-print") != null) {
            if (linkedHashSet.size() == 0) {
                throw new UsageMessageNeededException();
            }
            AnnotationProcessor annotationProcessor = new BootstrapAPF().getProcessorFor(new HashSet<AnnotationTypeDeclaration>(), annotationProcessorEnvironmentImpl);
            annotationProcessor.process();
        } else {
            Object object;
            Object object22;
            void var17_29;
            Object object3;
            Object var17_25 = null;
            linkedHashMap = new LinkedList();
            Set<Object> set3 = (String)options.get("-factory");
            if (annotationProcessorFactory != null) {
                linkedHashMap.add(annotationProcessorFactory);
                Iterator iterator = linkedHashMap.iterator();
            } else if (set3 != null) {
                try {
                    object3 = (AnnotationProcessorFactory)classLoader.loadClass((String)((Object)set3)).newInstance();
                    linkedHashMap.add(object3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bark.warning(0, "FactoryNotFound", set3);
                }
                catch (ClassCastException classCastException) {
                    bark.warning(0, "FactoryWrongType", set3);
                }
                catch (Exception exception) {
                    bark.warning(0, "FactoryCantInstantiate", set3);
                }
                catch (Throwable throwable) {
                    throw new AnnotationProcessingError(throwable);
                }
                Iterator iterator = linkedHashMap.iterator();
            } else {
                Iterator iterator = Service.providers(AnnotationProcessorFactory.class, (ClassLoader)classLoader);
            }
            linkedHashMap = new LinkedHashMap<Object, Object>();
            if (!var17_29.hasNext() && set.size() == 0) {
                if (linkedHashSet3.size() > 0) {
                    bark.warning(0, "NoAnnotationProcessors", new Object[0]);
                }
                if (linkedHashSet.size() == 0) {
                    throw new UsageMessageNeededException();
                }
                return;
            }
            if (linkedHashSet3.size() == 0) {
                linkedHashSet3.add("");
            }
            set3 = new HashSet();
            set3.add("");
            set3 = Collections.unmodifiableSet(set3);
            while (var17_29.hasNext()) {
                object3 = var17_29.next();
                try {
                    object22 = new HashSet();
                    object = object3;
                    Collection<String> collection = object.supportedAnnotationTypes();
                    LinkedList<Pattern> linkedList = new LinkedList<Pattern>();
                    for (String string : collection) {
                        linkedList.add(this.importStringToPattern(string));
                    }
                    block22: for (String string : linkedHashSet3) {
                        for (Pattern pattern : linkedList) {
                            if (!pattern.matcher(string).matches()) continue;
                            object22.add(string);
                            continue block22;
                        }
                    }
                    linkedHashSet3.removeAll((Collection<?>)object22);
                    if (options.get("-XPrintFactoryInfo") != null) {
                        printWriter.println("Factory " + object.getClass().getName() + " matches " + (object22.size() == 0 ? "nothing." : object22));
                    }
                    if (object22.size() > 0) {
                        HashSet hashSet = new HashSet();
                        if (!object22.equals(set3)) {
                            Iterator iterator = object22.iterator();
                            while (iterator.hasNext()) {
                                String string = (String)iterator.next();
                                TypeDeclaration typeDeclaration = this.aptenv.declMaker.getTypeDeclaration(string);
                                if (typeDeclaration == null) {
                                    bark.error(0, "DeclarationCreation", string);
                                    continue;
                                }
                                try {
                                    AnnotationTypeDeclaration annotationTypeDeclaration = (AnnotationTypeDeclaration)typeDeclaration;
                                    hashSet.add(annotationTypeDeclaration);
                                }
                                catch (ClassCastException classCastException) {
                                    bark.error(0, "BadDeclaration", string);
                                }
                            }
                        }
                        linkedHashSet4.add(object.getClass());
                        set.add(object.getClass());
                        linkedHashMap.put(object, hashSet);
                    } else if (set.contains(object.getClass())) {
                        linkedHashSet4.add(object.getClass());
                        linkedHashMap.put(object, set2);
                    }
                    if (linkedHashSet3.size() != 0) continue;
                    break;
                }
                catch (ClassCastException classCastException) {
                    bark.warning(0, "BadFactory", classCastException);
                }
            }
            linkedHashSet3.remove("");
            set3 = new LinkedHashSet<Class<? extends AnnotationProcessorFactory>>(set);
            set3.removeAll(linkedHashSet4);
            for (Object object22 : set3) {
                try {
                    object = (AnnotationProcessorFactory)((Class)object22).newInstance();
                    linkedHashMap.put(object, set2);
                }
                catch (Exception exception) {
                    bark.warning(0, "FactoryCantInstantiate", ((Class)object22).getName());
                }
                catch (Throwable throwable) {
                    throw new AnnotationProcessingError(throwable);
                }
            }
            if (linkedHashSet3.size() > 0) {
                bark.warning(0, "AnnotationsWithoutProcessors", linkedHashSet3);
            }
            set3 = new LinkedHashSet<Object>();
            if (linkedHashSet.size() == 0 && linkedHashMap.keySet().size() == 0) {
                throw new UsageMessageNeededException();
            }
            try {
                for (Object object22 : linkedHashMap.keySet()) {
                    object = object22.getProcessorFor((Set)linkedHashMap.get(object22), annotationProcessorEnvironmentImpl);
                    if (object != null) {
                        set3.add(object);
                        continue;
                    }
                    bark.warning(0, "NullProcessor", object22.getClass().getName());
                }
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
            object3 = new LinkedList();
            ((LinkedList)object3).addAll(set3);
            object22 = AnnotationProcessors.getCompositeAnnotationProcessor((Collection<AnnotationProcessor>)object3);
            try {
                object22.process();
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
            annotationProcessorEnvironmentImpl.roundComplete();
            object = (FilerImpl)annotationProcessorEnvironmentImpl.getFiler();
            this.genSourceFileNames = ((FilerImpl)object).getSourceFileNames();
            this.genClassFileNames = ((FilerImpl)object).getClassFileNames();
            ((FilerImpl)object).flush();
        }
    }

    Pattern importStringToPattern(String string) {
        Object object;
        if (string.equals("*")) {
            return allMatches;
        }
        String string2 = string;
        boolean bl = false;
        boolean bl2 = true;
        int n = string2.indexOf(42);
        if (n != -1) {
            if (n == string2.length() - 1) {
                if (n - 1 >= 0) {
                    bl2 = string2.charAt(n - 1) == '.';
                    string2 = string2.substring(0, string2.length() - 2);
                }
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            for (String string3 : object = string2.split("\\.", string2.length() + 2)) {
                bl2 &= DeclarationMaker.isJavaIdentifier(string3);
            }
        }
        if (!bl2) {
            object = Bark.instance(this.context);
            object.warning(0, "MalformedSupportedString", string);
            return noMatches;
        }
        object = string.replaceAll("\\.", "\\\\.");
        if (object.endsWith("*")) {
            object = object.substring(0, object.length() - 1) + ".+";
        }
        return Pattern.compile((String)object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AptTreeScanner
    extends TreeScanner {
        private Set<String> annotationSet = new LinkedHashSet<String>();
        private Collection<Symbol.ClassSymbol> specifiedDeclCollection = new LinkedHashSet<Symbol.ClassSymbol>();
        private Collection<Symbol.ClassSymbol> declCollection = new LinkedHashSet<Symbol.ClassSymbol>();

        public Set<String> getAnnotationSet() {
            return this.annotationSet;
        }

        @Override
        public void visitTopLevel(Tree.TopLevel topLevel) {
            super.visitTopLevel(topLevel);
            for (Tree tree : topLevel.defs) {
                if (!(tree instanceof Tree.ClassDef)) continue;
                this.specifiedDeclCollection.add(((Tree.ClassDef)tree).sym);
            }
        }

        @Override
        public void visitBlock(Tree.Block block) {
        }

        @Override
        public void visitClassDef(Tree.ClassDef classDef) {
            if (classDef.sym == null) {
                return;
            }
            super.visitClassDef(classDef);
            this.declCollection.add(classDef.sym);
        }

        @Override
        public void visitMethodDef(Tree.MethodDef methodDef) {
            super.visitMethodDef(methodDef);
        }

        @Override
        public void visitVarDef(Tree.VarDef varDef) {
            super.visitVarDef(varDef);
        }

        @Override
        public void visitAnnotation(Tree.Annotation annotation) {
            super.visitAnnotation(annotation);
            this.annotationSet.add(annotation.type.tsym.toString());
        }
    }
}

