/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMerger;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class PolicySubject {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicySubject.class);
    private final List<Policy> policies = new LinkedList<Policy>();
    private final Object subject;

    public PolicySubject(Object object, Policy policy) throws IllegalArgumentException {
        if (object == null || policy == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0021_SUBJECT_AND_POLICY_PARAM_MUST_NOT_BE_NULL(object, policy)));
        }
        this.subject = object;
        this.attach(policy);
    }

    public PolicySubject(Object object, Collection<Policy> collection) throws IllegalArgumentException {
        if (object == null || collection == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0062_INPUT_PARAMS_MUST_NOT_BE_NULL()));
        }
        if (collection.isEmpty()) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0064_INITIAL_POLICY_COLLECTION_MUST_NOT_BE_EMPTY()));
        }
        this.subject = object;
        this.policies.addAll(collection);
    }

    public void attach(Policy policy) {
        if (policy == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0038_POLICY_TO_ATTACH_MUST_NOT_BE_NULL()));
        }
        this.policies.add(policy);
    }

    public Policy getEffectivePolicy(PolicyMerger policyMerger) throws PolicyException {
        return policyMerger.merge(this.policies);
    }

    public Object getSubject() {
        return this.subject;
    }

    public String toString() {
        return this.toString(0, new StringBuffer()).toString();
    }

    StringBuffer toString(int n, StringBuffer stringBuffer) {
        String string = PolicyUtils.Text.createIndent(n);
        String string2 = PolicyUtils.Text.createIndent(n + 1);
        stringBuffer.append(string).append("policy subject {").append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string2).append("subject = '").append(this.subject).append('\'').append(PolicyUtils.Text.NEW_LINE);
        for (Policy policy : this.policies) {
            policy.toString(n + 1, stringBuffer).append(PolicyUtils.Text.NEW_LINE);
        }
        stringBuffer.append(string).append('}');
        return stringBuffer;
    }
}

