/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.AddressingUtils;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.MessageMetadata;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.WSDLOperationMapping;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.message.AttachmentSetImpl;
import com.sun.xml.internal.ws.message.StringHeader;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class Message {
    protected AttachmentSet attachmentSet;
    private WSDLBoundOperation operation = null;
    private WSDLOperationMapping wsdlOperationMapping = null;
    private MessageMetadata messageMetadata = null;
    private Boolean isOneWay;

    public abstract boolean hasHeaders();

    @NotNull
    public abstract MessageHeaders getHeaders();

    @NotNull
    public AttachmentSet getAttachments() {
        if (this.attachmentSet == null) {
            this.attachmentSet = new AttachmentSetImpl();
        }
        return this.attachmentSet;
    }

    protected boolean hasAttachments() {
        return this.attachmentSet != null;
    }

    public void setMessageMedadata(MessageMetadata messageMetadata) {
        this.messageMetadata = messageMetadata;
    }

    @Deprecated
    @Nullable
    public final WSDLBoundOperation getOperation(@NotNull WSDLBoundPortType wSDLBoundPortType) {
        if (this.operation == null && this.messageMetadata != null) {
            if (this.wsdlOperationMapping == null) {
                this.wsdlOperationMapping = this.messageMetadata.getWSDLOperationMapping();
            }
            if (this.wsdlOperationMapping != null) {
                this.operation = this.wsdlOperationMapping.getWSDLBoundOperation();
            }
        }
        if (this.operation == null) {
            this.operation = wSDLBoundPortType.getOperation(this.getPayloadNamespaceURI(), this.getPayloadLocalPart());
        }
        return this.operation;
    }

    @Deprecated
    @Nullable
    public final WSDLBoundOperation getOperation(@NotNull WSDLPort wSDLPort) {
        return this.getOperation(wSDLPort.getBinding());
    }

    @Deprecated
    @Nullable
    public final JavaMethod getMethod(@NotNull SEIModel sEIModel) {
        String string;
        if (this.wsdlOperationMapping == null && this.messageMetadata != null) {
            this.wsdlOperationMapping = this.messageMetadata.getWSDLOperationMapping();
        }
        if (this.wsdlOperationMapping != null) {
            return this.wsdlOperationMapping.getJavaMethod();
        }
        String string2 = this.getPayloadLocalPart();
        if (string2 == null) {
            string2 = "";
            string = "";
        } else {
            string = this.getPayloadNamespaceURI();
        }
        QName qName = new QName(string, string2);
        return sEIModel.getJavaMethod(qName);
    }

    public boolean isOneWay(@NotNull WSDLPort wSDLPort) {
        if (this.isOneWay == null) {
            WSDLBoundOperation wSDLBoundOperation = this.getOperation(wSDLPort);
            this.isOneWay = wSDLBoundOperation != null ? Boolean.valueOf(wSDLBoundOperation.getOperation().isOneWay()) : Boolean.valueOf(false);
        }
        return this.isOneWay;
    }

    public final void assertOneWay(boolean bl) {
        assert (this.isOneWay == null || this.isOneWay == bl);
        this.isOneWay = bl;
    }

    @Nullable
    public abstract String getPayloadLocalPart();

    public abstract String getPayloadNamespaceURI();

    public abstract boolean hasPayload();

    public boolean isFault() {
        String string = this.getPayloadLocalPart();
        if (string == null || !string.equals("Fault")) {
            return false;
        }
        String string2 = this.getPayloadNamespaceURI();
        return string2.equals(SOAPVersion.SOAP_11.nsUri) || string2.equals(SOAPVersion.SOAP_12.nsUri);
    }

    @Nullable
    public QName getFirstDetailEntryName() {
        assert (this.isFault());
        Message message = this.copy();
        try {
            SOAPFaultBuilder sOAPFaultBuilder = SOAPFaultBuilder.create(message);
            return sOAPFaultBuilder.getFirstDetailEntryName();
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }

    public abstract Source readEnvelopeAsSource();

    public abstract Source readPayloadAsSource();

    public abstract SOAPMessage readAsSOAPMessage() throws SOAPException;

    public SOAPMessage readAsSOAPMessage(Packet packet, boolean bl) throws SOAPException {
        return this.readAsSOAPMessage();
    }

    public static Map<String, List<String>> getTransportHeaders(Packet packet) {
        return Message.getTransportHeaders(packet, packet.getState().isInbound());
    }

    public static Map<String, List<String>> getTransportHeaders(Packet packet, boolean bl) {
        String string;
        Map map = null;
        String string2 = string = bl ? "com.sun.xml.internal.ws.api.message.packet.inbound.transport.headers" : "com.sun.xml.internal.ws.api.message.packet.outbound.transport.headers";
        if (packet.supports(string)) {
            map = (Map)packet.get(string);
        }
        return map;
    }

    public static void addSOAPMimeHeaders(MimeHeaders mimeHeaders, Map<String, List<String>> map) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Type")) continue;
            for (String string : entry.getValue()) {
                mimeHeaders.addHeader(entry.getKey(), string);
            }
        }
    }

    public abstract <T> T readPayloadAsJAXB(Unmarshaller var1) throws JAXBException;

    public abstract <T> T readPayloadAsJAXB(Bridge<T> var1) throws JAXBException;

    public abstract <T> T readPayloadAsJAXB(XMLBridge<T> var1) throws JAXBException;

    public abstract XMLStreamReader readPayload() throws XMLStreamException;

    public void consume() {
    }

    public abstract void writePayloadTo(XMLStreamWriter var1) throws XMLStreamException;

    public abstract void writeTo(XMLStreamWriter var1) throws XMLStreamException;

    public abstract void writeTo(ContentHandler var1, ErrorHandler var2) throws SAXException;

    public abstract Message copy();

    @NotNull
    public String getID(@NotNull WSBinding wSBinding) {
        return this.getID(wSBinding.getAddressingVersion(), wSBinding.getSOAPVersion());
    }

    @NotNull
    public String getID(AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        String string = null;
        if (addressingVersion != null) {
            string = AddressingUtils.getMessageID(this.getHeaders(), addressingVersion, sOAPVersion);
        }
        if (string == null) {
            string = Message.generateMessageID();
            this.getHeaders().add(new StringHeader(addressingVersion.messageIDTag, string));
        }
        return string;
    }

    public static String generateMessageID() {
        return "uuid:" + UUID.randomUUID().toString();
    }

    public SOAPVersion getSOAPVersion() {
        return null;
    }
}

