/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.reflect;

import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.internal.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.internal.bind.v2.runtime.reflect.Lister;

final class PrimitiveArrayListerShort<BeanT>
extends Lister<BeanT, short[], Short, ShortArrayPack> {
    private PrimitiveArrayListerShort() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Short.TYPE, new PrimitiveArrayListerShort());
    }

    @Override
    public ListIterator<Short> iterator(final short[] sArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Short>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < sArray.length;
            }

            @Override
            public Short next() {
                return sArray[this.idx++];
            }
        };
    }

    @Override
    public ShortArrayPack startPacking(BeanT BeanT, Accessor<BeanT, short[]> accessor) {
        return new ShortArrayPack();
    }

    @Override
    public void addToPack(ShortArrayPack shortArrayPack, Short s) {
        shortArrayPack.add(s);
    }

    @Override
    public void endPacking(ShortArrayPack shortArrayPack, BeanT BeanT, Accessor<BeanT, short[]> accessor) throws AccessorException {
        accessor.set(BeanT, shortArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, short[]> accessor) throws AccessorException {
        accessor.set(BeanT, new short[0]);
    }

    static final class ShortArrayPack {
        short[] buf = new short[16];
        int size;

        ShortArrayPack() {
        }

        void add(Short s) {
            if (this.buf.length == this.size) {
                short[] sArray = new short[this.buf.length * 2];
                System.arraycopy(this.buf, 0, sArray, 0, this.buf.length);
                this.buf = sArray;
            }
            if (s != null) {
                this.buf[this.size++] = s;
            }
        }

        short[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            short[] sArray = new short[this.size];
            System.arraycopy(this.buf, 0, sArray, 0, this.size);
            return sArray;
        }
    }
}

