/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.sql.rowset.RowSetFactory;
import sun.reflect.misc.ReflectUtil;

public class RowSetProvider {
    private static final String ROWSET_DEBUG_PROPERTY = "javax.sql.rowset.RowSetProvider.debug";
    private static final String ROWSET_FACTORY_IMPL = "com.sun.rowset.RowSetFactoryImpl";
    private static final String ROWSET_FACTORY_NAME = "javax.sql.rowset.RowSetFactory";
    private static boolean debug = true;

    protected RowSetProvider() {
    }

    public static RowSetFactory newFactory() throws SQLException {
        RowSetFactory rowSetFactory = null;
        String string = null;
        try {
            RowSetProvider.trace("Checking for Rowset System Property...");
            string = RowSetProvider.getSystemProperty(ROWSET_FACTORY_NAME);
            if (string != null) {
                RowSetProvider.trace("Found system property, value=" + string);
                rowSetFactory = (RowSetFactory)ReflectUtil.newInstance(RowSetProvider.getFactoryClass(string, null, true));
            }
        }
        catch (Exception exception) {
            throw new SQLException("RowSetFactory: " + string + " could not be instantiated: ", exception);
        }
        if (rowSetFactory == null) {
            rowSetFactory = RowSetProvider.loadViaServiceLoader();
            rowSetFactory = rowSetFactory == null ? RowSetProvider.newFactory(ROWSET_FACTORY_IMPL, null) : rowSetFactory;
        }
        return rowSetFactory;
    }

    public static RowSetFactory newFactory(String string, ClassLoader classLoader) throws SQLException {
        RowSetProvider.trace("***In newInstance()");
        if (string == null) {
            throw new SQLException("Error: factoryClassName cannot be null");
        }
        try {
            ReflectUtil.checkPackageAccess(string);
        }
        catch (AccessControlException accessControlException) {
            throw new SQLException("Access Exception", accessControlException);
        }
        try {
            Class clazz = RowSetProvider.getFactoryClass(string, classLoader, false);
            RowSetFactory rowSetFactory = (RowSetFactory)clazz.newInstance();
            if (debug) {
                RowSetProvider.trace("Created new instance of " + clazz + " using ClassLoader: " + classLoader);
            }
            return rowSetFactory;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new SQLException("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    private static ClassLoader getContextClassLoader() throws SecurityException {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader classLoader = null;
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                return classLoader;
            }
        });
    }

    private static Class getFactoryClass(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException {
        try {
            if (classLoader == null) {
                classLoader = RowSetProvider.getContextClassLoader();
                if (classLoader == null) {
                    throw new ClassNotFoundException();
                }
                return classLoader.loadClass(string);
            }
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                return Class.forName(string, true, RowSetFactory.class.getClassLoader());
            }
            throw classNotFoundException;
        }
    }

    private static RowSetFactory loadViaServiceLoader() throws SQLException {
        RowSetFactory rowSetFactory = null;
        try {
            RowSetProvider.trace("***in loadViaServiceLoader():");
            Iterator<RowSetFactory> iterator = ServiceLoader.load(RowSetFactory.class).iterator();
            if (iterator.hasNext()) {
                RowSetFactory rowSetFactory2 = iterator.next();
                RowSetProvider.trace(" Loading done by the java.util.ServiceLoader :" + rowSetFactory2.getClass().getName());
                rowSetFactory = rowSetFactory2;
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new SQLException("RowSetFactory: Error locating RowSetFactory using Service Loader API: " + serviceConfigurationError, serviceConfigurationError);
        }
        return rowSetFactory;
    }

    private static String getSystemProperty(final String string) {
        String string2;
        block2: {
            string2 = null;
            try {
                string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(string);
                    }
                });
            }
            catch (SecurityException securityException) {
                if (!debug) break block2;
                RowSetProvider.trace("error getting " + string + ":  " + securityException);
                securityException.printStackTrace();
            }
        }
        return string2;
    }

    private static void trace(String string) {
        if (debug) {
            System.err.println("###RowSets: " + string);
        }
    }

    static {
        String string = RowSetProvider.getSystemProperty(ROWSET_DEBUG_PROPERTY);
        debug = string != null && !"false".equals(string);
    }
}

