/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.win.WinChildWindow;
import com.sun.glass.ui.win.WinCommonDialogs;
import com.sun.glass.ui.win.WinCursor;
import com.sun.glass.ui.win.WinPixels;
import com.sun.glass.ui.win.WinRobot;
import com.sun.glass.ui.win.WinScreen;
import com.sun.glass.ui.win.WinTimer;
import com.sun.glass.ui.win.WinView;
import com.sun.glass.ui.win.WinWindow;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WinApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private final InvokeLaterDispatcher invokeLaterDispatcher = new InvokeLaterDispatcher(this);

    private static native void initIDs();

    WinApplication() {
        this.invokeLaterDispatcher.start();
    }

    private native long _init();

    private native void _setClassLoader(ClassLoader var1);

    private native void _runLoop(String[] var1, Launchable var2);

    private native void _terminateLoop();

    @Override
    protected void runLoop(final String[] stringArray, final Launchable launchable) {
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Boolean bl = Boolean.getBoolean("javafx.embed.isEventThread");
                return bl == null ? false : bl;
            }
        });
        ClassLoader classLoader = WinApplication.class.getClassLoader();
        this._setClassLoader(classLoader);
        if (bl) {
            this._init();
            this.setEventThread(Thread.currentThread());
            launchable.finishLaunching(stringArray);
            return;
        }
        Thread thread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        WinApplication.this._init();
                        WinApplication.this._runLoop(stringArray, launchable);
                    }
                }, "WindowsNativeRunloopThread");
                return thread;
            }
        });
        this.setEventThread(thread);
        thread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread thread = this.getEventThread();
        if (thread != null) {
            this._terminateLoop();
            this.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native Object _enterNestedEventLoopImpl();

    private native void _leaveNestedEventLoopImpl(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _enterNestedEventLoop() {
        this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        try {
            Object object = this._enterNestedEventLoopImpl();
            return object;
        }
        finally {
            this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object object) {
        this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        this._leaveNestedEventLoopImpl(object);
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n) {
        return new WinWindow(window, screen, n);
    }

    @Override
    public Window createWindow(long l) {
        return new WinChildWindow(l);
    }

    @Override
    public View createView(Pen pen) {
        return new WinView(pen);
    }

    @Override
    public Cursor createCursor(int n) {
        return new WinCursor(n);
    }

    @Override
    public Cursor createCursor(int n, int n2, Pixels pixels) {
        return new WinCursor(n, n2, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean bl) {
        WinCursor.setVisible_impl(bl);
    }

    @Override
    protected Size staticCursor_getBestSize(int n, int n2) {
        return WinCursor.getBestSize_impl(n, n2);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        return new WinPixels(n, n2, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        return new WinPixels(n, n2, intBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f) {
        return new WinPixels(n, n2, intBuffer, f);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return WinPixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        return new WinRobot();
    }

    @Override
    protected Screen staticScreen_getDeepestScreen() {
        return WinScreen.getDeepestScreen_impl();
    }

    @Override
    protected Screen staticScreen_getMainScreen() {
        return WinScreen.getMainScreen_impl();
    }

    @Override
    protected Screen staticScreen_getScreenForLocation(int n, int n2) {
        return WinScreen.getScreenForLocation_impl(n, n2);
    }

    @Override
    protected Screen staticScreen_getScreenForPtr(long l) {
        return WinScreen.getScreenForPtr_impl(l);
    }

    @Override
    protected List<Screen> staticScreen_getScreens() {
        return WinScreen.getScreens_impl();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new WinTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return WinTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return WinTimer.getMaxPeriod_impl();
    }

    @Override
    protected List<File> staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray) {
        return WinCommonDialogs.showFileChooser_impl(window, string, string2, string3, n, bl, extensionFilterArray);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        return WinCommonDialogs.showFolderChooser_impl(window, string, string2);
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return WinView.getMultiClickTime_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return WinView.getMultiClickMaxX_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return WinView.getMultiClickMaxY_impl();
    }

    @Override
    protected native void _invokeAndWait(Runnable var1);

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable runnable) {
        this._submitForLaterInvocation(runnable);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        this.invokeLaterDispatcher.invokeLater(runnable);
    }

    @Override
    protected native void _postOnEventQueue(Runnable var1);

    @Override
    public boolean supportsTransparentWindows() {
        return true;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Application.loadNativeLibrary();
                return null;
            }
        });
        WinApplication.initIDs();
    }
}

