/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime;

import com.sun.istack.internal.SAXException2;
import com.sun.xml.internal.bind.CycleRecoverable;
import com.sun.xml.internal.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.internal.bind.util.ValidationEventLocatorExImpl;
import com.sun.xml.internal.bind.v2.runtime.ContentHandlerAdaptor;
import com.sun.xml.internal.bind.v2.runtime.Coordinator;
import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.internal.bind.v2.runtime.MarshallerImpl;
import com.sun.xml.internal.bind.v2.runtime.Messages;
import com.sun.xml.internal.bind.v2.runtime.Name;
import com.sun.xml.internal.bind.v2.runtime.NameList;
import com.sun.xml.internal.bind.v2.runtime.NamespaceContext2;
import com.sun.xml.internal.bind.v2.runtime.output.MTOMXmlOutput;
import com.sun.xml.internal.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.internal.bind.v2.runtime.output.Pcdata;
import com.sun.xml.internal.bind.v2.runtime.output.XmlOutput;
import com.sun.xml.internal.bind.v2.runtime.property.Property;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Base64Data;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.IntData;
import com.sun.xml.internal.bind.v2.util.CollisionCheckStack;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.MimeType;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.helpers.NotIdentifiableEventImpl;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.SAXException;

public final class XMLSerializer
extends Coordinator {
    public final JAXBContextImpl grammar;
    private XmlOutput out;
    public final NameList nameList;
    public final int[] knownUri2prefixIndexMap;
    private final NamespaceContextImpl nsContext;
    private NamespaceContextImpl.Element nse;
    ThreadLocal<Property> currentProperty = new ThreadLocal();
    private boolean textHasAlreadyPrinted = false;
    private boolean seenRoot = false;
    private final MarshallerImpl marshaller;
    private final Set<Object> idReferencedObjects = new HashSet<Object>();
    private final Set<Object> objectsWithId = new HashSet<Object>();
    private final CollisionCheckStack<Object> cycleDetectionStack = new CollisionCheckStack();
    private String schemaLocation;
    private String noNsSchemaLocation;
    private Transformer identityTransformer;
    private ContentHandlerAdaptor contentHandlerAdapter;
    private boolean fragment;
    private Base64Data base64Data;
    private final IntData intData = new IntData();
    public AttachmentMarshaller attachmentMarshaller;
    private MimeType expectedMimeType;
    private boolean inlineBinaryFlag;
    private QName schemaType;

    XMLSerializer(MarshallerImpl marshallerImpl) {
        this.marshaller = marshallerImpl;
        this.grammar = this.marshaller.context;
        this.nsContext = new NamespaceContextImpl(this);
        this.nameList = this.marshaller.context.nameList;
        this.knownUri2prefixIndexMap = new int[this.nameList.namespaceURIs.length];
    }

    public Base64Data getCachedBase64DataInstance() {
        return new Base64Data();
    }

    private String getIdFromObject(Object object) throws SAXException, JAXBException {
        return this.grammar.getBeanInfo(object, true).getId(object, this);
    }

    private void handleMissingObjectError(String string) throws SAXException, IOException, XMLStreamException {
        this.reportMissingObjectError(string);
        this.endNamespaceDecls(null);
        this.endAttributes();
    }

    public void reportError(ValidationEvent validationEvent) throws SAXException {
        ValidationEventHandler validationEventHandler;
        try {
            validationEventHandler = this.marshaller.getEventHandler();
        }
        catch (JAXBException jAXBException) {
            throw new SAXException2(jAXBException);
        }
        if (!validationEventHandler.handleEvent(validationEvent)) {
            if (validationEvent.getLinkedException() instanceof Exception) {
                throw new SAXException2((Exception)validationEvent.getLinkedException());
            }
            throw new SAXException2(validationEvent.getMessage());
        }
    }

    public final void reportError(String string, Throwable throwable) throws SAXException {
        ValidationEventImpl validationEventImpl = new ValidationEventImpl(1, throwable.getMessage(), this.getCurrentLocation(string), throwable);
        this.reportError(validationEventImpl);
    }

    public void startElement(Name name, Object object) {
        this.startElement();
        this.nse.setTagName(name, object);
    }

    public void startElement(String string, String string2, String string3, Object object) {
        this.startElement();
        int n = this.nsContext.declareNsUri(string, string3, false);
        this.nse.setTagName(n, string2, object);
    }

    public void startElementForce(String string, String string2, String string3, Object object) {
        this.startElement();
        int n = this.nsContext.force(string, string3);
        this.nse.setTagName(n, string2, object);
    }

    public void endNamespaceDecls(Object object) throws IOException, XMLStreamException {
        this.nsContext.collectionMode = false;
        this.nse.startElement(this.out, object);
    }

    public void endAttributes() throws SAXException, IOException, XMLStreamException {
        if (!this.seenRoot) {
            this.seenRoot = true;
            if (this.schemaLocation != null || this.noNsSchemaLocation != null) {
                int n = this.nsContext.getPrefixIndex("http://www.w3.org/2001/XMLSchema-instance");
                if (this.schemaLocation != null) {
                    this.out.attribute(n, "schemaLocation", this.schemaLocation);
                }
                if (this.noNsSchemaLocation != null) {
                    this.out.attribute(n, "noNamespaceSchemaLocation", this.noNsSchemaLocation);
                }
            }
        }
        this.out.endStartTag();
    }

    public void endElement() throws SAXException, IOException, XMLStreamException {
        this.nse.endElement(this.out);
        this.nse = this.nse.pop();
        this.textHasAlreadyPrinted = false;
    }

    public void leafElement(Name name, String string, String string2) throws SAXException, IOException, XMLStreamException {
        if (this.seenRoot) {
            this.textHasAlreadyPrinted = false;
            this.nse = this.nse.push();
            this.out.beginStartTag(name);
            this.out.endStartTag();
            this.out.text(string, false);
            this.out.endTag(name);
            this.nse = this.nse.pop();
        } else {
            this.startElement(name, null);
            this.endNamespaceDecls(null);
            this.endAttributes();
            this.out.text(string, false);
            this.endElement();
        }
    }

    public void leafElement(Name name, Pcdata pcdata, String string) throws SAXException, IOException, XMLStreamException {
        if (this.seenRoot) {
            this.textHasAlreadyPrinted = false;
            this.nse = this.nse.push();
            this.out.beginStartTag(name);
            this.out.endStartTag();
            this.out.text(pcdata, false);
            this.out.endTag(name);
            this.nse = this.nse.pop();
        } else {
            this.startElement(name, null);
            this.endNamespaceDecls(null);
            this.endAttributes();
            this.out.text(pcdata, false);
            this.endElement();
        }
    }

    public void leafElement(Name name, int n, String string) throws SAXException, IOException, XMLStreamException {
        this.intData.reset(n);
        this.leafElement(name, this.intData, string);
    }

    public void text(String string, String string2) throws SAXException, IOException, XMLStreamException {
        if (string == null) {
            this.reportMissingObjectError(string2);
            return;
        }
        this.out.text(string, this.textHasAlreadyPrinted);
        this.textHasAlreadyPrinted = true;
    }

    public void text(Pcdata pcdata, String string) throws SAXException, IOException, XMLStreamException {
        if (pcdata == null) {
            this.reportMissingObjectError(string);
            return;
        }
        this.out.text(pcdata, this.textHasAlreadyPrinted);
        this.textHasAlreadyPrinted = true;
    }

    public void attribute(String string, String string2, String string3) throws SAXException {
        int n = string.length() == 0 ? -1 : this.nsContext.getPrefixIndex(string);
        try {
            this.out.attribute(n, string2, string3);
        }
        catch (IOException iOException) {
            throw new SAXException2(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException2(xMLStreamException);
        }
    }

    public void attribute(Name name, CharSequence charSequence) throws IOException, XMLStreamException {
        this.out.attribute(name, charSequence.toString());
    }

    public NamespaceContext2 getNamespaceContext() {
        return this.nsContext;
    }

    public String onID(Object object, String string) {
        this.objectsWithId.add(object);
        return string;
    }

    public String onIDREF(Object object) throws SAXException {
        String string;
        try {
            string = this.getIdFromObject(object);
        }
        catch (JAXBException jAXBException) {
            this.reportError(null, jAXBException);
            return null;
        }
        this.idReferencedObjects.add(object);
        if (string == null) {
            this.reportError(new NotIdentifiableEventImpl(1, Messages.NOT_IDENTIFIABLE.format(new Object[0]), new ValidationEventLocatorImpl(object)));
        }
        return string;
    }

    public void childAsRoot(Object object) throws JAXBException, IOException, SAXException, XMLStreamException {
        JaxBeanInfo jaxBeanInfo = this.grammar.getBeanInfo(object, true);
        this.cycleDetectionStack.pushNocheck(object);
        boolean bl = jaxBeanInfo.lookForLifecycleMethods();
        if (bl) {
            this.fireBeforeMarshalEvents(jaxBeanInfo, object);
        }
        jaxBeanInfo.serializeRoot(object, this);
        if (bl) {
            this.fireAfterMarshalEvents(jaxBeanInfo, object);
        }
        this.cycleDetectionStack.pop();
    }

    private Object pushObject(Object object, String string) throws SAXException {
        if (!this.cycleDetectionStack.push(object)) {
            return object;
        }
        if (object instanceof CycleRecoverable) {
            if ((object = ((CycleRecoverable)object).onCycleDetected(new CycleRecoverable.Context(){

                @Override
                public Marshaller getMarshaller() {
                    return XMLSerializer.this.marshaller;
                }
            })) != null) {
                this.cycleDetectionStack.pop();
                return this.pushObject(object, string);
            }
            return null;
        }
        this.reportError(new ValidationEventImpl(1, Messages.CYCLE_IN_MARSHALLER.format(this.cycleDetectionStack.getCycleString()), this.getCurrentLocation(string), null));
        return null;
    }

    public final void childAsSoleContent(Object object, String string) throws SAXException, IOException, XMLStreamException {
        if (object == null) {
            this.handleMissingObjectError(string);
        } else {
            JaxBeanInfo jaxBeanInfo;
            if ((object = this.pushObject(object, string)) == null) {
                this.endNamespaceDecls(null);
                this.endAttributes();
                this.cycleDetectionStack.pop();
            }
            try {
                jaxBeanInfo = this.grammar.getBeanInfo(object, true);
            }
            catch (JAXBException jAXBException) {
                this.reportError(string, jAXBException);
                this.endNamespaceDecls(null);
                this.endAttributes();
                this.cycleDetectionStack.pop();
                return;
            }
            boolean bl = jaxBeanInfo.lookForLifecycleMethods();
            if (bl) {
                this.fireBeforeMarshalEvents(jaxBeanInfo, object);
            }
            jaxBeanInfo.serializeURIs(object, this);
            this.endNamespaceDecls(object);
            jaxBeanInfo.serializeAttributes(object, this);
            this.endAttributes();
            jaxBeanInfo.serializeBody(object, this);
            if (bl) {
                this.fireAfterMarshalEvents(jaxBeanInfo, object);
            }
            this.cycleDetectionStack.pop();
        }
    }

    public final void childAsXsiType(Object object, String string, JaxBeanInfo jaxBeanInfo, boolean bl) throws SAXException, IOException, XMLStreamException {
        if (object == null) {
            this.handleMissingObjectError(string);
        } else {
            if ((object = this.pushObject(object, string)) == null) {
                this.endNamespaceDecls(null);
                this.endAttributes();
                return;
            }
            boolean bl2 = object.getClass() == jaxBeanInfo.jaxbType;
            JaxBeanInfo jaxBeanInfo2 = jaxBeanInfo;
            QName qName = null;
            if (bl2 && jaxBeanInfo2.lookForLifecycleMethods()) {
                this.fireBeforeMarshalEvents(jaxBeanInfo2, object);
            }
            if (!bl2) {
                try {
                    jaxBeanInfo2 = this.grammar.getBeanInfo(object, true);
                    if (jaxBeanInfo2.lookForLifecycleMethods()) {
                        this.fireBeforeMarshalEvents(jaxBeanInfo2, object);
                    }
                }
                catch (JAXBException jAXBException) {
                    this.reportError(string, jAXBException);
                    this.endNamespaceDecls(null);
                    this.endAttributes();
                    return;
                }
                if (jaxBeanInfo2 == jaxBeanInfo) {
                    bl2 = true;
                } else {
                    qName = jaxBeanInfo2.getTypeName(object);
                    if (qName == null) {
                        this.reportError(new ValidationEventImpl(1, Messages.SUBSTITUTED_BY_ANONYMOUS_TYPE.format(jaxBeanInfo.jaxbType.getName(), object.getClass().getName(), jaxBeanInfo2.jaxbType.getName()), this.getCurrentLocation(string)));
                    } else {
                        this.getNamespaceContext().declareNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
                        this.getNamespaceContext().declareNamespace(qName.getNamespaceURI(), null, false);
                    }
                }
            }
            jaxBeanInfo2.serializeURIs(object, this);
            if (bl) {
                this.getNamespaceContext().declareNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
            }
            this.endNamespaceDecls(object);
            if (!bl2) {
                this.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", DatatypeConverter.printQName(qName, this.getNamespaceContext()));
            }
            jaxBeanInfo2.serializeAttributes(object, this);
            boolean bl3 = jaxBeanInfo2.isNilIncluded();
            if (bl && !bl3) {
                this.attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
            }
            this.endAttributes();
            jaxBeanInfo2.serializeBody(object, this);
            if (jaxBeanInfo2.lookForLifecycleMethods()) {
                this.fireAfterMarshalEvents(jaxBeanInfo2, object);
            }
            this.cycleDetectionStack.pop();
        }
    }

    private void fireAfterMarshalEvents(JaxBeanInfo jaxBeanInfo, Object object) {
        Object object2;
        if (jaxBeanInfo.hasAfterMarshalMethod()) {
            object2 = jaxBeanInfo.getLifecycleMethods().afterMarshal;
            this.fireMarshalEvent(object, (Method)object2);
        }
        if ((object2 = this.marshaller.getListener()) != null) {
            ((Marshaller.Listener)object2).afterMarshal(object);
        }
    }

    private void fireBeforeMarshalEvents(JaxBeanInfo jaxBeanInfo, Object object) {
        Object object2;
        if (jaxBeanInfo.hasBeforeMarshalMethod()) {
            object2 = jaxBeanInfo.getLifecycleMethods().beforeMarshal;
            this.fireMarshalEvent(object, (Method)object2);
        }
        if ((object2 = this.marshaller.getListener()) != null) {
            ((Marshaller.Listener)object2).beforeMarshal(object);
        }
    }

    private void fireMarshalEvent(Object object, Method method) {
        try {
            method.invoke(object, this.marshaller);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public void attWildcardAsURIs(Map<QName, String> map, String string) {
        if (map == null) {
            return;
        }
        for (Map.Entry<QName, String> entry : map.entrySet()) {
            QName qName = entry.getKey();
            String string2 = qName.getNamespaceURI();
            if (string2.length() <= 0) continue;
            String string3 = qName.getPrefix();
            if (string3.length() == 0) {
                string3 = null;
            }
            this.nsContext.declareNsUri(string2, string3, true);
        }
    }

    public void attWildcardAsAttributes(Map<QName, String> map, String string) throws SAXException {
        if (map == null) {
            return;
        }
        for (Map.Entry<QName, String> entry : map.entrySet()) {
            QName qName = entry.getKey();
            this.attribute(qName.getNamespaceURI(), qName.getLocalPart(), entry.getValue());
        }
    }

    public final void writeXsiNilTrue() throws SAXException, IOException, XMLStreamException {
        this.getNamespaceContext().declareNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
        this.endNamespaceDecls(null);
        this.attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        this.endAttributes();
    }

    public <E> void writeDom(E e, DomHandler<E, ?> domHandler, Object object, String string) throws SAXException {
        Source source = domHandler.marshal(e, this);
        if (this.contentHandlerAdapter == null) {
            this.contentHandlerAdapter = new ContentHandlerAdaptor(this);
        }
        try {
            this.getIdentityTransformer().transform(source, new SAXResult(this.contentHandlerAdapter));
        }
        catch (TransformerException transformerException) {
            this.reportError(string, transformerException);
        }
    }

    public Transformer getIdentityTransformer() {
        if (this.identityTransformer == null) {
            this.identityTransformer = JAXBContextImpl.createTransformer();
        }
        return this.identityTransformer;
    }

    public void setPrefixMapper(NamespacePrefixMapper namespacePrefixMapper) {
        this.nsContext.setPrefixMapper(namespacePrefixMapper);
    }

    public void startDocument(XmlOutput xmlOutput, boolean bl, String string, String string2) throws IOException, SAXException, XMLStreamException {
        this.setThreadAffinity();
        this.pushCoordinator();
        this.nsContext.reset();
        this.nse = this.nsContext.getCurrent();
        if (this.attachmentMarshaller != null && this.attachmentMarshaller.isXOPPackage()) {
            xmlOutput = new MTOMXmlOutput(xmlOutput);
        }
        this.out = xmlOutput;
        this.objectsWithId.clear();
        this.idReferencedObjects.clear();
        this.textHasAlreadyPrinted = false;
        this.seenRoot = false;
        this.schemaLocation = string;
        this.noNsSchemaLocation = string2;
        this.fragment = bl;
        this.inlineBinaryFlag = false;
        this.expectedMimeType = null;
        this.cycleDetectionStack.reset();
        xmlOutput.startDocument(this, bl, this.knownUri2prefixIndexMap, this.nsContext);
    }

    public void endDocument() throws IOException, SAXException, XMLStreamException {
        this.out.endDocument(this.fragment);
    }

    public void close() {
        this.out = null;
        this.clearCurrentProperty();
        this.popCoordinator();
        this.resetThreadAffinity();
    }

    public void addInscopeBinding(String string, String string2) {
        this.nsContext.put(string, string2);
    }

    public String getXMIMEContentType() {
        String string = this.grammar.getXMIMEContentType(this.cycleDetectionStack.peek());
        if (string != null) {
            return string;
        }
        if (this.expectedMimeType != null) {
            return this.expectedMimeType.toString();
        }
        return null;
    }

    private void startElement() {
        this.nse = this.nse.push();
        if (!this.seenRoot) {
            String string;
            int n;
            String[] stringArray;
            if (this.grammar.getXmlNsSet() != null) {
                for (XmlNs xmlNs : this.grammar.getXmlNsSet()) {
                    this.nsContext.declareNsUri(xmlNs.namespaceURI(), xmlNs.prefix() == null ? "" : xmlNs.prefix(), xmlNs.prefix() != null);
                }
            }
            String[] stringArray2 = this.nameList.namespaceURIs;
            for (int i = 0; i < stringArray2.length; ++i) {
                this.knownUri2prefixIndexMap[i] = this.nsContext.declareNsUri((String)stringArray2[i], null, this.nameList.nsUriCannotBeDefaulted[i]);
            }
            String[] stringArray3 = this.nsContext.getPrefixMapper().getPreDeclaredNamespaceUris();
            if (stringArray3 != null) {
                stringArray = stringArray3;
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    string = stringArray[i];
                    if (string == null) continue;
                    this.nsContext.declareNsUri(string, null, false);
                }
            }
            if ((stringArray = this.nsContext.getPrefixMapper().getPreDeclaredNamespaceUris2()) != null) {
                for (n = 0; n < stringArray.length; n += 2) {
                    String string2 = stringArray[n];
                    string = stringArray[n + 1];
                    if (string2 == null || string == null) continue;
                    this.nsContext.put(string, string2);
                }
            }
            if (this.schemaLocation != null || this.noNsSchemaLocation != null) {
                this.nsContext.declareNsUri("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
            }
        }
        this.nsContext.collectionMode = true;
        this.textHasAlreadyPrinted = false;
    }

    public MimeType setExpectedMimeType(MimeType mimeType) {
        MimeType mimeType2 = this.expectedMimeType;
        this.expectedMimeType = mimeType;
        return mimeType2;
    }

    public boolean setInlineBinaryFlag(boolean bl) {
        boolean bl2 = this.inlineBinaryFlag;
        this.inlineBinaryFlag = bl;
        return bl2;
    }

    public boolean getInlineBinaryFlag() {
        return this.inlineBinaryFlag;
    }

    public QName setSchemaType(QName qName) {
        QName qName2 = this.schemaType;
        this.schemaType = qName;
        return qName2;
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public void setObjectIdentityCycleDetection(boolean bl) {
        this.cycleDetectionStack.setUseIdentity(bl);
    }

    public boolean getObjectIdentityCycleDetection() {
        return this.cycleDetectionStack.getUseIdentity();
    }

    void reconcileID() throws SAXException {
        this.idReferencedObjects.removeAll(this.objectsWithId);
        for (Object object : this.idReferencedObjects) {
            try {
                String string = this.getIdFromObject(object);
                this.reportError(new NotIdentifiableEventImpl(1, Messages.DANGLING_IDREF.format(string), new ValidationEventLocatorImpl(object)));
            }
            catch (JAXBException jAXBException) {}
        }
        this.idReferencedObjects.clear();
        this.objectsWithId.clear();
    }

    public boolean handleError(Exception exception) {
        return this.handleError(exception, this.cycleDetectionStack.peek(), null);
    }

    public boolean handleError(Exception exception, Object object, String string) {
        return this.handleEvent(new ValidationEventImpl(1, exception.getMessage(), new ValidationEventLocatorExImpl(object, string), exception));
    }

    @Override
    public boolean handleEvent(ValidationEvent validationEvent) {
        try {
            return this.marshaller.getEventHandler().handleEvent(validationEvent);
        }
        catch (JAXBException jAXBException) {
            throw new Error(jAXBException);
        }
    }

    private void reportMissingObjectError(String string) throws SAXException {
        this.reportError(new ValidationEventImpl(1, Messages.MISSING_OBJECT.format(string), this.getCurrentLocation(string), new NullPointerException()));
    }

    public void errorMissingId(Object object) throws SAXException {
        this.reportError(new ValidationEventImpl(1, Messages.MISSING_ID.format(object), new ValidationEventLocatorImpl(object)));
    }

    public ValidationEventLocator getCurrentLocation(String string) {
        return new ValidationEventLocatorExImpl(this.cycleDetectionStack.peek(), string);
    }

    @Override
    protected ValidationEventLocator getLocation() {
        return this.getCurrentLocation(null);
    }

    public Property getCurrentProperty() {
        return this.currentProperty.get();
    }

    public void clearCurrentProperty() {
        if (this.currentProperty != null) {
            this.currentProperty.remove();
        }
    }

    public static XMLSerializer getInstance() {
        return (XMLSerializer)Coordinator._getInstance();
    }
}

