/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import sun.java2d.cmm.CMSManager;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;

public class ICC_ColorSpace
extends ColorSpace {
    static final long serialVersionUID = 3455889114070431483L;
    private ICC_Profile thisProfile;
    private float[] minVal;
    private float[] maxVal;
    private float[] diffMinMax;
    private float[] invDiffMinMax;
    private boolean needScaleInit = true;
    private transient ColorTransform this2srgb;
    private transient ColorTransform srgb2this;
    private transient ColorTransform this2xyz;
    private transient ColorTransform xyz2this;

    public ICC_ColorSpace(ICC_Profile iCC_Profile) {
        super(iCC_Profile.getColorSpaceType(), iCC_Profile.getNumComponents());
        int n = iCC_Profile.getProfileClass();
        if (n != 0 && n != 1 && n != 2 && n != 4 && n != 6 && n != 5) {
            throw new IllegalArgumentException("Invalid profile type");
        }
        this.thisProfile = iCC_Profile;
        this.setMinMax();
    }

    public ICC_Profile getProfile() {
        return this.thisProfile;
    }

    @Override
    public float[] toRGB(float[] fArray) {
        Object object;
        if (this.this2srgb == null) {
            ColorTransform[] colorTransformArray = new ColorTransform[2];
            object = (ICC_ColorSpace)ColorSpace.getInstance(1000);
            PCMM pCMM = CMSManager.getModule();
            colorTransformArray[0] = pCMM.createTransform(this.thisProfile, -1, 1);
            colorTransformArray[1] = pCMM.createTransform(((ICC_ColorSpace)object).getProfile(), -1, 2);
            this.this2srgb = pCMM.createTransform(colorTransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        int n = this.getNumComponents();
        object = new short[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (short)((fArray[i] - this.minVal[i]) * this.invDiffMinMax[i] + 0.5f);
        }
        object = this.this2srgb.colorConvert((short[])object, null);
        float[] fArray2 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray2[i] = (float)(object[i] & 0xFFFF) / 65535.0f;
        }
        return fArray2;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        int n;
        Object object;
        ColorTransform[] colorTransformArray;
        if (this.srgb2this == null) {
            colorTransformArray = new ColorTransform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1000);
            object = CMSManager.getModule();
            colorTransformArray[0] = object.createTransform(iCC_ColorSpace.getProfile(), -1, 1);
            colorTransformArray[1] = object.createTransform(this.thisProfile, -1, 2);
            this.srgb2this = object.createTransform(colorTransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        colorTransformArray = (ColorTransform[])new short[3];
        for (n = 0; n < 3; ++n) {
            colorTransformArray[n] = (ColorTransform)((short)(fArray[n] * 65535.0f + 0.5f));
        }
        colorTransformArray = (ColorTransform[])this.srgb2this.colorConvert((short[])colorTransformArray, null);
        n = this.getNumComponents();
        object = new float[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (float)(colorTransformArray[i] & 0xFFFF) / 65535.0f * this.diffMinMax[i] + this.minVal[i];
        }
        return object;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        Object object;
        if (this.this2xyz == null) {
            ColorTransform[] colorTransformArray = new ColorTransform[2];
            object = (ICC_ColorSpace)ColorSpace.getInstance(1001);
            PCMM pCMM = CMSManager.getModule();
            try {
                colorTransformArray[0] = pCMM.createTransform(this.thisProfile, 1, 1);
            }
            catch (CMMException cMMException) {
                colorTransformArray[0] = pCMM.createTransform(this.thisProfile, -1, 1);
            }
            colorTransformArray[1] = pCMM.createTransform(((ICC_ColorSpace)object).getProfile(), -1, 2);
            this.this2xyz = pCMM.createTransform(colorTransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        int n = this.getNumComponents();
        object = new short[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (short)((fArray[i] - this.minVal[i]) * this.invDiffMinMax[i] + 0.5f);
        }
        object = this.this2xyz.colorConvert((short[])object, null);
        float f = 1.9999695f;
        float[] fArray2 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray2[i] = (float)(object[i] & 0xFFFF) / 65535.0f * f;
        }
        return fArray2;
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        int n;
        ColorTransform[] colorTransformArray;
        if (this.xyz2this == null) {
            colorTransformArray = new ColorTransform[2];
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1001);
            PCMM pCMM = CMSManager.getModule();
            colorTransformArray[0] = pCMM.createTransform(iCC_ColorSpace.getProfile(), -1, 1);
            try {
                colorTransformArray[1] = pCMM.createTransform(this.thisProfile, 1, 2);
            }
            catch (CMMException cMMException) {
                colorTransformArray[1] = CMSManager.getModule().createTransform(this.thisProfile, -1, 2);
            }
            this.xyz2this = pCMM.createTransform(colorTransformArray);
            if (this.needScaleInit) {
                this.setComponentScaling();
            }
        }
        colorTransformArray = (ColorTransform[])new short[3];
        float f = 1.9999695f;
        float f2 = 65535.0f / f;
        for (n = 0; n < 3; ++n) {
            colorTransformArray[n] = (ColorTransform)((short)(fArray[n] * f2 + 0.5f));
        }
        colorTransformArray = (ColorTransform[])this.xyz2this.colorConvert((short[])colorTransformArray, null);
        n = this.getNumComponents();
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = (float)(colorTransformArray[i] & 0xFFFF) / 65535.0f * this.diffMinMax[i] + this.minVal[i];
        }
        return fArray2;
    }

    @Override
    public float getMinValue(int n) {
        if (n < 0 || n > this.getNumComponents() - 1) {
            throw new IllegalArgumentException("Component index out of range: + component");
        }
        return this.minVal[n];
    }

    @Override
    public float getMaxValue(int n) {
        if (n < 0 || n > this.getNumComponents() - 1) {
            throw new IllegalArgumentException("Component index out of range: + component");
        }
        return this.maxVal[n];
    }

    private void setMinMax() {
        int n = this.getNumComponents();
        int n2 = this.getType();
        this.minVal = new float[n];
        this.maxVal = new float[n];
        if (n2 == 1) {
            this.minVal[0] = 0.0f;
            this.maxVal[0] = 100.0f;
            this.minVal[1] = -128.0f;
            this.maxVal[1] = 127.0f;
            this.minVal[2] = -128.0f;
            this.maxVal[2] = 127.0f;
        } else if (n2 == 0) {
            this.minVal[2] = 0.0f;
            this.minVal[1] = 0.0f;
            this.minVal[0] = 0.0f;
            this.maxVal[2] = 1.9999695f;
            this.maxVal[1] = 1.9999695f;
            this.maxVal[0] = 1.9999695f;
        } else {
            for (int i = 0; i < n; ++i) {
                this.minVal[i] = 0.0f;
                this.maxVal[i] = 1.0f;
            }
        }
    }

    private void setComponentScaling() {
        int n = this.getNumComponents();
        this.diffMinMax = new float[n];
        this.invDiffMinMax = new float[n];
        for (int i = 0; i < n; ++i) {
            this.minVal[i] = this.getMinValue(i);
            this.maxVal[i] = this.getMaxValue(i);
            this.diffMinMax[i] = this.maxVal[i] - this.minVal[i];
            this.invDiffMinMax[i] = 65535.0f / this.diffMinMax[i];
        }
        this.needScaleInit = false;
    }
}

