/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.generic.CPInstruction;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.PushInstruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import com.sun.org.apache.bcel.internal.generic.Visitor;

public class LDC2_W
extends CPInstruction
implements PushInstruction,
TypedInstruction {
    LDC2_W() {
    }

    public LDC2_W(int n) {
        super((short)20, n);
    }

    @Override
    public Type getType(ConstantPoolGen constantPoolGen) {
        switch (constantPoolGen.getConstantPool().getConstant(this.index).getTag()) {
            case 5: {
                return Type.LONG;
            }
            case 6: {
                return Type.DOUBLE;
            }
        }
        throw new RuntimeException("Unknown constant type " + this.opcode);
    }

    public Number getValue(ConstantPoolGen constantPoolGen) {
        Constant constant = constantPoolGen.getConstantPool().getConstant(this.index);
        switch (constant.getTag()) {
            case 5: {
                return new Long(((ConstantLong)constant).getBytes());
            }
            case 6: {
                return new Double(((ConstantDouble)constant).getBytes());
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitStackProducer(this);
        visitor.visitPushInstruction(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitLDC2_W(this);
    }
}

