/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.client.ContentNegotiation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class RequestContext
extends PropertySet {
    private static final Logger LOGGER = Logger.getLogger(RequestContext.class.getName());
    private static ContentNegotiation defaultContentNegotiation = ContentNegotiation.obtainFromSystemProperty();
    private final Map<String, Object> others;
    @NotNull
    private EndpointAddress endpointAddress;
    public ContentNegotiation contentNegotiation = defaultContentNegotiation;
    private String soapAction;
    private Boolean soapActionUse;
    private final MapView mapView = new MapView();
    private static final PropertySet.PropertyMap propMap = RequestContext.parse(RequestContext.class);

    @PropertySet.Property(value={"javax.xml.ws.service.endpoint.address"})
    public String getEndPointAddressString() {
        return this.endpointAddress.toString();
    }

    public void setEndPointAddressString(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.endpointAddress = EndpointAddress.create(string);
    }

    public void setEndpointAddress(@NotNull EndpointAddress endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    @NotNull
    public EndpointAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.client.ContentNegotiation"})
    public String getContentNegotiationString() {
        return this.contentNegotiation.toString();
    }

    public void setContentNegotiationString(String string) {
        if (string == null) {
            this.contentNegotiation = ContentNegotiation.none;
        } else {
            try {
                this.contentNegotiation = ContentNegotiation.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.contentNegotiation = ContentNegotiation.none;
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.uri"})
    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        if (string == null) {
            throw new IllegalArgumentException("SOAPAction value cannot be null");
        }
        this.soapAction = string;
    }

    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.use"})
    public Boolean getSoapActionUse() {
        return this.soapActionUse;
    }

    public void setSoapActionUse(Boolean bl) {
        this.soapActionUse = bl;
    }

    RequestContext() {
        this.others = new HashMap<String, Object>();
    }

    private RequestContext(RequestContext requestContext) {
        this.others = new HashMap<String, Object>(requestContext.others);
        this.endpointAddress = requestContext.endpointAddress;
        this.soapAction = requestContext.soapAction;
        this.contentNegotiation = requestContext.contentNegotiation;
    }

    @Override
    public Object get(Object object) {
        if (super.supports(object)) {
            return super.get(object);
        }
        return this.others.get(object);
    }

    @Override
    public Object put(String string, Object object) {
        if (super.supports(string)) {
            return super.put(string, object);
        }
        return this.others.put(string, object);
    }

    public Map<String, Object> getMapView() {
        return this.mapView;
    }

    public void fill(Packet packet, boolean bl) {
        if (this.mapView.fallbackMap == null) {
            if (this.endpointAddress != null) {
                packet.endpointAddress = this.endpointAddress;
            }
            packet.contentNegotiation = this.contentNegotiation;
            if ((this.soapActionUse != null && this.soapActionUse.booleanValue() || this.soapActionUse == null && bl) && this.soapAction != null) {
                packet.soapAction = this.soapAction;
            }
            if (!(bl || this.soapActionUse != null && this.soapActionUse.booleanValue() || this.soapAction == null)) {
                LOGGER.warning("BindingProvider.SOAPACTION_URI_PROPERTY is set in the RequestContext but is ineffective, Either set BindingProvider.SOAPACTION_USE_PROPERTY to true or enable AddressingFeature");
            }
            if (!this.others.isEmpty()) {
                packet.invocationProperties.putAll(this.others);
                packet.getHandlerScopePropertyNames(false).addAll(this.others.keySet());
            }
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry entry : this.mapView.fallbackMap.entrySet()) {
                String string = (String)entry.getKey();
                if (packet.supports(string)) {
                    packet.put(string, entry.getValue());
                } else {
                    packet.invocationProperties.put(string, entry.getValue());
                }
                if (super.supports(string)) continue;
                hashSet.add(string);
            }
            if (!hashSet.isEmpty()) {
                packet.getHandlerScopePropertyNames(false).addAll(hashSet);
            }
        }
    }

    public RequestContext copy() {
        return new RequestContext(this);
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return propMap;
    }

    private final class MapView
    implements Map<String, Object> {
        private Map<String, Object> fallbackMap;

        private MapView() {
        }

        private Map<String, Object> fallback() {
            if (this.fallbackMap == null) {
                this.fallbackMap = new HashMap<String, Object>(RequestContext.this.others);
                for (Map.Entry entry : propMap.entrySet()) {
                    this.fallbackMap.put((String)entry.getKey(), ((PropertySet.Accessor)entry.getValue()).get(RequestContext.this));
                }
            }
            return this.fallbackMap;
        }

        @Override
        public int size() {
            return this.fallback().size();
        }

        @Override
        public boolean isEmpty() {
            return this.fallback().isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.fallback().containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.fallback().containsValue(object);
        }

        @Override
        public Object get(Object object) {
            if (this.fallbackMap == null) {
                return RequestContext.this.get(object);
            }
            return this.fallback().get(object);
        }

        @Override
        public Object put(String string, Object object) {
            if (this.fallbackMap == null) {
                return RequestContext.this.put(string, object);
            }
            return this.fallback().put(string, object);
        }

        @Override
        public Object remove(Object object) {
            if (this.fallbackMap == null) {
                return RequestContext.this.remove(object);
            }
            return this.fallback().remove(object);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.fallback().clear();
        }

        @Override
        public Set<String> keySet() {
            return this.fallback().keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.fallback().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.fallback().entrySet();
        }
    }
}

